/*
 * Decompiled with CFR 0.152.
 */
package junit.tests.runner;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TextRunnerTest
extends TestCase {
    public void testFailure() throws Exception {
        this.execTest("junit.tests.framework.Failure", false);
    }

    public void testSuccess() throws Exception {
        this.execTest("junit.tests.framework.Success", true);
    }

    public void testError() throws Exception {
        this.execTest("junit.tests.BogusDude", false);
    }

    void execTest(String testClass, boolean success) throws Exception {
        String java = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        String cp = System.getProperty("java.class.path");
        String[] cmd = new String[]{java, "-classpath", cp, "junit.textui.TestRunner", testClass};
        Process p = Runtime.getRuntime().exec(cmd);
        InputStream i = p.getInputStream();
        while (i.read() != -1) {
        }
        TextRunnerTest.assertTrue(p.waitFor() == 0 == success);
        if (success) {
            TextRunnerTest.assertTrue(p.exitValue() == 0);
        } else {
            TextRunnerTest.assertFalse(p.exitValue() == 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRunReturnsResult() {
        PrintStream oldOut = System.out;
        System.setOut(new PrintStream(new OutputStream(){

            public void write(int arg0) throws IOException {
            }
        }));
        try {
            TestResult result = TestRunner.run(new TestSuite());
            TextRunnerTest.assertTrue(result.wasSuccessful());
        }
        finally {
            System.setOut(oldOut);
        }
    }
}

