/*
 * Decompiled with CFR 0.152.
 */
package jruby.objectweb.asm.util;

import java.util.HashMap;
import jruby.objectweb.asm.AnnotationVisitor;
import jruby.objectweb.asm.Attribute;
import jruby.objectweb.asm.Type;
import jruby.objectweb.asm.util.ASMifiable;
import jruby.objectweb.asm.util.ASMifierAnnotationVisitor;
import jruby.objectweb.asm.util.AbstractVisitor;

public class ASMifierAbstractVisitor
extends AbstractVisitor {
    protected String name;
    HashMap labelNames;

    protected ASMifierAbstractVisitor(String string) {
        this.name = string;
    }

    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        this.buf.setLength(0);
        this.buf.append("{\n").append("av0 = ").append(this.name).append(".visitAnnotation(");
        this.appendConstant(string);
        this.buf.append(", ").append(bl).append(");\n");
        this.text.add(this.buf.toString());
        ASMifierAnnotationVisitor aSMifierAnnotationVisitor = new ASMifierAnnotationVisitor(0);
        this.text.add(aSMifierAnnotationVisitor.getText());
        this.text.add("}\n");
        return aSMifierAnnotationVisitor;
    }

    public void visitAttribute(Attribute attribute) {
        this.buf.setLength(0);
        this.buf.append("// ATTRIBUTE ").append(attribute.type).append("\n");
        if (attribute instanceof ASMifiable) {
            this.buf.append("{\n");
            ((ASMifiable)((Object)attribute)).asmify(this.buf, "attr", this.labelNames);
            this.buf.append(this.name).append(".visitAttribute(attr);\n");
            this.buf.append("}\n");
        }
        this.text.add(this.buf.toString());
    }

    public void visitEnd() {
        this.buf.setLength(0);
        this.buf.append(this.name).append(".visitEnd();\n");
        this.text.add(this.buf.toString());
    }

    void appendConstant(Object object) {
        ASMifierAbstractVisitor.appendConstant(this.buf, object);
    }

    static void appendConstant(StringBuffer stringBuffer, Object object) {
        if (object == null) {
            stringBuffer.append("null");
        } else if (object instanceof String) {
            ASMifierAbstractVisitor.appendString(stringBuffer, (String)object);
        } else if (object instanceof Type) {
            stringBuffer.append("Type.getType(\"");
            stringBuffer.append(((Type)object).getDescriptor());
            stringBuffer.append("\")");
        } else if (object instanceof Byte) {
            stringBuffer.append("new Byte((byte)").append(object).append(')');
        } else if (object instanceof Boolean) {
            stringBuffer.append((Boolean)object != false ? "Boolean.TRUE" : "Boolean.FALSE");
        } else if (object instanceof Short) {
            stringBuffer.append("new Short((short)").append(object).append(')');
        } else if (object instanceof Character) {
            char c = ((Character)object).charValue();
            stringBuffer.append("new Character((char)").append((int)c).append(')');
        } else if (object instanceof Integer) {
            stringBuffer.append("new Integer(").append(object).append(')');
        } else if (object instanceof Float) {
            stringBuffer.append("new Float(\"").append(object).append("\")");
        } else if (object instanceof Long) {
            stringBuffer.append("new Long(").append(object).append("L)");
        } else if (object instanceof Double) {
            stringBuffer.append("new Double(\"").append(object).append("\")");
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            stringBuffer.append("new byte[] {");
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append(i == 0 ? "" : ",").append(byArray[i]);
            }
            stringBuffer.append('}');
        } else if (object instanceof boolean[]) {
            boolean[] blArray = (boolean[])object;
            stringBuffer.append("new boolean[] {");
            for (int i = 0; i < blArray.length; ++i) {
                stringBuffer.append(i == 0 ? "" : ",").append(blArray[i]);
            }
            stringBuffer.append('}');
        } else if (object instanceof short[]) {
            short[] sArray = (short[])object;
            stringBuffer.append("new short[] {");
            for (int i = 0; i < sArray.length; ++i) {
                stringBuffer.append(i == 0 ? "" : ",").append("(short)").append(sArray[i]);
            }
            stringBuffer.append('}');
        } else if (object instanceof char[]) {
            char[] cArray = (char[])object;
            stringBuffer.append("new char[] {");
            for (int i = 0; i < cArray.length; ++i) {
                stringBuffer.append(i == 0 ? "" : ",").append("(char)").append((int)cArray[i]);
            }
            stringBuffer.append('}');
        } else if (object instanceof int[]) {
            int[] nArray = (int[])object;
            stringBuffer.append("new int[] {");
            for (int i = 0; i < nArray.length; ++i) {
                stringBuffer.append(i == 0 ? "" : ",").append(nArray[i]);
            }
            stringBuffer.append('}');
        } else if (object instanceof long[]) {
            long[] lArray = (long[])object;
            stringBuffer.append("new long[] {");
            for (int i = 0; i < lArray.length; ++i) {
                stringBuffer.append(i == 0 ? "" : ",").append(lArray[i]).append('L');
            }
            stringBuffer.append('}');
        } else if (object instanceof float[]) {
            float[] fArray = (float[])object;
            stringBuffer.append("new float[] {");
            for (int i = 0; i < fArray.length; ++i) {
                stringBuffer.append(i == 0 ? "" : ",").append(fArray[i]).append('f');
            }
            stringBuffer.append('}');
        } else if (object instanceof double[]) {
            double[] dArray = (double[])object;
            stringBuffer.append("new double[] {");
            for (int i = 0; i < dArray.length; ++i) {
                stringBuffer.append(i == 0 ? "" : ",").append(dArray[i]).append('d');
            }
            stringBuffer.append('}');
        }
    }
}

