/*
 * Decompiled with CFR 0.152.
 */
package sun.text.normalizer;

import java.io.IOException;
import java.util.MissingResourceException;
import sun.text.normalizer.UBiDiProps;
import sun.text.normalizer.UCharacterProperty;
import sun.text.normalizer.UTF16;
import sun.text.normalizer.VersionInfo;

public final class UCharacter {
    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = 0x10FFFF;
    public static final int SUPPLEMENTARY_MIN_VALUE = 65536;
    private static final UCharacterProperty PROPERTY_;
    private static final char[] PROPERTY_TRIE_INDEX_;
    private static final char[] PROPERTY_TRIE_DATA_;
    private static final int PROPERTY_INITIAL_VALUE_;
    private static final UBiDiProps gBdp;
    private static final int NUMERIC_TYPE_SHIFT_ = 5;
    private static final int NUMERIC_TYPE_MASK_ = 224;

    public static int digit(int n, int n2) {
        int n3 = UCharacter.getProperty(n);
        int n4 = UCharacter.getNumericType(n3) == 1 ? UCharacterProperty.getUnsignedValue(n3) : UCharacter.getEuropeanDigit(n);
        return 0 <= n4 && n4 < n2 ? n4 : -1;
    }

    public static int getDirection(int n) {
        return gBdp.getClass(n);
    }

    public static int getCodePoint(char c, char c2) {
        if (UTF16.isLeadSurrogate(c) && UTF16.isTrailSurrogate(c2)) {
            return UCharacterProperty.getRawSupplementary(c, c2);
        }
        throw new IllegalArgumentException("Illegal surrogate characters");
    }

    public static VersionInfo getAge(int n) {
        if (n < 0 || n > 0x10FFFF) {
            throw new IllegalArgumentException("Codepoint out of bounds");
        }
        return PROPERTY_.getAge(n);
    }

    private static int getEuropeanDigit(int n) {
        if (n > 122 && n < 65313 || n < 65 || n > 90 && n < 97 || n > 65370 || n > 65329 && n < 65345) {
            return -1;
        }
        if (n <= 122) {
            return n + 10 - (n <= 90 ? 65 : 97);
        }
        if (n <= 65338) {
            return n + 10 - 65313;
        }
        return n + 10 - 65345;
    }

    private static int getNumericType(int n) {
        return (n & 0xE0) >> 5;
    }

    private static final int getProperty(int n) {
        if (n < 55296 || n > 56319 && n < 65536) {
            try {
                return PROPERTY_TRIE_DATA_[(PROPERTY_TRIE_INDEX_[n >> 5] << 2) + (n & 0x1F)];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return PROPERTY_INITIAL_VALUE_;
            }
        }
        if (n <= 56319) {
            return PROPERTY_TRIE_DATA_[(PROPERTY_TRIE_INDEX_[320 + (n >> 5)] << 2) + (n & 0x1F)];
        }
        if (n <= 0x10FFFF) {
            return UCharacter.PROPERTY_.m_trie_.getSurrogateValue(UTF16.getLeadSurrogate(n), (char)(n & 0x3FF));
        }
        return PROPERTY_INITIAL_VALUE_;
    }

    static {
        UBiDiProps uBiDiProps;
        try {
            PROPERTY_ = UCharacterProperty.getInstance();
            PROPERTY_TRIE_INDEX_ = UCharacter.PROPERTY_.m_trieIndex_;
            PROPERTY_TRIE_DATA_ = UCharacter.PROPERTY_.m_trieData_;
            PROPERTY_INITIAL_VALUE_ = UCharacter.PROPERTY_.m_trieInitialValue_;
        }
        catch (Exception exception) {
            throw new MissingResourceException(exception.getMessage(), "", "");
        }
        try {
            uBiDiProps = UBiDiProps.getSingleton();
        }
        catch (IOException iOException) {
            uBiDiProps = UBiDiProps.getDummy();
        }
        gBdp = uBiDiProps;
    }

    public static interface NumericType {
        public static final int DECIMAL = 1;
    }
}

