/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.net.URI;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import sun.nio.ch.ThreadPool;
import sun.nio.fs.UnixChannelFactory;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileModeAttribute;
import sun.nio.fs.UnixFileSystem;
import sun.nio.fs.UnixPath;
import sun.nio.fs.UnixUriUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UnixFileSystemProvider
extends FileSystemProvider {
    private static final String USER_DIR = "user.dir";
    private final UnixFileSystem theFileSystem;

    public UnixFileSystemProvider() {
        String string = System.getProperty(USER_DIR);
        this.theFileSystem = this.newFileSystem(string);
    }

    abstract UnixFileSystem newFileSystem(String var1);

    @Override
    public final String getScheme() {
        return "file";
    }

    private void checkUri(URI uRI) {
        if (!uRI.getScheme().equalsIgnoreCase(this.getScheme())) {
            throw new IllegalArgumentException("URI does not match this provider");
        }
        if (uRI.getAuthority() != null) {
            throw new IllegalArgumentException("Authority component present");
        }
        if (uRI.getPath() == null) {
            throw new IllegalArgumentException("Path component is undefined");
        }
        if (!uRI.getPath().equals("/")) {
            throw new IllegalArgumentException("Path component should be '/'");
        }
        if (uRI.getQuery() != null) {
            throw new IllegalArgumentException("Query component present");
        }
        if (uRI.getFragment() != null) {
            throw new IllegalArgumentException("Fragment component present");
        }
    }

    @Override
    public final FileSystem newFileSystem(URI uRI, Map<String, ?> map) {
        this.checkUri(uRI);
        throw new FileSystemAlreadyExistsException();
    }

    @Override
    public final FileSystem getFileSystem(URI uRI) {
        this.checkUri(uRI);
        return this.theFileSystem;
    }

    @Override
    public Path getPath(URI uRI) {
        return UnixUriUtils.fromUri(this.theFileSystem, uRI);
    }

    private UnixPath checkPath(Path path) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (!(path instanceof UnixPath)) {
            throw new ProviderMismatchException();
        }
        return (UnixPath)path;
    }

    @Override
    public final FileChannel newFileChannel(Path path, Set<? extends OpenOption> set, FileAttribute<?> ... fileAttributeArray) throws IOException {
        UnixPath unixPath = this.checkPath(path);
        int n = UnixFileModeAttribute.toUnixMode(438, fileAttributeArray);
        try {
            return UnixChannelFactory.newFileChannel(unixPath, set, n);
        }
        catch (UnixException unixException) {
            unixException.rethrowAsIOException(unixPath);
            return null;
        }
    }

    @Override
    public final AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set<? extends OpenOption> set, ExecutorService executorService, FileAttribute<?> ... fileAttributeArray) throws IOException {
        UnixPath unixPath = this.checkPath(path);
        int n = UnixFileModeAttribute.toUnixMode(438, fileAttributeArray);
        ThreadPool threadPool = executorService == null ? null : ThreadPool.wrap(executorService, 0);
        try {
            return UnixChannelFactory.newAsynchronousFileChannel(unixPath, set, n, threadPool);
        }
        catch (UnixException unixException) {
            unixException.rethrowAsIOException(unixPath);
            return null;
        }
    }
}

