/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.nio.channels.AsynchronousChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.ShutdownChannelGroupException;
import java.security.AccessController;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import sun.nio.ch.AbstractFuture;
import sun.nio.ch.AsynchronousChannelGroupImpl;
import sun.nio.ch.Groupable;
import sun.security.action.GetIntegerAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Invoker {
    private static final int maxHandlerInvokeCount = AccessController.doPrivileged(new GetIntegerAction("sun.nio.ch.maxCompletionHandlersOnStack", 16));
    private static final ThreadLocal<GroupAndInvokeCount> myGroupAndInvokeCount = new ThreadLocal<GroupAndInvokeCount>(){

        @Override
        protected GroupAndInvokeCount initialValue() {
            return null;
        }
    };

    private Invoker() {
    }

    static void bindToGroup(AsynchronousChannelGroupImpl asynchronousChannelGroupImpl) {
        myGroupAndInvokeCount.set(new GroupAndInvokeCount(asynchronousChannelGroupImpl));
    }

    static GroupAndInvokeCount getGroupAndInvokeCount() {
        return myGroupAndInvokeCount.get();
    }

    static boolean isBoundToAnyGroup() {
        return myGroupAndInvokeCount.get() != null;
    }

    static boolean mayInvokeDirect(GroupAndInvokeCount groupAndInvokeCount, AsynchronousChannelGroupImpl asynchronousChannelGroupImpl) {
        return groupAndInvokeCount != null && groupAndInvokeCount.group() == asynchronousChannelGroupImpl && groupAndInvokeCount.invokeCount() < maxHandlerInvokeCount;
    }

    static <V, A> void invokeUnchecked(CompletionHandler<V, ? super A> completionHandler, AbstractFuture<V, A> abstractFuture) {
        if (completionHandler != null && !abstractFuture.isCancelled()) {
            Throwable throwable = abstractFuture.exception();
            if (throwable == null) {
                completionHandler.completed(abstractFuture.value(), abstractFuture.attachment());
            } else {
                completionHandler.failed(throwable, abstractFuture.attachment());
            }
            Thread.interrupted();
        }
    }

    static <V, A> void invokeDirect(GroupAndInvokeCount groupAndInvokeCount, CompletionHandler<V, ? super A> completionHandler, AbstractFuture<V, A> abstractFuture) {
        groupAndInvokeCount.incrementInvokeCount();
        Invoker.invokeUnchecked(completionHandler, abstractFuture);
    }

    static <V, A> void invoke(CompletionHandler<V, ? super A> completionHandler, AbstractFuture<V, A> abstractFuture) {
        if (completionHandler != null) {
            boolean bl = false;
            boolean bl2 = false;
            GroupAndInvokeCount groupAndInvokeCount = myGroupAndInvokeCount.get();
            if (groupAndInvokeCount != null) {
                AsynchronousChannel asynchronousChannel = abstractFuture.channel();
                if (groupAndInvokeCount.group() == ((Groupable)((Object)asynchronousChannel)).group()) {
                    bl2 = true;
                }
                if (bl2 && groupAndInvokeCount.invokeCount() < maxHandlerInvokeCount) {
                    bl = true;
                }
            }
            if (bl) {
                groupAndInvokeCount.incrementInvokeCount();
                Invoker.invokeUnchecked(completionHandler, abstractFuture);
            } else {
                try {
                    Invoker.invokeIndirectly(completionHandler, abstractFuture);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    if (bl2) {
                        Invoker.invokeUnchecked(completionHandler, abstractFuture);
                    }
                    throw new ShutdownChannelGroupException();
                }
            }
        }
    }

    static <V, A> void invokeIndirectly(final CompletionHandler<V, ? super A> completionHandler, final AbstractFuture<V, A> abstractFuture) {
        if (completionHandler != null) {
            AsynchronousChannel asynchronousChannel = abstractFuture.channel();
            try {
                ((Groupable)((Object)asynchronousChannel)).group().executeOnPooledThread(new Runnable(){

                    public void run() {
                        GroupAndInvokeCount groupAndInvokeCount = (GroupAndInvokeCount)myGroupAndInvokeCount.get();
                        if (groupAndInvokeCount != null) {
                            groupAndInvokeCount.setInvokeCount(1);
                        }
                        Invoker.invokeUnchecked(completionHandler, abstractFuture);
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                throw new ShutdownChannelGroupException();
            }
        }
    }

    static <V, A> void invokeIndirectly(final CompletionHandler<V, ? super A> completionHandler, final AbstractFuture<V, A> abstractFuture, Executor executor) {
        if (completionHandler != null) {
            try {
                executor.execute(new Runnable(){

                    public void run() {
                        Invoker.invokeUnchecked(completionHandler, abstractFuture);
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                throw new ShutdownChannelGroupException();
            }
        }
    }

    static void invokeOnThreadInThreadPool(Groupable groupable, Runnable runnable) {
        GroupAndInvokeCount groupAndInvokeCount = myGroupAndInvokeCount.get();
        AsynchronousChannelGroupImpl asynchronousChannelGroupImpl = groupable.group();
        boolean bl = groupAndInvokeCount == null ? false : groupAndInvokeCount.group == asynchronousChannelGroupImpl;
        try {
            if (bl) {
                runnable.run();
            } else {
                asynchronousChannelGroupImpl.executeOnPooledThread(runnable);
            }
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            throw new ShutdownChannelGroupException();
        }
    }

    static class GroupAndInvokeCount {
        private final AsynchronousChannelGroupImpl group;
        private int handlerInvokeCount;

        GroupAndInvokeCount(AsynchronousChannelGroupImpl asynchronousChannelGroupImpl) {
            this.group = asynchronousChannelGroupImpl;
        }

        AsynchronousChannelGroupImpl group() {
            return this.group;
        }

        int invokeCount() {
            return this.handlerInvokeCount;
        }

        void setInvokeCount(int n) {
            this.handlerInvokeCount = n;
        }

        void resetInvokeCount() {
            this.handlerInvokeCount = 0;
        }

        void incrementInvokeCount() {
            ++this.handlerInvokeCount;
        }
    }
}

