/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyBoundException;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.ReadPendingException;
import java.nio.channels.WritePendingException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import sun.net.NetHooks;
import sun.nio.ch.AsynchronousChannelGroupImpl;
import sun.nio.ch.Cancellable;
import sun.nio.ch.CompletedFuture;
import sun.nio.ch.Groupable;
import sun.nio.ch.Invoker;
import sun.nio.ch.Net;
import sun.nio.ch.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AsynchronousSocketChannelImpl
extends AsynchronousSocketChannel
implements Cancellable,
Groupable {
    protected final FileDescriptor fd;
    protected final Object stateLock = new Object();
    protected volatile SocketAddress localAddress = null;
    protected volatile SocketAddress remoteAddress = null;
    static final int ST_UNINITIALIZED = -1;
    static final int ST_UNCONNECTED = 0;
    static final int ST_PENDING = 1;
    static final int ST_CONNECTED = 2;
    protected volatile int state = -1;
    private final Object readLock = new Object();
    private boolean reading;
    private boolean readShutdown;
    private boolean readKilled;
    private final Object writeLock = new Object();
    private boolean writing;
    private boolean writeShutdown;
    private boolean writeKilled;
    private final ReadWriteLock closeLock = new ReentrantReadWriteLock();
    private volatile boolean open = true;

    AsynchronousSocketChannelImpl(AsynchronousChannelGroupImpl asynchronousChannelGroupImpl) throws IOException {
        super(asynchronousChannelGroupImpl.provider());
        this.fd = Net.socket(true);
        this.state = 0;
    }

    AsynchronousSocketChannelImpl(AsynchronousChannelGroupImpl asynchronousChannelGroupImpl, FileDescriptor fileDescriptor, InetSocketAddress inetSocketAddress) throws IOException {
        super(asynchronousChannelGroupImpl.provider());
        this.fd = fileDescriptor;
        this.state = 2;
        this.localAddress = Net.localAddress(fileDescriptor);
        this.remoteAddress = inetSocketAddress;
    }

    @Override
    public final boolean isOpen() {
        return this.open;
    }

    final void begin() throws IOException {
        this.closeLock.readLock().lock();
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    final void end() {
        this.closeLock.readLock().unlock();
    }

    abstract void implClose() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        this.closeLock.writeLock().lock();
        try {
            if (!this.open) {
                return;
            }
            this.open = false;
        }
        finally {
            this.closeLock.writeLock().unlock();
        }
        this.implClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void enableReading(boolean bl) {
        Object object = this.readLock;
        synchronized (object) {
            this.reading = false;
            if (bl) {
                this.readKilled = true;
            }
        }
    }

    final void enableReading() {
        this.enableReading(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void enableWriting(boolean bl) {
        Object object = this.writeLock;
        synchronized (object) {
            this.writing = false;
            if (bl) {
                this.writeKilled = true;
            }
        }
    }

    final void enableWriting() {
        this.enableWriting(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void killReading() {
        Object object = this.readLock;
        synchronized (object) {
            this.readKilled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void killWriting() {
        Object object = this.writeLock;
        synchronized (object) {
            this.writeKilled = true;
        }
    }

    final void killConnect() {
        this.killReading();
        this.killWriting();
    }

    abstract <V extends Number, A> Future<V> readImpl(ByteBuffer[] var1, boolean var2, long var3, TimeUnit var5, A var6, CompletionHandler<V, ? super A> var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V extends Number, A> Future<V> read(ByteBuffer[] byteBufferArray, boolean bl, long l, TimeUnit timeUnit, A a, CompletionHandler<V, ? super A> completionHandler) {
        if (!this.isOpen()) {
            CompletedFuture completedFuture = CompletedFuture.withFailure(this, new ClosedChannelException(), a);
            Invoker.invoke(completionHandler, completedFuture);
            return completedFuture;
        }
        if (this.remoteAddress == null) {
            throw new NotYetConnectedException();
        }
        if (l < 0L) {
            throw new IllegalArgumentException("Negative timeout");
        }
        boolean bl2 = bl || byteBufferArray[0].hasRemaining();
        boolean bl3 = false;
        CompletedFuture<Number, A> completedFuture = this.readLock;
        synchronized (completedFuture) {
            if (this.readKilled) {
                throw new RuntimeException("Reading not allowed due to timeout or cancellation");
            }
            if (this.reading) {
                throw new ReadPendingException();
            }
            if (this.readShutdown) {
                bl3 = true;
            } else if (bl2) {
                this.reading = true;
            }
        }
        if (bl3 || !bl2) {
            if (bl) {
                Long l2 = bl3 ? Long.valueOf(-1L) : Long.valueOf(0L);
                completedFuture = CompletedFuture.withResult(this, l2, a);
            } else {
                int n = bl3 ? -1 : 0;
                completedFuture = CompletedFuture.withResult(this, n, a);
            }
            Invoker.invoke(completionHandler, completedFuture);
            return completedFuture;
        }
        return this.readImpl(byteBufferArray, bl, l, timeUnit, a, completionHandler);
    }

    @Override
    public final <A> Future<Integer> read(ByteBuffer byteBuffer, long l, TimeUnit timeUnit, A a, CompletionHandler<Integer, ? super A> completionHandler) {
        if (byteBuffer.isReadOnly()) {
            throw new IllegalArgumentException("Read-only buffer");
        }
        ByteBuffer[] byteBufferArray = new ByteBuffer[]{byteBuffer};
        return this.read(byteBufferArray, false, l, timeUnit, a, completionHandler);
    }

    @Override
    public final <A> Future<Long> read(ByteBuffer[] byteBufferArray, int n, int n2, long l, TimeUnit timeUnit, A a, CompletionHandler<Long, ? super A> completionHandler) {
        if (n < 0 || n2 < 0 || n > byteBufferArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        ByteBuffer[] byteBufferArray2 = Util.subsequence(byteBufferArray, n, n2);
        for (int i = 0; i < byteBufferArray2.length; ++i) {
            if (!byteBufferArray2[i].isReadOnly()) continue;
            throw new IllegalArgumentException("Read-only buffer");
        }
        return this.read(byteBufferArray2, true, l, timeUnit, a, completionHandler);
    }

    abstract <V extends Number, A> Future<V> writeImpl(ByteBuffer[] var1, boolean var2, long var3, TimeUnit var5, A var6, CompletionHandler<V, ? super A> var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V extends Number, A> Future<V> write(ByteBuffer[] byteBufferArray, boolean bl, long l, TimeUnit timeUnit, A a, CompletionHandler<V, ? super A> completionHandler) {
        CompletedFuture<Object, A> completedFuture;
        boolean bl2 = bl || byteBufferArray[0].hasRemaining();
        boolean bl3 = false;
        if (this.isOpen()) {
            if (this.remoteAddress == null) {
                throw new NotYetConnectedException();
            }
            if (l < 0L) {
                throw new IllegalArgumentException("Negative timeout");
            }
            completedFuture = this.writeLock;
            synchronized (completedFuture) {
                if (this.writeKilled) {
                    throw new RuntimeException("Writing not allowed due to timeout or cancellation");
                }
                if (this.writing) {
                    throw new WritePendingException();
                }
                if (this.writeShutdown) {
                    bl3 = true;
                } else if (bl2) {
                    this.writing = true;
                }
            }
        } else {
            bl3 = true;
        }
        if (bl3) {
            completedFuture = CompletedFuture.withFailure(this, new ClosedChannelException(), a);
            Invoker.invoke(completionHandler, completedFuture);
            return completedFuture;
        }
        if (!bl2) {
            completedFuture = bl ? CompletedFuture.withResult(this, 0L, a) : CompletedFuture.withResult(this, 0, a);
            Invoker.invoke(completionHandler, completedFuture);
            return completedFuture;
        }
        return this.writeImpl(byteBufferArray, bl, l, timeUnit, a, completionHandler);
    }

    @Override
    public final <A> Future<Integer> write(ByteBuffer byteBuffer, long l, TimeUnit timeUnit, A a, CompletionHandler<Integer, ? super A> completionHandler) {
        ByteBuffer[] byteBufferArray = new ByteBuffer[]{byteBuffer};
        return this.write(byteBufferArray, false, l, timeUnit, a, completionHandler);
    }

    @Override
    public final <A> Future<Long> write(ByteBuffer[] byteBufferArray, int n, int n2, long l, TimeUnit timeUnit, A a, CompletionHandler<Long, ? super A> completionHandler) {
        if (n < 0 || n2 < 0 || n > byteBufferArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        byteBufferArray = Util.subsequence(byteBufferArray, n, n2);
        return this.write(byteBufferArray, true, l, timeUnit, a, completionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final AsynchronousSocketChannel bind(SocketAddress socketAddress) throws IOException {
        try {
            this.begin();
            Object object = this.stateLock;
            synchronized (object) {
                if (this.state == 1) {
                    throw new ConnectionPendingException();
                }
                if (this.localAddress != null) {
                    throw new AlreadyBoundException();
                }
                InetSocketAddress inetSocketAddress = socketAddress == null ? new InetSocketAddress(0) : Net.checkAddress(socketAddress);
                NetHooks.beforeTcpBind(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                Net.bind(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                this.localAddress = Net.localAddress(this.fd);
            }
        }
        finally {
            this.end();
        }
        return this;
    }

    @Override
    public final SocketAddress getLocalAddress() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        return this.localAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> AsynchronousSocketChannel setOption(SocketOption<T> socketOption, T t) throws IOException {
        if (socketOption == null) {
            throw new NullPointerException();
        }
        if (!this.supportedOptions().contains(socketOption)) {
            throw new UnsupportedOperationException("'" + socketOption + "' not supported");
        }
        try {
            this.begin();
            if (this.writeShutdown) {
                throw new IOException("Connection has been shutdown for writing");
            }
            Net.setSocketOption(this.fd, Net.UNSPEC, socketOption, t);
            AsynchronousSocketChannelImpl asynchronousSocketChannelImpl = this;
            return asynchronousSocketChannelImpl;
        }
        finally {
            this.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> T getOption(SocketOption<T> socketOption) throws IOException {
        if (socketOption == null) {
            throw new NullPointerException();
        }
        if (!this.supportedOptions().contains(socketOption)) {
            throw new UnsupportedOperationException("'" + socketOption + "' not supported");
        }
        try {
            this.begin();
            Object object = Net.getSocketOption(this.fd, Net.UNSPEC, socketOption);
            return (T)object;
        }
        finally {
            this.end();
        }
    }

    @Override
    public final Set<SocketOption<?>> supportedOptions() {
        return DefaultOptionsHolder.defaultOptions;
    }

    @Override
    public final SocketAddress getRemoteAddress() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        return this.remoteAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final AsynchronousSocketChannel shutdownInput() throws IOException {
        try {
            this.begin();
            if (this.remoteAddress == null) {
                throw new NotYetConnectedException();
            }
            Object object = this.readLock;
            synchronized (object) {
                if (!this.readShutdown) {
                    Net.shutdown(this.fd, 0);
                    this.readShutdown = true;
                }
            }
        }
        finally {
            this.end();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final AsynchronousSocketChannel shutdownOutput() throws IOException {
        try {
            this.begin();
            if (this.remoteAddress == null) {
                throw new NotYetConnectedException();
            }
            Object object = this.writeLock;
            synchronized (object) {
                if (!this.writeShutdown) {
                    Net.shutdown(this.fd, 1);
                    this.writeShutdown = true;
                }
            }
        }
        finally {
            this.end();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('[');
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                stringBuilder.append("closed");
            } else {
                switch (this.state) {
                    case 0: {
                        stringBuilder.append("unconnected");
                        break;
                    }
                    case 1: {
                        stringBuilder.append("connection-pending");
                        break;
                    }
                    case 2: {
                        stringBuilder.append("connected");
                        if (this.readShutdown) {
                            stringBuilder.append(" ishut");
                        }
                        if (!this.writeShutdown) break;
                        stringBuilder.append(" oshut");
                    }
                }
                if (this.localAddress != null) {
                    stringBuilder.append(" local=");
                    stringBuilder.append(this.localAddress.toString());
                }
                if (this.remoteAddress != null) {
                    stringBuilder.append(" remote=");
                    stringBuilder.append(this.remoteAddress.toString());
                }
            }
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultOptionsHolder {
        static final Set<SocketOption<?>> defaultOptions = DefaultOptionsHolder.defaultOptions();

        private DefaultOptionsHolder() {
        }

        private static Set<SocketOption<?>> defaultOptions() {
            HashSet<SocketOption<Comparable<Integer>>> hashSet = new HashSet<SocketOption<Comparable<Integer>>>(5);
            hashSet.add(StandardSocketOption.SO_SNDBUF);
            hashSet.add(StandardSocketOption.SO_RCVBUF);
            hashSet.add(StandardSocketOption.SO_KEEPALIVE);
            hashSet.add(StandardSocketOption.SO_REUSEADDR);
            hashSet.add(StandardSocketOption.TCP_NODELAY);
            return Collections.unmodifiableSet(hashSet);
        }
    }
}

