/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.NoSuchFileException;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;

class UnixException
extends Exception {
    static final long serialVersionUID = 7227016794320723218L;
    private int errno;
    private String msg;

    UnixException(int n) {
        this.errno = n;
        this.msg = null;
    }

    UnixException(String string) {
        this.errno = 0;
        this.msg = string;
    }

    int errno() {
        return this.errno;
    }

    void setError(int n) {
        this.errno = n;
        this.msg = null;
    }

    String errorString() {
        if (this.msg != null) {
            return this.msg;
        }
        return new String(UnixNativeDispatcher.strerror(this.errno()));
    }

    public String getMessage() {
        return this.errorString();
    }

    private IOException translateToIOException(String string, String string2) {
        if (this.msg != null) {
            return new IOException(this.msg);
        }
        if (this.errno() == 13) {
            return new AccessDeniedException(string, string2, null);
        }
        if (this.errno() == 2) {
            return new NoSuchFileException(string, string2, null);
        }
        if (this.errno() == 17) {
            return new FileAlreadyExistsException(string, string2, null);
        }
        return new FileSystemException(string, string2, this.errorString());
    }

    void rethrowAsIOException(String string) throws IOException {
        IOException iOException = this.translateToIOException(string, null);
        throw iOException;
    }

    void rethrowAsIOException(UnixPath unixPath, UnixPath unixPath2) throws IOException {
        String string = unixPath == null ? null : unixPath.getPathForExecptionMessage();
        String string2 = unixPath2 == null ? null : unixPath2.getPathForExecptionMessage();
        IOException iOException = this.translateToIOException(string, string2);
        throw iOException;
    }

    void rethrowAsIOException(UnixPath unixPath) throws IOException {
        this.rethrowAsIOException(unixPath, null);
    }

    IOException asIOException(UnixPath unixPath) {
        return this.translateToIOException(unixPath.getPathForExecptionMessage(), null);
    }
}

