/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.FileRef;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.nio.fs.AbstractFileTypeDetector;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.NativeBuffers;
import sun.nio.fs.UnixPath;

public class GnomeFileTypeDetector
extends AbstractFileTypeDetector {
    private static final String GNOME_VFS_MIME_TYPE_UNKNOWN = "application/octet-stream";
    private final boolean gioAvailable = GnomeFileTypeDetector.initializeGio();
    private final boolean gnomeVfsAvailable = this.gioAvailable ? false : GnomeFileTypeDetector.initializeGnomeVfs();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String implProbeContentType(FileRef fileRef) throws IOException {
        if (!this.gioAvailable && !this.gnomeVfsAvailable) {
            return null;
        }
        if (!(fileRef instanceof UnixPath)) {
            return null;
        }
        UnixPath unixPath = (UnixPath)fileRef;
        NativeBuffer nativeBuffer = NativeBuffers.asNativeBuffer(unixPath.getByteArrayForSysCalls());
        try {
            if (this.gioAvailable) {
                byte[] byArray = GnomeFileTypeDetector.probeUsingGio(nativeBuffer.address());
                String string = byArray == null ? null : new String(byArray);
                return string;
            }
            byte[] byArray = GnomeFileTypeDetector.probeUsingGnomeVfs(nativeBuffer.address());
            if (byArray == null) {
                String string = null;
                return string;
            }
            String string = new String(byArray);
            String string2 = string.equals(GNOME_VFS_MIME_TYPE_UNKNOWN) ? null : string;
            return string2;
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native boolean initializeGio();

    private static native byte[] probeUsingGio(long var0);

    private static native boolean initializeGnomeVfs();

    private static native byte[] probeUsingGnomeVfs(long var0);

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("nio");
                return null;
            }
        });
    }
}

