/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractUserDefinedFileAttributeView
implements UserDefinedFileAttributeView {
    protected AbstractUserDefinedFileAttributeView() {
    }

    protected void checkAccess(String string, boolean bl, boolean bl2) {
        assert (bl || bl2);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (bl) {
                securityManager.checkRead(string);
            }
            if (bl2) {
                securityManager.checkWrite(string);
            }
            securityManager.checkPermission(new RuntimePermission("accessUserDefinedAttributes"));
        }
    }

    @Override
    public final String name() {
        return "xattr";
    }

    @Override
    public final Object getAttribute(String string) throws IOException {
        int n;
        try {
            n = this.size(string);
        }
        catch (IOException iOException) {
            if (this.list().contains(string)) {
                throw iOException;
            }
            return null;
        }
        byte[] byArray = new byte[n];
        int n2 = this.read(string, ByteBuffer.wrap(byArray));
        return n2 == n ? byArray : Arrays.copyOf(byArray, n2);
    }

    @Override
    public final void setAttribute(String string, Object object) throws IOException {
        ByteBuffer byteBuffer = object instanceof byte[] ? ByteBuffer.wrap((byte[])object) : (ByteBuffer)object;
        this.write(string, byteBuffer);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Map<String, ?> readAttributes(String string, String ... stringArray) throws IOException {
        void string2;
        List<Object> list = new ArrayList<String>();
        boolean bl = false;
        if (string.equals("*")) {
            bl = true;
        } else {
            list.add(string);
        }
        Object hashMap = stringArray;
        int n = ((String[])hashMap).length;
        boolean bl2 = false;
        while (string2 < n) {
            String string3 = hashMap[string2];
            if (string3.equals("*")) {
                bl = true;
            } else {
                list.add(string3);
            }
            ++string2;
        }
        if (bl) {
            list = this.list();
        }
        hashMap = new HashMap();
        for (String string4 : list) {
            Object object = this.getAttribute(string4);
            if (object == null) continue;
            hashMap.put(string4, object);
        }
        return hashMap;
    }
}

