/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.attribute.FileStoreSpaceAttributeView;
import java.nio.file.attribute.FileStoreSpaceAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractFileStoreSpaceAttributeView
implements FileStoreSpaceAttributeView {
    private static final String TOTAL_SPACE_NAME = "totalSpace";
    private static final String USABLE_SPACE_NAME = "usableSpace";
    private static final String UNALLOCATED_SPACE_NAME = "unallocatedSpace";

    AbstractFileStoreSpaceAttributeView() {
    }

    @Override
    public final String name() {
        return "space";
    }

    @Override
    public final Object getAttribute(String string) throws IOException {
        FileStoreSpaceAttributes fileStoreSpaceAttributes = this.readAttributes();
        if (string.equals(TOTAL_SPACE_NAME)) {
            return fileStoreSpaceAttributes.totalSpace();
        }
        if (string.equals(USABLE_SPACE_NAME)) {
            return fileStoreSpaceAttributes.usableSpace();
        }
        if (string.equals(UNALLOCATED_SPACE_NAME)) {
            return fileStoreSpaceAttributes.unallocatedSpace();
        }
        return null;
    }

    @Override
    public final void setAttribute(String string, Object object) throws IOException {
        if (string == null || object == null) {
            throw new NullPointerException();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public final Map<String, ?> readAttributes(String string, String[] stringArray) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (string.equals(TOTAL_SPACE_NAME)) {
            bl = true;
        } else if (string.equals(USABLE_SPACE_NAME)) {
            bl2 = true;
        } else if (string.equals(UNALLOCATED_SPACE_NAME)) {
            bl3 = true;
        } else if (string.equals("*")) {
            bl = true;
            bl2 = true;
            bl3 = true;
        }
        if (!(bl && bl2 && bl3)) {
            for (String string2 : stringArray) {
                if (string2.equals("*")) {
                    bl = true;
                    bl2 = true;
                    bl3 = true;
                    break;
                }
                if (string2.equals(TOTAL_SPACE_NAME)) {
                    bl = true;
                    continue;
                }
                if (string2.equals(USABLE_SPACE_NAME)) {
                    bl2 = true;
                    continue;
                }
                if (!string2.equals(UNALLOCATED_SPACE_NAME)) continue;
                bl3 = true;
            }
        }
        FileStoreSpaceAttributes fileStoreSpaceAttributes = this.readAttributes();
        HashMap<String, Long> hashMap = new HashMap<String, Long>(2);
        if (bl) {
            hashMap.put(TOTAL_SPACE_NAME, fileStoreSpaceAttributes.totalSpace());
        }
        if (bl2) {
            hashMap.put(USABLE_SPACE_NAME, fileStoreSpaceAttributes.usableSpace());
        }
        if (bl3) {
            hashMap.put(UNALLOCATED_SPACE_NAME, fileStoreSpaceAttributes.unallocatedSpace());
        }
        return Collections.unmodifiableMap(hashMap);
    }
}

