/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.InterruptedByTimeoutException;
import java.nio.channels.ShutdownChannelGroupException;
import java.security.AccessController;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import sun.net.NetHooks;
import sun.nio.ch.AbstractFuture;
import sun.nio.ch.AsynchronousChannelGroupImpl;
import sun.nio.ch.AsynchronousSocketChannelImpl;
import sun.nio.ch.CompletedFuture;
import sun.nio.ch.IOUtil;
import sun.nio.ch.Invoker;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.Net;
import sun.nio.ch.PendingFuture;
import sun.nio.ch.Port;
import sun.nio.ch.SocketDispatcher;
import sun.nio.ch.Util;
import sun.security.action.GetPropertyAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UnixAsynchronousSocketChannelImpl
extends AsynchronousSocketChannelImpl
implements Port.PollableChannel {
    private static final NativeDispatcher nd = new SocketDispatcher();
    private static final boolean disableSynchronousRead;
    private final Port port;
    private final int fdVal;
    private final Object updateLock = new Object();
    private PendingFuture<Void, Object> pendingConnect;
    private SocketAddress pendingRemote;
    private ByteBuffer[] readBuffers;
    private boolean scatteringRead;
    private PendingFuture<Number, Object> pendingRead;
    private ByteBuffer[] writeBuffers;
    private boolean gatheringWrite;
    private PendingFuture<Number, Object> pendingWrite;
    private Runnable readTimeoutTask = new Runnable(){

        public void run() {
            PendingFuture<Number, Object> pendingFuture = UnixAsynchronousSocketChannelImpl.this.grabPendingRead();
            if (pendingFuture == null) {
                return;
            }
            UnixAsynchronousSocketChannelImpl.this.enableReading(true);
            pendingFuture.setFailure(new InterruptedByTimeoutException());
            Invoker.invokeIndirectly(pendingFuture.handler(), pendingFuture);
        }
    };
    private Runnable writeTimeoutTask = new Runnable(){

        public void run() {
            PendingFuture<Number, Object> pendingFuture = UnixAsynchronousSocketChannelImpl.this.grabPendingWrite();
            if (pendingFuture == null) {
                return;
            }
            UnixAsynchronousSocketChannelImpl.this.enableWriting(true);
            pendingFuture.setFailure(new InterruptedByTimeoutException());
            Invoker.invokeIndirectly(pendingFuture.handler(), pendingFuture);
        }
    };

    UnixAsynchronousSocketChannelImpl(Port port) throws IOException {
        super(port);
        try {
            IOUtil.configureBlocking(this.fd, false);
        }
        catch (IOException iOException) {
            nd.close(this.fd);
            throw iOException;
        }
        this.port = port;
        this.fdVal = IOUtil.fdVal(this.fd);
        port.register(this.fdVal, this);
    }

    UnixAsynchronousSocketChannelImpl(Port port, FileDescriptor fileDescriptor, InetSocketAddress inetSocketAddress) throws IOException {
        super(port, fileDescriptor, inetSocketAddress);
        this.fdVal = IOUtil.fdVal(fileDescriptor);
        IOUtil.configureBlocking(fileDescriptor, false);
        try {
            port.register(this.fdVal, this);
        }
        catch (ShutdownChannelGroupException shutdownChannelGroupException) {
            throw new IOException(shutdownChannelGroupException);
        }
        this.port = port;
    }

    @Override
    public AsynchronousChannelGroupImpl group() {
        return this.port;
    }

    private void updateEvents() {
        assert (Thread.holdsLock(this.updateLock));
        int n = 0;
        if (this.pendingRead != null) {
            n |= 1;
        }
        if (this.pendingConnect != null || this.pendingWrite != null) {
            n |= 4;
        }
        if (n != 0) {
            this.port.startPoll(this.fdVal, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(int n) {
        boolean bl;
        boolean bl2 = (n & 1) > 0;
        boolean bl3 = bl = (n & 4) > 0;
        if ((n & 0x18) > 0) {
            bl2 = true;
            bl = true;
        }
        PendingFuture<Void, Object> pendingFuture = null;
        PendingFuture<Number, Object> pendingFuture2 = null;
        PendingFuture<Number, Object> pendingFuture3 = null;
        Object object = this.updateLock;
        synchronized (object) {
            if (bl2 && this.pendingRead != null) {
                pendingFuture2 = this.pendingRead;
                this.pendingRead = null;
            }
            if (bl) {
                if (this.pendingWrite != null) {
                    pendingFuture3 = this.pendingWrite;
                    this.pendingWrite = null;
                } else if (this.pendingConnect != null) {
                    pendingFuture = this.pendingConnect;
                    this.pendingConnect = null;
                }
            }
        }
        if (pendingFuture2 != null) {
            if (pendingFuture3 != null) {
                this.finishWrite(pendingFuture3, false);
            }
            this.finishRead(pendingFuture2, true);
            return;
        }
        if (pendingFuture3 != null) {
            this.finishWrite(pendingFuture3, true);
        }
        if (pendingFuture != null) {
            this.finishConnect(pendingFuture, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PendingFuture<Number, Object> grabPendingRead() {
        Object object = this.updateLock;
        synchronized (object) {
            PendingFuture<Number, Object> pendingFuture = this.pendingRead;
            this.pendingRead = null;
            return pendingFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PendingFuture<Number, Object> grabPendingWrite() {
        Object object = this.updateLock;
        synchronized (object) {
            PendingFuture<Number, Object> pendingFuture = this.pendingWrite;
            this.pendingWrite = null;
            return pendingFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void implClose() throws IOException {
        PendingFuture<Number, Object> pendingFuture;
        PendingFuture<Number, Object> pendingFuture2;
        PendingFuture<Void, Object> pendingFuture3;
        this.port.unregister(this.fdVal);
        nd.close(this.fd);
        Object object = this.updateLock;
        synchronized (object) {
            pendingFuture3 = this.pendingConnect;
            this.pendingConnect = null;
            pendingFuture2 = this.pendingRead;
            this.pendingRead = null;
            pendingFuture = this.pendingWrite;
            this.pendingWrite = null;
        }
        if (pendingFuture3 != null) {
            this.finishConnect(pendingFuture3, false);
        }
        if (pendingFuture2 != null) {
            this.finishRead(pendingFuture2, false);
        }
        if (pendingFuture != null) {
            this.finishWrite(pendingFuture, false);
        }
    }

    @Override
    public void onCancel(PendingFuture<?, ?> pendingFuture) {
        if (pendingFuture.getContext() == OpType.CONNECT) {
            this.killConnect();
        }
        if (pendingFuture.getContext() == OpType.READ) {
            this.killConnect();
        }
        if (pendingFuture.getContext() == OpType.WRITE) {
            this.killConnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setConnected() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.state = 2;
            this.localAddress = Net.localAddress(this.fd);
            this.remoteAddress = this.pendingRemote;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishConnect(PendingFuture<Void, Object> pendingFuture, boolean bl) {
        Throwable throwable = null;
        try {
            this.begin();
            UnixAsynchronousSocketChannelImpl.checkConnect(this.fdVal);
            this.setConnected();
            pendingFuture.setResult(null);
        }
        catch (Throwable throwable2) {
            AsynchronousCloseException asynchronousCloseException;
            if (throwable2 instanceof ClosedChannelException) {
                asynchronousCloseException = new AsynchronousCloseException();
            }
            throwable = asynchronousCloseException;
        }
        finally {
            this.end();
        }
        if (throwable != null) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            pendingFuture.setFailure(throwable);
        }
        if (bl) {
            Invoker.invoke(pendingFuture.handler(), pendingFuture);
        } else {
            Invoker.invokeIndirectly(pendingFuture.handler(), pendingFuture);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> Future<Void> connect(SocketAddress socketAddress, A a, CompletionHandler<Void, ? super A> completionHandler) {
        boolean bl;
        if (!this.isOpen()) {
            CompletedFuture completedFuture = CompletedFuture.withFailure(this, new ClosedChannelException(), a);
            Invoker.invoke(completionHandler, completedFuture);
            return completedFuture;
        }
        InetSocketAddress inetSocketAddress = Net.checkAddress(socketAddress);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
        }
        AbstractFuture abstractFuture = this.stateLock;
        synchronized (abstractFuture) {
            if (this.state == 2) {
                throw new AlreadyConnectedException();
            }
            if (this.state == 1) {
                throw new ConnectionPendingException();
            }
            this.state = 1;
            this.pendingRemote = socketAddress;
            bl = this.localAddress == null;
        }
        abstractFuture = null;
        Throwable throwable = null;
        try {
            int n;
            this.begin();
            if (bl) {
                NetHooks.beforeTcpConnect(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
            }
            if ((n = Net.connect(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort())) == -2) {
                abstractFuture = new PendingFuture<Void, A>(this, completionHandler, a, (Object)OpType.CONNECT);
                AbstractFuture abstractFuture2 = this.updateLock;
                synchronized (abstractFuture2) {
                    this.pendingConnect = (PendingFuture)abstractFuture;
                    this.updateEvents();
                }
                abstractFuture2 = abstractFuture;
                return abstractFuture2;
            }
            this.setConnected();
            abstractFuture = CompletedFuture.withResult(this, null, a);
        }
        catch (Throwable throwable2) {
            AsynchronousCloseException asynchronousCloseException;
            if (throwable2 instanceof ClosedChannelException) {
                asynchronousCloseException = new AsynchronousCloseException();
            }
            throwable = asynchronousCloseException;
        }
        finally {
            this.end();
        }
        if (throwable != null) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            abstractFuture = CompletedFuture.withFailure(this, throwable, a);
        }
        Invoker.invoke(completionHandler, abstractFuture);
        return abstractFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishRead(PendingFuture<Number, Object> pendingFuture, boolean bl) {
        int n = -1;
        PendingFuture<Number, Object> pendingFuture2 = null;
        try {
            this.begin();
            Object object = this.readBuffers;
            n = ((ByteBuffer[])object).length == 1 ? IOUtil.read(this.fd, object[0], -1L, nd, null) : (int)IOUtil.read(this.fd, object, nd);
            if (n == -2) {
                pendingFuture2 = pendingFuture;
                return;
            }
            this.readBuffers = null;
            boolean bl2 = this.scatteringRead;
            this.enableReading();
            if (bl2) {
                pendingFuture.setResult(n);
            } else {
                pendingFuture.setResult(n);
            }
        }
        catch (Throwable throwable) {
            AsynchronousCloseException asynchronousCloseException;
            this.enableReading();
            if (throwable instanceof ClosedChannelException) {
                asynchronousCloseException = new AsynchronousCloseException();
            }
            pendingFuture.setFailure(asynchronousCloseException);
        }
        finally {
            Object object = this.updateLock;
            synchronized (object) {
                if (pendingFuture2 != null) {
                    this.pendingRead = pendingFuture2;
                }
                this.updateEvents();
            }
            this.end();
        }
        if (bl) {
            Invoker.invoke(pendingFuture.handler(), pendingFuture);
        } else {
            Invoker.invokeIndirectly(pendingFuture.handler(), pendingFuture);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <V extends Number, A> Future<V> readImpl(ByteBuffer[] byteBufferArray, boolean bl, long l, TimeUnit timeUnit, A a, CompletionHandler<V, ? super A> completionHandler) {
        CompletedFuture<Object, A> completedFuture;
        Invoker.GroupAndInvokeCount groupAndInvokeCount = null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!disableSynchronousRead) {
            groupAndInvokeCount = Invoker.getGroupAndInvokeCount();
            bl2 = Invoker.mayInvokeDirect(groupAndInvokeCount, this.port);
            bl3 = completionHandler == null || bl2 || !this.port.isFixedThreadPool();
        }
        try {
            this.begin();
            int n = bl3 ? (bl ? (int)IOUtil.read(this.fd, byteBufferArray, nd) : IOUtil.read(this.fd, byteBufferArray[0], -1L, nd, null)) : -2;
            if (n == -2) {
                PendingFuture<V, A> pendingFuture = new PendingFuture<V, A>(this, completionHandler, a, (Object)OpType.READ);
                Future<Object> future = this.updateLock;
                synchronized (future) {
                    this.readBuffers = byteBufferArray;
                    this.scatteringRead = bl;
                    this.pendingRead = pendingFuture;
                    this.updateEvents();
                }
                if (l > 0L) {
                    future = this.port.schedule(this.readTimeoutTask, l, timeUnit);
                    pendingFuture.setTimeoutTask(future);
                }
                future = pendingFuture;
                return future;
            }
            this.enableReading();
            completedFuture = bl ? CompletedFuture.withResult(this, Long.valueOf(n), a) : CompletedFuture.withResult(this, n, a);
        }
        catch (Throwable throwable) {
            AsynchronousCloseException asynchronousCloseException;
            this.enableReading();
            if (throwable instanceof ClosedChannelException) {
                asynchronousCloseException = new AsynchronousCloseException();
            }
            completedFuture = CompletedFuture.withFailure(this, asynchronousCloseException, a);
        }
        finally {
            this.end();
        }
        if (bl2) {
            Invoker.invokeDirect(groupAndInvokeCount, completionHandler, completedFuture);
        } else {
            Invoker.invokeIndirectly(completionHandler, completedFuture);
        }
        return completedFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishWrite(PendingFuture<Number, Object> pendingFuture, boolean bl) {
        PendingFuture<Number, Object> pendingFuture2 = null;
        try {
            this.begin();
            Object object = this.writeBuffers;
            int n = ((ByteBuffer[])object).length == 1 ? IOUtil.write(this.fd, object[0], -1L, nd, null) : (int)IOUtil.write(this.fd, object, nd);
            if (n == -2) {
                pendingFuture2 = pendingFuture;
                return;
            }
            this.writeBuffers = null;
            boolean bl2 = this.gatheringWrite;
            this.enableWriting();
            if (bl2) {
                pendingFuture.setResult(n);
            } else {
                pendingFuture.setResult(n);
            }
        }
        catch (Throwable throwable) {
            AsynchronousCloseException asynchronousCloseException;
            this.enableWriting();
            if (throwable instanceof ClosedChannelException) {
                asynchronousCloseException = new AsynchronousCloseException();
            }
            pendingFuture.setFailure(asynchronousCloseException);
        }
        finally {
            UnixAsynchronousSocketChannelImpl unixAsynchronousSocketChannelImpl = this;
            synchronized (unixAsynchronousSocketChannelImpl) {
                if (pendingFuture2 != null) {
                    this.pendingWrite = pendingFuture2;
                }
                this.updateEvents();
            }
            this.end();
        }
        if (bl) {
            Invoker.invoke(pendingFuture.handler(), pendingFuture);
        } else {
            Invoker.invokeIndirectly(pendingFuture.handler(), pendingFuture);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <V extends Number, A> Future<V> writeImpl(ByteBuffer[] byteBufferArray, boolean bl, long l, TimeUnit timeUnit, A a, CompletionHandler<V, ? super A> completionHandler) {
        CompletedFuture<Object, A> completedFuture;
        Invoker.GroupAndInvokeCount groupAndInvokeCount = Invoker.getGroupAndInvokeCount();
        boolean bl2 = Invoker.mayInvokeDirect(groupAndInvokeCount, this.port);
        boolean bl3 = completionHandler == null || bl2 || !this.port.isFixedThreadPool();
        try {
            this.begin();
            int n = bl3 ? (bl ? (int)IOUtil.write(this.fd, byteBufferArray, nd) : IOUtil.write(this.fd, byteBufferArray[0], -1L, nd, null)) : -2;
            if (n == -2) {
                PendingFuture<V, A> pendingFuture = new PendingFuture<V, A>(this, completionHandler, a, (Object)OpType.WRITE);
                Future<Object> future = this.updateLock;
                synchronized (future) {
                    this.writeBuffers = byteBufferArray;
                    this.gatheringWrite = bl;
                    this.pendingWrite = pendingFuture;
                    this.updateEvents();
                }
                if (l > 0L) {
                    future = this.port.schedule(this.writeTimeoutTask, l, timeUnit);
                    pendingFuture.setTimeoutTask(future);
                }
                future = pendingFuture;
                return future;
            }
            this.enableWriting();
            completedFuture = bl ? CompletedFuture.withResult(this, Long.valueOf(n), a) : CompletedFuture.withResult(this, n, a);
        }
        catch (Throwable throwable) {
            AsynchronousCloseException asynchronousCloseException;
            this.enableWriting();
            if (throwable instanceof ClosedChannelException) {
                asynchronousCloseException = new AsynchronousCloseException();
            }
            completedFuture = CompletedFuture.withFailure(this, asynchronousCloseException, a);
        }
        finally {
            this.end();
        }
        if (bl2) {
            Invoker.invokeDirect(groupAndInvokeCount, completionHandler, completedFuture);
        } else {
            Invoker.invokeIndirectly(completionHandler, completedFuture);
        }
        return completedFuture;
    }

    private static native void checkConnect(int var0) throws IOException;

    static {
        String string = AccessController.doPrivileged(new GetPropertyAction("sun.nio.ch.disableSynchronousRead", "false"));
        disableSynchronousRead = string.length() == 0 ? true : Boolean.valueOf(string);
        Util.load();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum OpType {
        CONNECT,
        READ,
        WRITE;

    }
}

