/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyBoundException;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NoConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import sun.net.NetHooks;
import sun.nio.ch.ExtendedSocketOption;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.NativeThread;
import sun.nio.ch.Net;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SocketAdaptor;
import sun.nio.ch.SocketDispatcher;
import sun.nio.ch.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SocketChannelImpl
extends SocketChannel
implements SelChImpl {
    private static NativeDispatcher nd;
    private final FileDescriptor fd;
    private final int fdVal;
    private volatile long readerThread = 0L;
    private volatile long writerThread = 0L;
    private final Object readLock = new Object();
    private final Object writeLock = new Object();
    private final Object stateLock = new Object();
    private static final int ST_UNINITIALIZED = -1;
    private static final int ST_UNCONNECTED = 0;
    private static final int ST_PENDING = 1;
    private static final int ST_CONNECTED = 2;
    private static final int ST_KILLPENDING = 3;
    private static final int ST_KILLED = 4;
    private int state = -1;
    private SocketAddress localAddress;
    private SocketAddress remoteAddress;
    private boolean isInputOpen = true;
    private boolean isOutputOpen = true;
    private boolean readyToConnect = false;
    private Socket socket;

    SocketChannelImpl(SelectorProvider selectorProvider) throws IOException {
        super(selectorProvider);
        this.fd = Net.socket(true);
        this.fdVal = IOUtil.fdVal(this.fd);
        this.state = 0;
    }

    SocketChannelImpl(SelectorProvider selectorProvider, FileDescriptor fileDescriptor, InetSocketAddress inetSocketAddress) throws IOException {
        super(selectorProvider);
        this.fd = fileDescriptor;
        this.fdVal = IOUtil.fdVal(fileDescriptor);
        this.state = 2;
        this.localAddress = Net.localAddress(fileDescriptor);
        this.remoteAddress = inetSocketAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket socket() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.socket == null) {
                this.socket = SocketAdaptor.create(this);
            }
            return this.socket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketAddress getLocalAddress() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            return this.localAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            return this.remoteAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> SocketChannel setOption(SocketOption<T> socketOption, T t) throws IOException {
        if (socketOption == null) {
            throw new NullPointerException();
        }
        if (!this.supportedOptions().contains(socketOption)) {
            throw new UnsupportedOperationException("'" + socketOption + "' not supported");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (socketOption == StandardSocketOption.IP_TOS) {
                if (!Net.isIPv6Available()) {
                    Net.setSocketOption(this.fd, StandardProtocolFamily.INET, socketOption, t);
                }
                return this;
            }
            Net.setSocketOption(this.fd, Net.UNSPEC, socketOption, t);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getOption(SocketOption<T> socketOption) throws IOException {
        if (socketOption == null) {
            throw new NullPointerException();
        }
        if (!this.supportedOptions().contains(socketOption)) {
            throw new UnsupportedOperationException("'" + socketOption + "' not supported");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (socketOption == StandardSocketOption.IP_TOS) {
                return (T)(Net.isIPv6Available() ? Integer.valueOf(0) : Net.getSocketOption(this.fd, StandardProtocolFamily.INET, socketOption));
            }
            return (T)Net.getSocketOption(this.fd, Net.UNSPEC, socketOption);
        }
    }

    @Override
    public final Set<SocketOption<?>> supportedOptions() {
        return DefaultOptionsHolder.defaultOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ensureReadOpen() throws ClosedChannelException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isConnected()) {
                throw new NotYetConnectedException();
            }
            return this.isInputOpen;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureWriteOpen() throws ClosedChannelException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isOutputOpen) {
                throw new ClosedChannelException();
            }
            if (!this.isConnected()) {
                throw new NotYetConnectedException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readerCleanup() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.readerThread = 0L;
            if (this.state == 3) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writerCleanup() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.writerThread = 0L;
            if (this.state == 3) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int n;
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        Object object = this.readLock;
        // MONITORENTER : object
        if (!this.ensureReadOpen()) {
            // MONITOREXIT : object
            return -1;
        }
        int n2 = 0;
        try {
            this.begin();
            Object object2 = this.stateLock;
            // MONITORENTER : object2
            if (!this.isOpen()) {
                int n3 = 0;
                // MONITOREXIT : object2
                Object var8_7 = null;
                this.readerCleanup();
                this.end(n2 > 0 || n2 == -2);
                Object object3 = this.stateLock;
                // MONITORENTER : object3
                if (n2 <= 0 && !this.isInputOpen) {
                    // MONITOREXIT : object3
                    // MONITOREXIT : object
                    return -1;
                }
                // MONITOREXIT : object3
                assert (IOStatus.check(n2));
                // MONITOREXIT : object
                return n3;
            }
            this.readerThread = NativeThread.current();
            // MONITOREXIT : object2
            while ((n2 = IOUtil.read(this.fd, byteBuffer, -1L, nd, this.readLock)) == -3 && this.isOpen()) {
            }
            n = IOStatus.normalize(n2);
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.readerCleanup();
            this.end(n2 > 0 || n2 == -2);
            Object object4 = this.stateLock;
            // MONITORENTER : object4
            if (n2 <= 0 && !this.isInputOpen) {
                // MONITOREXIT : object4
                // MONITOREXIT : object
                return -1;
            }
            // MONITOREXIT : object4
            if ($assertionsDisabled) throw throwable;
            if (IOStatus.check(n2)) throw throwable;
            throw new AssertionError();
        }
        this.readerCleanup();
        this.end(n2 > 0 || n2 == -2);
        Object object5 = this.stateLock;
        // MONITORENTER : object5
        if (n2 <= 0 && !this.isInputOpen) {
            // MONITOREXIT : object5
            // MONITOREXIT : object
            return -1;
        }
        // MONITOREXIT : object5
        if ($assertionsDisabled) return n;
        if (IOStatus.check(n2)) return n;
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private long read0(ByteBuffer[] byteBufferArray) throws IOException {
        long l;
        if (byteBufferArray == null) {
            throw new NullPointerException();
        }
        Object object = this.readLock;
        // MONITORENTER : object
        if (!this.ensureReadOpen()) {
            // MONITOREXIT : object
            return -1L;
        }
        long l2 = 0L;
        try {
            this.begin();
            Object object2 = this.stateLock;
            // MONITORENTER : object2
            if (!this.isOpen()) {
                long l3 = 0L;
                // MONITOREXIT : object2
                Object var10_7 = null;
                this.readerCleanup();
                this.end(l2 > 0L || l2 == -2L);
                Object object3 = this.stateLock;
                // MONITORENTER : object3
                if (l2 <= 0L && !this.isInputOpen) {
                    // MONITOREXIT : object3
                    // MONITOREXIT : object
                    return -1L;
                }
                // MONITOREXIT : object3
                assert (IOStatus.check(l2));
                // MONITOREXIT : object
                return l3;
            }
            this.readerThread = NativeThread.current();
            // MONITOREXIT : object2
            while ((l2 = IOUtil.read(this.fd, byteBufferArray, nd)) == -3L && this.isOpen()) {
            }
            l = IOStatus.normalize(l2);
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.readerCleanup();
            this.end(l2 > 0L || l2 == -2L);
            Object object4 = this.stateLock;
            // MONITORENTER : object4
            if (l2 <= 0L && !this.isInputOpen) {
                // MONITOREXIT : object4
                // MONITOREXIT : object
                return -1L;
            }
            // MONITOREXIT : object4
            if ($assertionsDisabled) throw throwable;
            if (IOStatus.check(l2)) throw throwable;
            throw new AssertionError();
        }
        this.readerCleanup();
        this.end(l2 > 0L || l2 == -2L);
        Object object5 = this.stateLock;
        // MONITORENTER : object5
        if (l2 <= 0L && !this.isInputOpen) {
            // MONITOREXIT : object5
            // MONITOREXIT : object
            return -1L;
        }
        // MONITOREXIT : object5
        if ($assertionsDisabled) return l;
        if (IOStatus.check(l2)) return l;
        throw new AssertionError();
    }

    @Override
    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n > byteBufferArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        return this.read0(Util.subsequence(byteBufferArray, n, n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        int n;
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        Object object = this.writeLock;
        // MONITORENTER : object
        this.ensureWriteOpen();
        int n2 = 0;
        try {
            this.begin();
            Object object2 = this.stateLock;
            // MONITORENTER : object2
            if (!this.isOpen()) {
                int n3 = 0;
                // MONITOREXIT : object2
                Object var8_7 = null;
                this.writerCleanup();
                this.end(n2 > 0 || n2 == -2);
                Object object3 = this.stateLock;
                // MONITORENTER : object3
                if (n2 <= 0 && !this.isOutputOpen) {
                    throw new AsynchronousCloseException();
                }
                // MONITOREXIT : object3
                assert (IOStatus.check(n2));
                // MONITOREXIT : object
                return n3;
            }
            this.writerThread = NativeThread.current();
            // MONITOREXIT : object2
            while ((n2 = IOUtil.write(this.fd, byteBuffer, -1L, nd, this.writeLock)) == -3 && this.isOpen()) {
            }
            n = IOStatus.normalize(n2);
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.writerCleanup();
            this.end(n2 > 0 || n2 == -2);
            Object object4 = this.stateLock;
            // MONITORENTER : object4
            if (n2 <= 0 && !this.isOutputOpen) {
                throw new AsynchronousCloseException();
            }
            // MONITOREXIT : object4
            if ($assertionsDisabled) throw throwable;
            if (IOStatus.check(n2)) throw throwable;
            throw new AssertionError();
        }
        this.writerCleanup();
        this.end(n2 > 0 || n2 == -2);
        Object object5 = this.stateLock;
        // MONITORENTER : object5
        if (n2 <= 0 && !this.isOutputOpen) {
            throw new AsynchronousCloseException();
        }
        // MONITOREXIT : object5
        if ($assertionsDisabled) return n;
        if (IOStatus.check(n2)) return n;
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public long write0(ByteBuffer[] byteBufferArray) throws IOException {
        long l;
        if (byteBufferArray == null) {
            throw new NullPointerException();
        }
        Object object = this.writeLock;
        // MONITORENTER : object
        this.ensureWriteOpen();
        long l2 = 0L;
        try {
            this.begin();
            Object object2 = this.stateLock;
            // MONITORENTER : object2
            if (!this.isOpen()) {
                long l3 = 0L;
                // MONITOREXIT : object2
                Object var10_7 = null;
                this.writerCleanup();
                this.end(l2 > 0L || l2 == -2L);
                Object object3 = this.stateLock;
                // MONITORENTER : object3
                if (l2 <= 0L && !this.isOutputOpen) {
                    throw new AsynchronousCloseException();
                }
                // MONITOREXIT : object3
                assert (IOStatus.check(l2));
                // MONITOREXIT : object
                return l3;
            }
            this.writerThread = NativeThread.current();
            // MONITOREXIT : object2
            while ((l2 = IOUtil.write(this.fd, byteBufferArray, nd)) == -3L && this.isOpen()) {
            }
            l = IOStatus.normalize(l2);
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.writerCleanup();
            this.end(l2 > 0L || l2 == -2L);
            Object object4 = this.stateLock;
            // MONITORENTER : object4
            if (l2 <= 0L && !this.isOutputOpen) {
                throw new AsynchronousCloseException();
            }
            // MONITOREXIT : object4
            if ($assertionsDisabled) throw throwable;
            if (IOStatus.check(l2)) throw throwable;
            throw new AssertionError();
        }
        this.writerCleanup();
        this.end(l2 > 0L || l2 == -2L);
        Object object5 = this.stateLock;
        // MONITORENTER : object5
        if (l2 <= 0L && !this.isOutputOpen) {
            throw new AsynchronousCloseException();
        }
        // MONITOREXIT : object5
        if ($assertionsDisabled) return l;
        if (IOStatus.check(l2)) return l;
        throw new AssertionError();
    }

    @Override
    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n > byteBufferArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        return this.write0(Util.subsequence(byteBufferArray, n, n2));
    }

    @Override
    protected void implConfigureBlocking(boolean bl) throws IOException {
        IOUtil.configureBlocking(this.fd, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress localAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.localAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress remoteAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.remoteAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketChannel bind(SocketAddress socketAddress) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    if (!this.isOpen()) {
                        throw new ClosedChannelException();
                    }
                    if (this.state == 1) {
                        throw new ConnectionPendingException();
                    }
                    if (this.localAddress != null) {
                        throw new AlreadyBoundException();
                    }
                    InetSocketAddress inetSocketAddress = socketAddress == null ? new InetSocketAddress(0) : Net.checkAddress(socketAddress);
                    NetHooks.beforeTcpBind(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                    Net.bind(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                    this.localAddress = Net.localAddress(this.fd);
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnectionPending() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureOpenAndUnconnected() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (this.state == 2) {
                throw new AlreadyConnectedException();
            }
            if (this.state == 1) {
                throw new ConnectionPendingException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean connect(SocketAddress socketAddress) throws IOException {
        boolean bl = false;
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                this.ensureOpenAndUnconnected();
                InetSocketAddress inetSocketAddress = Net.checkAddress(socketAddress);
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
                }
                Object object3 = this.blockingLock();
                synchronized (object3) {
                    Object object4;
                    int n = 0;
                    try {
                        try {
                            this.begin();
                            object4 = this.stateLock;
                            synchronized (object4) {
                                if (!this.isOpen()) {
                                    boolean bl2 = false;
                                    // MONITOREXIT @DISABLED, blocks:[3, 4, 10, 27, 11, 12, 13] lbl21 : MonitorExitStatement: MONITOREXIT : var9_9
                                    Object var14_12 = null;
                                    this.readerCleanup();
                                    this.end(n > 0 || n == -2);
                                    assert (IOStatus.check(n));
                                    return bl2;
                                }
                                if (this.localAddress == null) {
                                    NetHooks.beforeTcpConnect(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                                }
                                this.readerThread = NativeThread.current();
                            }
                            do {
                                if (!((InetAddress)(object4 = inetSocketAddress.getAddress())).isAnyLocalAddress()) continue;
                                object4 = InetAddress.getLocalHost();
                            } while ((n = Net.connect(this.fd, (InetAddress)object4, inetSocketAddress.getPort())) == -3 && this.isOpen());
                            object4 = this.stateLock;
                            synchronized (object4) {
                                if (this.isOpen() && this.localAddress == null || ((InetSocketAddress)this.localAddress).getAddress().isAnyLocalAddress()) {
                                    this.localAddress = Net.localAddress(this.fd);
                                }
                            }
                            Object var14_13 = null;
                        }
                        catch (Throwable throwable) {
                            Object var14_14 = null;
                            this.readerCleanup();
                            this.end(n > 0 || n == -2);
                            assert (IOStatus.check(n));
                            throw throwable;
                        }
                        this.readerCleanup();
                        this.end(n > 0 || n == -2);
                        assert (IOStatus.check(n));
                    }
                    catch (IOException iOException) {
                        this.close();
                        throw iOException;
                    }
                    object4 = this.stateLock;
                    synchronized (object4) {
                        this.remoteAddress = inetSocketAddress;
                        if (n > 0) {
                            this.state = 2;
                            return true;
                        }
                        if (!this.isBlocking()) {
                            this.state = 1;
                        } else assert (false);
                        return false;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean finishConnect() throws IOException {
        Object object;
        Object object2 = this.readLock;
        // MONITORENTER : object2
        Object object3 = this.writeLock;
        // MONITORENTER : object3
        Object object4 = this.stateLock;
        // MONITORENTER : object4
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (this.state == 2) {
            // MONITOREXIT : object4
            // MONITOREXIT : object3
            // MONITOREXIT : object2
            return true;
        }
        if (this.state != 1) {
            throw new NoConnectionPendingException();
        }
        // MONITOREXIT : object4
        int n = 0;
        try {
            try {
                this.begin();
                object = this.blockingLock();
                // MONITORENTER : object
                Object object5 = this.stateLock;
                // MONITORENTER : object5
                if (!this.isOpen()) {
                    boolean bl = false;
                    // MONITOREXIT : object5
                    // MONITOREXIT : object
                    Object var10_9 = null;
                    Object object6 = this.stateLock;
                    // MONITORENTER : object6
                    this.readerThread = 0L;
                    if (this.state == 3) {
                        this.kill();
                        n = 0;
                    }
                    // MONITOREXIT : object6
                    this.end(n > 0 || n == -2);
                    assert (IOStatus.check(n));
                    // MONITOREXIT : object3
                    // MONITOREXIT : object2
                    return bl;
                }
                this.readerThread = NativeThread.current();
                // MONITOREXIT : object5
                if (!this.isBlocking()) {
                    while ((n = SocketChannelImpl.checkConnect(this.fd, false, this.readyToConnect)) == -3 && this.isOpen()) {
                    }
                } else {
                    while ((n = SocketChannelImpl.checkConnect(this.fd, true, this.readyToConnect)) == 0 || n == -3 && this.isOpen()) {
                    }
                }
                // MONITOREXIT : object
                Object var10_10 = null;
                Object object7 = this.stateLock;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                Object object8 = this.stateLock;
                // MONITORENTER : object8
                this.readerThread = 0L;
                if (this.state == 3) {
                    this.kill();
                    n = 0;
                }
                // MONITOREXIT : object8
                this.end(n > 0 || n == -2);
                if ($assertionsDisabled) throw throwable;
                if (IOStatus.check(n)) throw throwable;
                throw new AssertionError();
            }
            this.readerThread = 0L;
            if (this.state == 3) {
                this.kill();
                n = 0;
            }
            // MONITOREXIT : object7
            this.end(n > 0 || n == -2);
            assert (IOStatus.check(n));
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
        if (n > 0) {
            object = this.stateLock;
            // MONITORENTER : object
            this.state = 2;
            // MONITOREXIT : object
            // MONITOREXIT : object3
            // MONITOREXIT : object2
            return true;
        }
        // MONITOREXIT : object3
        // MONITOREXIT : object2
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketChannel shutdownInput() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isConnected()) {
                throw new NotYetConnectedException();
            }
            if (this.isInputOpen) {
                Net.shutdown(this.fd, 0);
                if (this.readerThread != 0L) {
                    NativeThread.signal(this.readerThread);
                }
                this.isInputOpen = false;
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketChannel shutdownOutput() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isConnected()) {
                throw new NotYetConnectedException();
            }
            if (this.isOutputOpen) {
                Net.shutdown(this.fd, 1);
                if (this.writerThread != 0L) {
                    NativeThread.signal(this.writerThread);
                }
                this.isOutputOpen = false;
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInputOpen() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.isInputOpen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOutputOpen() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.isOutputOpen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implCloseSelectableChannel() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.isInputOpen = false;
            this.isOutputOpen = false;
            nd.preClose(this.fd);
            if (this.readerThread != 0L) {
                NativeThread.signal(this.readerThread);
            }
            if (this.writerThread != 0L) {
                NativeThread.signal(this.writerThread);
            }
            if (!this.isRegistered()) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 4) {
                return;
            }
            if (this.state == -1) {
                this.state = 4;
                return;
            }
            assert (!this.isOpen() && !this.isRegistered());
            if (this.readerThread == 0L && this.writerThread == 0L) {
                nd.close(this.fd);
                this.state = 4;
            } else {
                this.state = 3;
            }
        }
    }

    public boolean translateReadyOps(int n, int n2, SelectionKeyImpl selectionKeyImpl) {
        int n3 = selectionKeyImpl.nioInterestOps();
        int n4 = selectionKeyImpl.nioReadyOps();
        int n5 = n2;
        if ((n & 0x20) != 0) {
            return false;
        }
        if ((n & 0x18) != 0) {
            n5 = n3;
            selectionKeyImpl.nioReadyOps(n5);
            this.readyToConnect = true;
            return (n5 & ~n4) != 0;
        }
        if ((n & 1) != 0 && (n3 & 1) != 0 && this.state == 2) {
            n5 |= 1;
        }
        if ((n & 4) != 0 && (n3 & 8) != 0 && (this.state == 0 || this.state == 1)) {
            n5 |= 8;
            this.readyToConnect = true;
        }
        if ((n & 4) != 0 && (n3 & 4) != 0 && this.state == 2) {
            n5 |= 4;
        }
        selectionKeyImpl.nioReadyOps(n5);
        return (n5 & ~n4) != 0;
    }

    @Override
    public boolean translateAndUpdateReadyOps(int n, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n, selectionKeyImpl.nioReadyOps(), selectionKeyImpl);
    }

    @Override
    public boolean translateAndSetReadyOps(int n, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n, 0, selectionKeyImpl);
    }

    @Override
    public void translateAndSetInterestOps(int n, SelectionKeyImpl selectionKeyImpl) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 1;
        }
        if ((n & 4) != 0) {
            n2 |= 4;
        }
        if ((n & 8) != 0) {
            n2 |= 4;
        }
        selectionKeyImpl.selector.putEventOps(selectionKeyImpl, n2);
    }

    @Override
    public FileDescriptor getFD() {
        return this.fd;
    }

    @Override
    public int getFDVal() {
        return this.fdVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getSuperclass().getName());
        stringBuffer.append('[');
        if (!this.isOpen()) {
            stringBuffer.append("closed");
        } else {
            Object object = this.stateLock;
            synchronized (object) {
                switch (this.state) {
                    case 0: {
                        stringBuffer.append("unconnected");
                        break;
                    }
                    case 1: {
                        stringBuffer.append("connection-pending");
                        break;
                    }
                    case 2: {
                        stringBuffer.append("connected");
                        if (!this.isInputOpen) {
                            stringBuffer.append(" ishut");
                        }
                        if (this.isOutputOpen) break;
                        stringBuffer.append(" oshut");
                    }
                }
                if (this.localAddress() != null) {
                    stringBuffer.append(" local=");
                    stringBuffer.append(this.localAddress().toString());
                }
                if (this.remoteAddress() != null) {
                    stringBuffer.append(" remote=");
                    stringBuffer.append(this.remoteAddress().toString());
                }
            }
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private static native int checkConnect(FileDescriptor var0, boolean var1, boolean var2) throws IOException;

    static {
        Util.load();
        nd = new SocketDispatcher();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultOptionsHolder {
        static final Set<SocketOption<?>> defaultOptions = DefaultOptionsHolder.defaultOptions();

        private DefaultOptionsHolder() {
        }

        private static Set<SocketOption<?>> defaultOptions() {
            HashSet<SocketOption<Comparable<Integer>>> hashSet = new HashSet<SocketOption<Comparable<Integer>>>(8);
            hashSet.add(StandardSocketOption.SO_SNDBUF);
            hashSet.add(StandardSocketOption.SO_RCVBUF);
            hashSet.add(StandardSocketOption.SO_KEEPALIVE);
            hashSet.add(StandardSocketOption.SO_REUSEADDR);
            hashSet.add(StandardSocketOption.SO_LINGER);
            hashSet.add(StandardSocketOption.TCP_NODELAY);
            hashSet.add(StandardSocketOption.IP_TOS);
            hashSet.add(ExtendedSocketOption.SO_OOBINLINE);
            return Collections.unmodifiableSet(hashSet);
        }
    }
}

