/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.FileLock;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ShutdownChannelGroupException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import sun.nio.ch.AsynchronousFileChannelImpl;
import sun.nio.ch.CompletedFuture;
import sun.nio.ch.FileDispatcher;
import sun.nio.ch.FileDispatcherImpl;
import sun.nio.ch.FileLockImpl;
import sun.nio.ch.IOUtil;
import sun.nio.ch.Invoker;
import sun.nio.ch.NativeThreadSet;
import sun.nio.ch.PendingFuture;
import sun.nio.ch.ThreadPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleAsynchronousFileChannelImpl
extends AsynchronousFileChannelImpl {
    private static final FileDispatcher nd = new FileDispatcherImpl();
    private final boolean isDefaultExecutor;
    private final NativeThreadSet threads = new NativeThreadSet(2);

    SimpleAsynchronousFileChannelImpl(FileDescriptor fileDescriptor, boolean bl, boolean bl2, ExecutorService executorService, boolean bl3) {
        super(fileDescriptor, bl, bl2, executorService);
        this.isDefaultExecutor = bl3;
    }

    public static AsynchronousFileChannel open(FileDescriptor fileDescriptor, boolean bl, boolean bl2, ThreadPool threadPool) {
        boolean bl3;
        ExecutorService executorService;
        if (threadPool == null) {
            executorService = DefaultExecutorHolder.defaultExecutor;
            bl3 = true;
        } else {
            executorService = threadPool.executor();
            bl3 = false;
        }
        return new SimpleAsynchronousFileChannelImpl(fileDescriptor, bl, bl2, executorService, bl3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        FileDescriptor fileDescriptor = this.fdObj;
        synchronized (fileDescriptor) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.invalidateAllLocks();
        nd.preClose(this.fdObj);
        this.threads.signalAndWait();
        this.closeLock.writeLock().lock();
        this.closeLock.writeLock().unlock();
        nd.close(this.fdObj);
        if (!this.isDefaultExecutor) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    SimpleAsynchronousFileChannelImpl.this.executor.shutdown();
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size() throws IOException {
        int n = this.threads.add();
        try {
            long l;
            long l2 = 0L;
            try {
                this.begin();
                while ((l2 = nd.size(this.fdObj)) == -3L && this.isOpen()) {
                }
                l = l2;
                this.end(l2 >= 0L);
            }
            catch (Throwable throwable) {
                this.end(l2 >= 0L);
                throw throwable;
            }
            return l;
        }
        finally {
            this.threads.remove(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsynchronousFileChannel truncate(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative size");
        }
        if (!this.writing) {
            throw new NonWritableChannelException();
        }
        int n = this.threads.add();
        try {
            SimpleAsynchronousFileChannelImpl simpleAsynchronousFileChannelImpl;
            long l2 = 0L;
            try {
                this.begin();
                while ((l2 = nd.size(this.fdObj)) == -3L && this.isOpen()) {
                }
                if (l < l2 && this.isOpen()) {
                    while ((l2 = (long)nd.truncate(this.fdObj, l)) == -3L && this.isOpen()) {
                    }
                }
                simpleAsynchronousFileChannelImpl = this;
                this.end(l2 > 0L);
            }
            catch (Throwable throwable) {
                this.end(l2 > 0L);
                throw throwable;
            }
            return simpleAsynchronousFileChannelImpl;
        }
        finally {
            this.threads.remove(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void force(boolean bl) throws IOException {
        int n = this.threads.add();
        try {
            int n2 = 0;
            try {
                this.begin();
                while ((n2 = nd.force(this.fdObj, bl)) == -3 && this.isOpen()) {
                }
                this.end(n2 >= 0);
            }
            catch (Throwable throwable) {
                this.end(n2 >= 0);
                throw throwable;
            }
        }
        finally {
            this.threads.remove(n);
        }
    }

    @Override
    public <A> Future<FileLock> lock(final long l, final long l2, final boolean bl, A a, final CompletionHandler<FileLock, ? super A> completionHandler) {
        if (bl && !this.reading) {
            throw new NonReadableChannelException();
        }
        if (!bl && !this.writing) {
            throw new NonWritableChannelException();
        }
        final FileLockImpl fileLockImpl = this.addToFileLockTable(l, l2, bl);
        if (fileLockImpl == null) {
            CompletedFuture completedFuture = CompletedFuture.withFailure(this, new ClosedChannelException(), a);
            Invoker.invokeIndirectly(completionHandler, completedFuture, this.executor);
            return completedFuture;
        }
        final PendingFuture<FileLock, ? super A> pendingFuture = new PendingFuture<FileLock, A>(this, completionHandler, a);
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block11: {
                    int n = SimpleAsynchronousFileChannelImpl.this.threads.add();
                    try {
                        try {
                            int n2;
                            SimpleAsynchronousFileChannelImpl.this.begin();
                            while ((n2 = nd.lock(SimpleAsynchronousFileChannelImpl.this.fdObj, true, l, l2, bl)) == 2 && SimpleAsynchronousFileChannelImpl.this.isOpen()) {
                            }
                            if (n2 == 0 && SimpleAsynchronousFileChannelImpl.this.isOpen()) {
                                pendingFuture.setResult(fileLockImpl);
                                break block11;
                            }
                            throw new AsynchronousCloseException();
                        }
                        catch (IOException iOException) {
                            AsynchronousCloseException asynchronousCloseException;
                            SimpleAsynchronousFileChannelImpl.this.removeFromFileLockTable(fileLockImpl);
                            if (!SimpleAsynchronousFileChannelImpl.this.isOpen()) {
                                asynchronousCloseException = new AsynchronousCloseException();
                            }
                            pendingFuture.setFailure(asynchronousCloseException);
                        }
                        finally {
                            SimpleAsynchronousFileChannelImpl.this.end();
                        }
                    }
                    finally {
                        SimpleAsynchronousFileChannelImpl.this.threads.remove(n);
                    }
                }
                Invoker.invokeUnchecked(completionHandler, pendingFuture);
            }
        };
        try {
            this.executor.execute(runnable);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            this.removeFromFileLockTable(fileLockImpl);
            throw new ShutdownChannelGroupException();
        }
        return pendingFuture;
    }

    @Override
    public FileLock tryLock(long l, long l2, boolean bl) throws IOException {
        if (bl && !this.reading) {
            throw new NonReadableChannelException();
        }
        if (!bl && !this.writing) {
            throw new NonWritableChannelException();
        }
        FileLockImpl fileLockImpl = this.addToFileLockTable(l, l2, bl);
        if (fileLockImpl == null) {
            throw new ClosedChannelException();
        }
        int n = this.threads.add();
        boolean bl2 = false;
        try {
            int n2;
            this.begin();
            while ((n2 = nd.lock(this.fdObj, false, l, l2, bl)) == 2 && this.isOpen()) {
            }
            if (n2 == 0 && this.isOpen()) {
                bl2 = true;
                FileLockImpl fileLockImpl2 = fileLockImpl;
                return fileLockImpl2;
            }
            if (n2 == -1) {
                FileLock fileLock = null;
                return fileLock;
            }
            if (n2 == 2) {
                throw new AsynchronousCloseException();
            }
            throw new AssertionError();
        }
        finally {
            if (!bl2) {
                this.removeFromFileLockTable(fileLockImpl);
            }
            this.end();
            this.threads.remove(n);
        }
    }

    @Override
    protected void implRelease(FileLockImpl fileLockImpl) throws IOException {
        nd.release(this.fdObj, fileLockImpl.position(), fileLockImpl.size());
    }

    @Override
    public <A> Future<Integer> read(final ByteBuffer byteBuffer, final long l, A a, final CompletionHandler<Integer, ? super A> completionHandler) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative position");
        }
        if (!this.reading) {
            throw new NonReadableChannelException();
        }
        if (byteBuffer.isReadOnly()) {
            throw new IllegalArgumentException("Read-only buffer");
        }
        if (!this.isOpen() || byteBuffer.remaining() == 0) {
            CompletedFuture<Integer, A> completedFuture = this.isOpen() ? CompletedFuture.withResult(this, 0, a) : CompletedFuture.withFailure(this, new ClosedChannelException(), a);
            Invoker.invokeIndirectly(completionHandler, completedFuture, this.executor);
            return completedFuture;
        }
        final PendingFuture<Integer, ? super A> pendingFuture = new PendingFuture<Integer, A>(this, completionHandler, a);
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                int n = SimpleAsynchronousFileChannelImpl.this.threads.add();
                try {
                    int n2;
                    SimpleAsynchronousFileChannelImpl.this.begin();
                    while ((n2 = IOUtil.read(SimpleAsynchronousFileChannelImpl.this.fdObj, byteBuffer, l, nd, null)) == -3 && SimpleAsynchronousFileChannelImpl.this.isOpen()) {
                    }
                    if (n2 < 0 && !SimpleAsynchronousFileChannelImpl.this.isOpen()) {
                        throw new AsynchronousCloseException();
                    }
                    pendingFuture.setResult(n2);
                }
                catch (IOException iOException) {
                    AsynchronousCloseException asynchronousCloseException;
                    if (!SimpleAsynchronousFileChannelImpl.this.isOpen()) {
                        asynchronousCloseException = new AsynchronousCloseException();
                    }
                    pendingFuture.setFailure(asynchronousCloseException);
                }
                finally {
                    SimpleAsynchronousFileChannelImpl.this.end();
                    SimpleAsynchronousFileChannelImpl.this.threads.remove(n);
                }
                Invoker.invokeUnchecked(completionHandler, pendingFuture);
            }
        };
        try {
            this.executor.execute(runnable);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            throw new ShutdownChannelGroupException();
        }
        return pendingFuture;
    }

    @Override
    public <A> Future<Integer> write(final ByteBuffer byteBuffer, final long l, A a, final CompletionHandler<Integer, ? super A> completionHandler) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative position");
        }
        if (!this.writing) {
            throw new NonWritableChannelException();
        }
        if (!this.isOpen() || byteBuffer.remaining() == 0) {
            CompletedFuture<Integer, A> completedFuture = this.isOpen() ? CompletedFuture.withResult(this, 0, a) : CompletedFuture.withFailure(this, new ClosedChannelException(), a);
            Invoker.invokeIndirectly(completionHandler, completedFuture, this.executor);
            return completedFuture;
        }
        final PendingFuture<Integer, ? super A> pendingFuture = new PendingFuture<Integer, A>(this, completionHandler, a);
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                int n = SimpleAsynchronousFileChannelImpl.this.threads.add();
                try {
                    int n2;
                    SimpleAsynchronousFileChannelImpl.this.begin();
                    while ((n2 = IOUtil.write(SimpleAsynchronousFileChannelImpl.this.fdObj, byteBuffer, l, nd, null)) == -3 && SimpleAsynchronousFileChannelImpl.this.isOpen()) {
                    }
                    if (n2 < 0 && !SimpleAsynchronousFileChannelImpl.this.isOpen()) {
                        throw new AsynchronousCloseException();
                    }
                    pendingFuture.setResult(n2);
                }
                catch (IOException iOException) {
                    AsynchronousCloseException asynchronousCloseException;
                    if (!SimpleAsynchronousFileChannelImpl.this.isOpen()) {
                        asynchronousCloseException = new AsynchronousCloseException();
                    }
                    pendingFuture.setFailure(asynchronousCloseException);
                }
                finally {
                    SimpleAsynchronousFileChannelImpl.this.end();
                    SimpleAsynchronousFileChannelImpl.this.threads.remove(n);
                }
                Invoker.invokeUnchecked(completionHandler, pendingFuture);
            }
        };
        try {
            this.executor.execute(runnable);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            throw new ShutdownChannelGroupException();
        }
        return pendingFuture;
    }

    private static class DefaultExecutorHolder {
        static final ExecutorService defaultExecutor = ThreadPool.createDefault().executor();

        private DefaultExecutorHolder() {
        }
    }
}

