/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.nio.channels.Channel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import sun.nio.ch.FileKey;
import sun.nio.ch.FileLockTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SharedFileLockTable
extends FileLockTable {
    private static ConcurrentHashMap<FileKey, List<FileLockReference>> lockMap = new ConcurrentHashMap();
    private static ReferenceQueue<FileLock> queue = new ReferenceQueue();
    private final Channel channel;
    private final FileKey fileKey;

    SharedFileLockTable(Channel channel, FileDescriptor fileDescriptor) throws IOException {
        this.channel = channel;
        this.fileKey = FileKey.create(fileDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(FileLock fileLock) throws OverlappingFileLockException {
        List<FileLockReference> list = lockMap.get(this.fileKey);
        while (true) {
            List<FileLockReference> list2;
            List<FileLockReference> list3;
            if (list == null) {
                list3 = list = new ArrayList<FileLockReference>(2);
                synchronized (list3) {
                    list2 = lockMap.putIfAbsent(this.fileKey, list);
                    if (list2 == null) {
                        list.add(new FileLockReference(fileLock, queue, this.fileKey));
                        break;
                    }
                }
                list = list2;
            }
            list2 = list;
            synchronized (list2) {
                list3 = lockMap.get(this.fileKey);
                if (list == list3) {
                    this.checkList(list, fileLock.position(), fileLock.size());
                    list.add(new FileLockReference(fileLock, queue, this.fileKey));
                    break;
                }
                list = list3;
            }
        }
        this.removeStaleEntries();
    }

    private void removeKeyIfEmpty(FileKey fileKey, List<FileLockReference> list) {
        assert (Thread.holdsLock(list));
        assert (lockMap.get(fileKey) == list);
        if (list.isEmpty()) {
            lockMap.remove(fileKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(FileLock fileLock) {
        assert (fileLock != null);
        List<FileLockReference> list = lockMap.get(this.fileKey);
        if (list == null) {
            return;
        }
        List<FileLockReference> list2 = list;
        synchronized (list2) {
            for (int i = 0; i < list.size(); ++i) {
                FileLockReference fileLockReference = list.get(i);
                FileLock fileLock2 = (FileLock)fileLockReference.get();
                if (fileLock2 != fileLock) continue;
                assert (fileLock2 != null && fileLock2.acquiredBy() == this.channel);
                fileLockReference.clear();
                list.remove(i);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FileLock> removeAll() {
        ArrayList<FileLock> arrayList = new ArrayList<FileLock>();
        List<FileLockReference> list = lockMap.get(this.fileKey);
        if (list != null) {
            List<FileLockReference> list2 = list;
            synchronized (list2) {
                int n = 0;
                while (n < list.size()) {
                    FileLockReference fileLockReference = list.get(n);
                    FileLock fileLock = (FileLock)fileLockReference.get();
                    if (fileLock != null && fileLock.acquiredBy() == this.channel) {
                        fileLockReference.clear();
                        list.remove(n);
                        arrayList.add(fileLock);
                        continue;
                    }
                    ++n;
                }
                this.removeKeyIfEmpty(this.fileKey, list);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replace(FileLock fileLock, FileLock fileLock2) {
        List<FileLockReference> list = lockMap.get(this.fileKey);
        assert (list != null);
        List<FileLockReference> list2 = list;
        synchronized (list2) {
            for (int i = 0; i < list.size(); ++i) {
                FileLockReference fileLockReference = list.get(i);
                FileLock fileLock3 = (FileLock)fileLockReference.get();
                if (fileLock3 != fileLock) continue;
                fileLockReference.clear();
                list.set(i, new FileLockReference(fileLock2, queue, this.fileKey));
                break;
            }
        }
    }

    private void checkList(List<FileLockReference> list, long l, long l2) throws OverlappingFileLockException {
        assert (Thread.holdsLock(list));
        for (FileLockReference fileLockReference : list) {
            FileLock fileLock = (FileLock)fileLockReference.get();
            if (fileLock == null || !fileLock.overlaps(l, l2)) continue;
            throw new OverlappingFileLockException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStaleEntries() {
        FileLockReference fileLockReference;
        while ((fileLockReference = (FileLockReference)queue.poll()) != null) {
            FileKey fileKey = fileLockReference.fileKey();
            List<FileLockReference> list = lockMap.get(fileKey);
            if (list == null) continue;
            List<FileLockReference> list2 = list;
            synchronized (list2) {
                list.remove(fileLockReference);
                this.removeKeyIfEmpty(fileKey, list);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileLockReference
    extends WeakReference<FileLock> {
        private FileKey fileKey;

        FileLockReference(FileLock fileLock, ReferenceQueue<FileLock> referenceQueue, FileKey fileKey) {
            super(fileLock, referenceQueue);
            this.fileKey = fileKey;
        }

        FileKey fileKey() {
            return this.fileKey;
        }
    }
}

