/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import sun.nio.ch.AbstractPollSelectorImpl;
import sun.nio.ch.FileDispatcherImpl;
import sun.nio.ch.IOUtil;
import sun.nio.ch.PollArrayWrapper;
import sun.nio.ch.SelectionKeyImpl;

class PollSelectorImpl
extends AbstractPollSelectorImpl {
    private int fd0;
    private int fd1;
    private Object interruptLock = new Object();
    private boolean interruptTriggered = false;

    PollSelectorImpl(SelectorProvider selectorProvider) {
        super(selectorProvider, 1, 1);
        int[] nArray = new int[2];
        IOUtil.initPipe(nArray, false);
        this.fd0 = nArray[0];
        this.fd1 = nArray[1];
        this.pollWrapper = new PollArrayWrapper(10);
        this.pollWrapper.initInterrupt(this.fd0, this.fd1);
        this.channelArray = new SelectionKeyImpl[10];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doSelect(long l) throws IOException {
        Object object;
        if (this.channelArray == null) {
            throw new ClosedSelectorException();
        }
        this.processDeregisterQueue();
        try {
            this.begin();
            this.pollWrapper.poll(this.totalChannels, 0, l);
            object = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.end();
            throw throwable;
        }
        this.end();
        this.processDeregisterQueue();
        int n = this.updateSelectedKeys();
        if (this.pollWrapper.getReventOps(0) != 0) {
            this.pollWrapper.putReventOps(0, 0);
            object = this.interruptLock;
            synchronized (object) {
                IOUtil.drain(this.fd0);
                this.interruptTriggered = false;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void implCloseInterrupt() throws IOException {
        Object object = this.interruptLock;
        synchronized (object) {
            this.interruptTriggered = true;
        }
        FileDispatcherImpl.closeIntFD(this.fd0);
        FileDispatcherImpl.closeIntFD(this.fd1);
        this.fd0 = -1;
        this.fd1 = -1;
        this.pollWrapper.release(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Selector wakeup() {
        Object object = this.interruptLock;
        synchronized (object) {
            if (!this.interruptTriggered) {
                this.pollWrapper.interrupt();
                this.interruptTriggered = true;
            }
        }
        return this;
    }
}

