/*
 * Decompiled with CFR 0.152.
 */
package sun.dyn.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class BytecodeName {
    static char ESCAPE_C = (char)92;
    static char NULL_ESCAPE_C = (char)61;
    static String NULL_ESCAPE = ESCAPE_C + "" + NULL_ESCAPE_C;
    static final String DANGEROUS_CHARS = "\\/.;:$[]<>";
    static final String REPLACEMENT_CHARS = "-|,?!%{}^_";
    static final int DANGEROUS_CHAR_FIRST_INDEX = 1;
    static char[] DANGEROUS_CHARS_A = "\\/.;:$[]<>".toCharArray();
    static char[] REPLACEMENT_CHARS_A = "-|,?!%{}^_".toCharArray();
    static final Character[] DANGEROUS_CHARS_CA;
    static final long[] SPECIAL_BITMAP;

    private BytecodeName() {
    }

    public static String toBytecodeName(String string) {
        String string2 = BytecodeName.mangle(string);
        assert (string2 == string || BytecodeName.looksMangled(string2)) : string2;
        assert (string.equals(BytecodeName.toSourceName(string2))) : string;
        return string2;
    }

    public static String toSourceName(String string) {
        BytecodeName.checkSafeBytecodeName(string);
        String string2 = string;
        if (BytecodeName.looksMangled(string)) {
            string2 = BytecodeName.demangle(string);
            assert (string.equals(BytecodeName.mangle(string2))) : string + " => " + string2 + " => " + BytecodeName.mangle(string2);
        }
        return string2;
    }

    public static Object[] parseBytecodeName(String string) {
        int n = string.length();
        String[] stringArray = null;
        for (int i = 0; i <= 1; ++i) {
            int n2 = 0;
            int n3 = 0;
            for (int j = 0; j <= n; ++j) {
                int n4 = -1;
                if (j < n && (n4 = DANGEROUS_CHARS.indexOf(string.charAt(j))) < 1) continue;
                if (n3 < j) {
                    if (i != 0) {
                        stringArray[n2] = string.substring(n3, j);
                    }
                    ++n2;
                    n3 = j + 1;
                }
                if (n4 < 1) continue;
                if (i != 0) {
                    stringArray[n2] = DANGEROUS_CHARS_CA[n4];
                }
                ++n2;
            }
            if (i != 0) break;
            stringArray = new String[n2];
            if (n2 > 1) continue;
            if (n2 == 0) break;
            stringArray[0] = string;
            break;
        }
        return stringArray;
    }

    public static String unparseBytecodeName(Object[] objectArray) {
        for (Object object : objectArray) {
            if (!(object instanceof String)) continue;
            BytecodeName.checkSafeBytecodeName((String)object);
        }
        return BytecodeName.appendAll(objectArray);
    }

    private static String appendAll(Object[] objectArray) {
        if (objectArray.length <= 1) {
            if (objectArray.length == 1) {
                return String.valueOf(objectArray[0]);
            }
            return "";
        }
        int n = 0;
        for (Object object : objectArray) {
            if (object instanceof String) {
                n += String.valueOf(object).length();
                continue;
            }
            ++n;
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        for (Object object : objectArray) {
            stringBuilder.append(object);
        }
        return stringBuilder.toString();
    }

    public static String toDisplayName(String string) {
        Object[] objectArray = BytecodeName.parseBytecodeName(string);
        for (int i = 0; i < objectArray.length; ++i) {
            String string2;
            String string3;
            if (!(objectArray[i] instanceof String) || (string3 = BytecodeName.toSourceName(string2 = (String)objectArray[i])) == string2 && BytecodeName.isJavaIdent(string3)) continue;
            objectArray[i] = BytecodeName.quoteDisplay(string3);
        }
        return BytecodeName.appendAll(objectArray);
    }

    private static boolean isJavaIdent(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        if (!Character.isUnicodeIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < n; ++i) {
            if (Character.isUnicodeIdentifierPart(string.charAt(0))) continue;
            return false;
        }
        return true;
    }

    private static String quoteDisplay(String string) {
        return "'" + string.replaceAll("['\\\\]", "\\\\$0") + "'";
    }

    private static void checkSafeBytecodeName(String string) throws IllegalArgumentException {
        if (!BytecodeName.isSafeBytecodeName(string)) {
            throw new IllegalArgumentException(string);
        }
    }

    public static boolean isSafeBytecodeName(String string) {
        if (string.length() == 0) {
            return false;
        }
        for (char c : DANGEROUS_CHARS_A) {
            if (c == ESCAPE_C || string.indexOf(c) < 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isSafeBytecodeChar(char c) {
        return DANGEROUS_CHARS.indexOf(c) < 1;
    }

    private static boolean looksMangled(String string) {
        return string.charAt(0) == ESCAPE_C;
    }

    private static String mangle(String string) {
        if (string.length() == 0) {
            return NULL_ESCAPE;
        }
        StringBuilder stringBuilder = null;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            boolean bl = false;
            if (c == ESCAPE_C) {
                if (i + 1 < n) {
                    char c2 = string.charAt(i + 1);
                    if (i == 0 && c2 == NULL_ESCAPE_C || c2 != BytecodeName.originalOfReplacement(c2)) {
                        bl = true;
                    }
                }
            } else {
                bl = BytecodeName.isDangerous(c);
            }
            if (!bl) {
                if (stringBuilder == null) continue;
                stringBuilder.append(c);
                continue;
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(string.length() + 10);
                if (string.charAt(0) != ESCAPE_C && i > 0) {
                    stringBuilder.append(NULL_ESCAPE);
                }
                stringBuilder.append(string.substring(0, i));
            }
            stringBuilder.append(ESCAPE_C);
            stringBuilder.append(BytecodeName.replacementOf(c));
        }
        if (stringBuilder != null) {
            return stringBuilder.toString();
        }
        return string;
    }

    private static String demangle(String string) {
        StringBuilder stringBuilder = null;
        int n = 0;
        if (string.startsWith(NULL_ESCAPE)) {
            n = 2;
        }
        int n2 = string.length();
        for (int i = n; i < n2; ++i) {
            char c;
            char c2;
            char c3 = string.charAt(i);
            if (c3 == ESCAPE_C && i + 1 < n2 && (c2 = BytecodeName.originalOfReplacement(c = string.charAt(i + 1))) != c) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(string.length());
                    stringBuilder.append(string.substring(n, i));
                }
                ++i;
                c3 = c2;
            }
            if (stringBuilder == null) continue;
            stringBuilder.append(c3);
        }
        if (stringBuilder != null) {
            return stringBuilder.toString();
        }
        return string.substring(n);
    }

    static boolean isSpecial(char c) {
        if (c >>> 6 < SPECIAL_BITMAP.length) {
            return (SPECIAL_BITMAP[c >>> 6] >> c & 1L) != 0L;
        }
        return false;
    }

    static char replacementOf(char c) {
        if (!BytecodeName.isSpecial(c)) {
            return c;
        }
        int n = DANGEROUS_CHARS.indexOf(c);
        if (n < 0) {
            return c;
        }
        return REPLACEMENT_CHARS.charAt(n);
    }

    static char originalOfReplacement(char c) {
        if (!BytecodeName.isSpecial(c)) {
            return c;
        }
        int n = REPLACEMENT_CHARS.indexOf(c);
        if (n < 0) {
            return c;
        }
        return DANGEROUS_CHARS.charAt(n);
    }

    static boolean isDangerous(char c) {
        if (!BytecodeName.isSpecial(c)) {
            return false;
        }
        return DANGEROUS_CHARS.indexOf(c) >= 1;
    }

    static int indexOfDangerousChar(String string, int n) {
        int n2 = string.length();
        for (int i = n; i < n2; ++i) {
            if (!BytecodeName.isDangerous(string.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    static int lastIndexOfDangerousChar(String string, int n) {
        for (int i = Math.min(n, string.length() - 1); i >= 0; --i) {
            if (!BytecodeName.isDangerous(string.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    static void main(String[] stringArray) {
        Object object;
        boolean bl = false;
        int n = 0;
        while (stringArray.length > 0 && stringArray[0].startsWith("-")) {
            object = stringArray[0].intern();
            stringArray = Arrays.copyOfRange(stringArray, 1, stringArray.length);
            if (object == "-" || object == "--") break;
            if (object == "-q") {
                bl = false;
                continue;
            }
            if (object == "-v") {
                bl = true;
                continue;
            }
            if (((String)object).startsWith("-l")) {
                n = Integer.valueOf(((String)object).substring(2));
                continue;
            }
            throw new Error("Illegal flag argument: " + (String)object);
        }
        if (n == 0) {
            int n2 = n = bl ? 2 : 4;
        }
        if (bl) {
            System.out.println("Note: maxlen = " + n);
        }
        switch (stringArray.length) {
            case 0: {
                stringArray = new String[]{DANGEROUS_CHARS.substring(0) + REPLACEMENT_CHARS.substring(0, 1) + NULL_ESCAPE + "x"};
            }
            case 1: {
                object = stringArray[0].toCharArray();
                stringArray = new String[((Object)object).length];
                int n3 = 0;
                for (Object object2 : object) {
                    String string = String.valueOf((char)object2);
                    if (object2 == 120) {
                        string = "foo";
                    }
                    stringArray[n3++] = string;
                }
                break;
            }
        }
        if (bl) {
            System.out.println("Note: Verbose output mode enabled.  Use '-q' to suppress.");
        }
        object = new Tester();
        ((Tester)object).maxlen = n;
        ((Tester)object).verbose = bl;
        ((Tester)object).tokens = stringArray;
        ((Tester)object).test("", 0);
    }

    static {
        Object object = new Character[DANGEROUS_CHARS.length()];
        for (int i = 0; i < ((Character[])object).length; ++i) {
            object[i] = Character.valueOf(DANGEROUS_CHARS.charAt(i));
        }
        DANGEROUS_CHARS_CA = object;
        SPECIAL_BITMAP = new long[2];
        object = "\\/.;:$[]<>-|,?!%{}^_";
        for (char c : ((String)object).toCharArray()) {
            int n = c >>> 6;
            SPECIAL_BITMAP[n] = SPECIAL_BITMAP[n] | 1L << c;
        }
    }

    static class Tester {
        boolean verbose;
        int maxlen;
        Map<String, String> map = new HashMap<String, String>();
        String[] tokens;

        Tester() {
        }

        void test(String string, int n) {
            this.test(string);
            if (n <= this.maxlen) {
                for (String string2 : this.tokens) {
                    if (string2.length() == 0 || string.indexOf(string2) != string.lastIndexOf(string2)) continue;
                    if (string2.charAt(0) == ESCAPE_C && string2.length() == 1 && this.maxlen < 4) {
                        this.test(string + string2, n);
                        continue;
                    }
                    if (n >= this.maxlen) continue;
                    this.test(string + string2, n + 1);
                }
            }
        }

        void test(String string) {
            if (string.length() == 0 && this.maxlen >= 1 && this.maxlen <= 2) {
                return;
            }
            String string2 = this.testSourceName(string);
            if (string2 == null) {
                return;
            }
            if (string2 != string) {
                String string3;
                if (this.verbose) {
                    System.out.println(string + " => " + string2 + " " + BytecodeName.toDisplayName(string2));
                }
                if ((string3 = this.testSourceName(string2)) == null) {
                    return;
                }
                if (this.verbose) {
                    System.out.println(string2 + " => " + string3 + " " + BytecodeName.toDisplayName(string3));
                }
            }
        }

        String testSourceName(String string) {
            if (this.map.containsKey(string)) {
                return null;
            }
            String string2 = BytecodeName.toBytecodeName(string);
            this.map.put(string, string2);
            String string3 = BytecodeName.toSourceName(string2);
            if (!string3.equals(string)) {
                String string4 = string + " => " + string2 + " != " + string3;
                if (!this.verbose) {
                    throw new Error("Bad mangling: " + string4);
                }
                System.out.println("*** " + string4);
                return null;
            }
            return string2;
        }
    }
}

