/*
 * Decompiled with CFR 0.152.
 */
package sun.dyn;

import java.dyn.JavaMethodHandle;
import java.dyn.MethodHandle;
import java.dyn.MethodType;
import java.dyn.NoAccessException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import sun.dyn.MethodHandleImpl;
import sun.dyn.MethodTypeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FilterGeneric {
    private final MethodType targetType;
    private final short argumentPosition;
    private final short argumentCount;
    private final char replaceMode;
    private final Adapter adapter;
    private final MethodHandle entryPoint;
    private FilterGeneric variations;

    FilterGeneric(MethodType methodType, short s, short s2, char c) {
        if (s2 == 0) {
            if (c == 'P' || c == 'A') {
                c = (char)82;
            }
            if (c == 'I') {
                s = 0;
            }
        }
        this.targetType = methodType;
        this.argumentPosition = s;
        this.argumentCount = s2;
        this.replaceMode = c;
        FilterGeneric.validate(methodType, s, s2, c);
        Adapter adapter = FilterGeneric.findAdapter(methodType, s, s2, c, this.filterType());
        if (adapter == null) {
            adapter = FilterGeneric.buildAdapterFromBytecodes(methodType, s, s2, c, this.filterType());
        }
        this.adapter = adapter;
        this.entryPoint = adapter.prototypeEntryPoint();
    }

    Adapter makeInstance(MethodHandle methodHandle, MethodHandle methodHandle2) {
        return this.adapter.makeInstance(this.entryPoint, methodHandle, methodHandle2);
    }

    public static MethodHandle make(MethodHandle methodHandle, int n, MethodHandle methodHandle2) {
        return FilterGeneric.of(methodHandle.type(), (short)n, (short)1, 'R').makeInstance(methodHandle2, methodHandle);
    }

    static FilterGeneric of(MethodType methodType, short s, short s2, char c) {
        if (methodType.generic() != methodType) {
            throw new IllegalArgumentException("must be generic: " + methodType);
        }
        FilterGeneric.validate(methodType, s, s2, c);
        MethodTypeImpl methodTypeImpl = MethodTypeImpl.of(methodType);
        FilterGeneric filterGeneric = methodTypeImpl.filterGeneric;
        if (filterGeneric == null) {
            methodTypeImpl.filterGeneric = filterGeneric = new FilterGeneric(methodType, 0, 1, 'R');
        }
        return FilterGeneric.find(filterGeneric, s, s2, c);
    }

    static FilterGeneric find(FilterGeneric filterGeneric, short s, short s2, char c) {
        FilterGeneric filterGeneric2;
        while (true) {
            if (filterGeneric.argumentPosition == s && filterGeneric.argumentCount == s2 && filterGeneric.replaceMode == c) {
                return filterGeneric;
            }
            filterGeneric2 = filterGeneric.variations;
            if (filterGeneric2 == null) break;
            filterGeneric = filterGeneric2;
        }
        filterGeneric.variations = filterGeneric2 = new FilterGeneric(filterGeneric.targetType, s, s2, c);
        return filterGeneric2;
    }

    private static void validate(MethodType methodType, short s, short s2, char c) {
        int n = s + s2;
        switch (c) {
            case 'A': 
            case 'D': 
            case 'P': 
            case 'R': {
                if (s < 0 || s2 < 0 || n < 0 || n > methodType.parameterCount()) break;
                return;
            }
        }
        throw new InternalError("configuration " + FilterGeneric.patternName(s, s2, c));
    }

    public String toString() {
        return "FilterGeneric/" + this.patternName() + this.targetType;
    }

    String patternName() {
        return FilterGeneric.patternName(this.argumentPosition, this.argumentCount, this.replaceMode);
    }

    static String patternName(short s, short s2, char c) {
        return "" + c + s + (s2 > 1 ? "_" + s2 : "");
    }

    Class<?> filterType() {
        return Object.class;
    }

    static MethodType targetType(MethodType methodType, short n, short n2, char c, Class<?> clazz) {
        MethodType methodType2 = methodType;
        int n3 = n;
        switch (c) {
            case 'A': {
                n3 += n2;
            }
            case 'P': {
                methodType2 = methodType2.insertParameterType(n3, clazz);
                break;
            }
            case 'I': {
                for (int i = 1; i < n2; ++i) {
                    methodType2 = methodType2.dropParameterType(n3);
                }
                assert (methodType2.parameterType(n3) == clazz);
                break;
            }
        }
        return methodType2;
    }

    static MethodType entryType(MethodType methodType, short n, short n2, char c, Class<?> clazz) {
        MethodType methodType2 = methodType;
        int n3 = n;
        switch (c) {
            case 'A': {
                n3 += n2;
            }
            case 'P': {
                methodType2 = methodType2.dropParameterType(n3);
                break;
            }
            case 'I': {
                for (int i = 1; i < n2; ++i) {
                    methodType2 = methodType2.insertParameterType(n3, clazz);
                }
                assert (methodType2.parameterType(n3) == clazz);
                break;
            }
        }
        return methodType2;
    }

    static Adapter findAdapter(MethodType methodType, short s, short s2, char c, Class<?> clazz) {
        MethodType methodType2 = FilterGeneric.entryType(methodType, s, s2, c, clazz);
        int n = methodType.parameterCount();
        String string = FilterGeneric.patternName(s, s2, c);
        String string2 = "F" + n;
        String string3 = "F" + n + c;
        String string4 = "F" + n + string;
        String[] stringArray = new String[]{string2, string3, string3 + "X", string4};
        String string5 = "invoke_" + string;
        for (String string6 : stringArray) {
            Class<? extends Adapter> clazz2 = Adapter.findSubClass(string6);
            if (clazz2 == null) continue;
            MethodHandle methodHandle = null;
            try {
                methodHandle = MethodHandleImpl.IMPL_LOOKUP.findSpecial(clazz2, string5, methodType2, clazz2);
            }
            catch (NoAccessException noAccessException) {
                // empty catch block
            }
            if (methodHandle == null) continue;
            Constructor<? extends Adapter> constructor = null;
            try {
                constructor = clazz2.getDeclaredConstructor(MethodHandle.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (constructor == null) continue;
            try {
                return constructor.newInstance(methodHandle);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    static Adapter buildAdapterFromBytecodes(MethodType methodType, short s, short s2, char c, Class<?> clazz) {
        throw new UnsupportedOperationException("NYI");
    }

    static class F4RX
    extends Adapter {
        protected F4RX(MethodHandle methodHandle) {
            super(methodHandle);
        }

        protected F4RX(MethodHandle methodHandle, MethodHandle methodHandle2, MethodHandle methodHandle3) {
            super(methodHandle, methodHandle2, methodHandle3);
        }

        protected F4RX makeInstance(MethodHandle methodHandle, MethodHandle methodHandle2, MethodHandle methodHandle3) {
            return new F4RX(methodHandle, methodHandle2, methodHandle3);
        }

        protected Object filter(Object object) {
            return this.filter.invoke(object);
        }

        protected Object target(Object object, Object object2, Object object3, Object object4) {
            return this.target.invoke(object, object2, object3, object4);
        }

        protected Object invoke_R0(Object object, Object object2, Object object3, Object object4) {
            return this.target(this.filter(object), object2, object3, object4);
        }

        protected Object invoke_R1(Object object, Object object2, Object object3, Object object4) {
            return this.target(object, this.filter(object2), object3, object4);
        }

        protected Object invoke_R2(Object object, Object object2, Object object3, Object object4) {
            return this.target(object, object2, this.filter(object3), object4);
        }

        protected Object invoke_R3(Object object, Object object2, Object object3, Object object4) {
            return this.target(object, object2, object3, this.filter(object4));
        }
    }

    static class F3RX
    extends Adapter {
        protected F3RX(MethodHandle methodHandle) {
            super(methodHandle);
        }

        protected F3RX(MethodHandle methodHandle, MethodHandle methodHandle2, MethodHandle methodHandle3) {
            super(methodHandle, methodHandle2, methodHandle3);
        }

        protected F3RX makeInstance(MethodHandle methodHandle, MethodHandle methodHandle2, MethodHandle methodHandle3) {
            return new F3RX(methodHandle, methodHandle2, methodHandle3);
        }

        protected Object filter(Object object) {
            return this.filter.invoke(object);
        }

        protected Object target(Object object, Object object2, Object object3) {
            return this.target.invoke(object, object2, object3);
        }

        protected Object invoke_R0(Object object, Object object2, Object object3) {
            return this.target(this.filter(object), object2, object3);
        }

        protected Object invoke_R1(Object object, Object object2, Object object3) {
            return this.target(object, this.filter(object2), object3);
        }

        protected Object invoke_R2(Object object, Object object2, Object object3) {
            return this.target(object, object2, this.filter(object3));
        }
    }

    static class F2RX
    extends Adapter {
        protected F2RX(MethodHandle methodHandle) {
            super(methodHandle);
        }

        protected F2RX(MethodHandle methodHandle, MethodHandle methodHandle2, MethodHandle methodHandle3) {
            super(methodHandle, methodHandle2, methodHandle3);
        }

        protected F2RX makeInstance(MethodHandle methodHandle, MethodHandle methodHandle2, MethodHandle methodHandle3) {
            return new F2RX(methodHandle, methodHandle2, methodHandle3);
        }

        protected Object filter(Object object) {
            return this.filter.invoke(object);
        }

        protected Object target(Object object, Object object2) {
            return this.target.invoke(object, object2);
        }

        protected Object invoke_R0(Object object, Object object2) {
            return this.target(this.filter(object), object2);
        }

        protected Object invoke_R1(Object object, Object object2) {
            return this.target(object, this.filter(object2));
        }
    }

    static class F1RX
    extends Adapter {
        protected F1RX(MethodHandle methodHandle) {
            super(methodHandle);
        }

        protected F1RX(MethodHandle methodHandle, MethodHandle methodHandle2, MethodHandle methodHandle3) {
            super(methodHandle, methodHandle2, methodHandle3);
        }

        protected F1RX makeInstance(MethodHandle methodHandle, MethodHandle methodHandle2, MethodHandle methodHandle3) {
            return new F1RX(methodHandle, methodHandle2, methodHandle3);
        }

        protected Object filter(Object object) {
            return this.filter.invoke(object);
        }

        protected Object target(Object object) {
            return this.target.invoke(object);
        }

        protected Object invoke_R0(Object object) {
            return this.target(this.filter(object));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class Adapter
    extends JavaMethodHandle {
        protected final MethodHandle filter;
        protected final MethodHandle target;
        private static final String CLASS_PREFIX;

        protected boolean isPrototype() {
            return this.target == null;
        }

        protected Adapter(MethodHandle methodHandle) {
            this(methodHandle, methodHandle, null);
            assert (this.isPrototype());
        }

        protected MethodHandle prototypeEntryPoint() {
            if (!this.isPrototype()) {
                throw new InternalError();
            }
            return this.filter;
        }

        protected Adapter(MethodHandle methodHandle, MethodHandle methodHandle2, MethodHandle methodHandle3) {
            super(methodHandle);
            this.filter = methodHandle2;
            this.target = methodHandle3;
        }

        protected abstract Adapter makeInstance(MethodHandle var1, MethodHandle var2, MethodHandle var3);

        static Class<? extends Adapter> findSubClass(String string) {
            String string2 = CLASS_PREFIX + string;
            try {
                return Class.forName(string2).asSubclass(Adapter.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
            catch (ClassCastException classCastException) {
                return null;
            }
        }

        static {
            String string;
            String string2 = Adapter.class.getName();
            if (!string2.endsWith(string = Adapter.class.getSimpleName())) {
                throw new InternalError();
            }
            CLASS_PREFIX = string2.substring(0, string2.length() - string.length());
        }
    }
}

