/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.io.ByteArrayInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMURIReference;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.keyinfo.RetrievalMethod;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jcp.xml.dsig.internal.dom.ApacheData;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMTransform;
import org.jcp.xml.dsig.internal.dom.DOMURIDereferencer;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.jcp.xml.dsig.internal.dom.DOMX509Data;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMRetrievalMethod
extends DOMStructure
implements RetrievalMethod,
DOMURIReference {
    private final List transforms;
    private String uri;
    private String type;
    private Attr here;

    public DOMRetrievalMethod(String string, String string2, List list) {
        if (string == null) {
            throw new NullPointerException("uri cannot be null");
        }
        if (list == null || list.isEmpty()) {
            this.transforms = Collections.EMPTY_LIST;
        } else {
            ArrayList arrayList = new ArrayList(list);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                if (arrayList.get(i) instanceof Transform) continue;
                throw new ClassCastException("transforms[" + i + "] is not a valid type");
            }
            this.transforms = Collections.unmodifiableList(arrayList);
        }
        this.uri = string;
        if (string != null && !string.equals("")) {
            try {
                new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException(uRISyntaxException.getMessage());
            }
        }
        this.type = string2;
    }

    public DOMRetrievalMethod(Element element, XMLCryptoContext xMLCryptoContext, Provider provider) throws MarshalException {
        this.uri = DOMUtils.getAttributeValue(element, "URI");
        this.type = DOMUtils.getAttributeValue(element, "Type");
        this.here = element.getAttributeNodeNS(null, "URI");
        ArrayList<DOMTransform> arrayList = new ArrayList<DOMTransform>();
        Element element2 = DOMUtils.getFirstChildElement(element);
        if (element2 != null) {
            Element element3 = DOMUtils.getFirstChildElement(element2);
            while (element3 != null) {
                arrayList.add(new DOMTransform(element3, xMLCryptoContext, provider));
                element3 = DOMUtils.getNextSiblingElement(element3);
            }
        }
        this.transforms = arrayList.isEmpty() ? Collections.EMPTY_LIST : Collections.unmodifiableList(arrayList);
    }

    public String getURI() {
        return this.uri;
    }

    public String getType() {
        return this.type;
    }

    public List getTransforms() {
        return this.transforms;
    }

    public void marshal(Node node, String string, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Document document = DOMUtils.getOwnerDocument(node);
        Element element = DOMUtils.createElement(document, "RetrievalMethod", "http://www.w3.org/2000/09/xmldsig#", string);
        DOMUtils.setAttribute(element, "URI", this.uri);
        DOMUtils.setAttribute(element, "Type", this.type);
        if (!this.transforms.isEmpty()) {
            Element element2 = DOMUtils.createElement(document, "Transforms", "http://www.w3.org/2000/09/xmldsig#", string);
            element.appendChild(element2);
            int n = this.transforms.size();
            for (int i = 0; i < n; ++i) {
                ((DOMTransform)this.transforms.get(i)).marshal(element2, string, dOMCryptoContext);
            }
        }
        node.appendChild(element);
        this.here = element.getAttributeNodeNS(null, "URI");
    }

    public Node getHere() {
        return this.here;
    }

    public Data dereference(XMLCryptoContext xMLCryptoContext) throws URIReferenceException {
        if (xMLCryptoContext == null) {
            throw new NullPointerException("context cannot be null");
        }
        URIDereferencer uRIDereferencer = xMLCryptoContext.getURIDereferencer();
        if (uRIDereferencer == null) {
            uRIDereferencer = DOMURIDereferencer.INSTANCE;
        }
        Data data = uRIDereferencer.dereference(this, xMLCryptoContext);
        try {
            int n = this.transforms.size();
            for (int i = 0; i < n; ++i) {
                Transform transform = (Transform)this.transforms.get(i);
                data = ((DOMTransform)transform).transform(data, xMLCryptoContext);
            }
        }
        catch (Exception exception) {
            throw new URIReferenceException(exception);
        }
        return data;
    }

    public XMLStructure dereferenceAsXMLStructure(XMLCryptoContext xMLCryptoContext) throws URIReferenceException {
        try {
            ApacheData apacheData = (ApacheData)this.dereference(xMLCryptoContext);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(apacheData.getXMLSignatureInput().getBytes()));
            Element element = document.getDocumentElement();
            if (element.getLocalName().equals("X509Data")) {
                return new DOMX509Data(element);
            }
            return null;
        }
        catch (Exception exception) {
            throw new URIReferenceException(exception);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RetrievalMethod)) {
            return false;
        }
        RetrievalMethod retrievalMethod = (RetrievalMethod)object;
        boolean bl = this.type == null ? retrievalMethod.getType() == null : this.type.equals(retrievalMethod.getType());
        return this.uri.equals(retrievalMethod.getURI()) && this.transforms.equals(retrievalMethod.getTransforms()) && bl;
    }
}

