/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import sun.awt.AppContext;

class TimerQueue
implements Runnable {
    private static final Object sharedInstanceKey = new StringBuffer("TimerQueue.sharedInstanceKey");
    private static final Object expiredTimersKey = new StringBuffer("TimerQueue.expiredTimersKey");
    private final DelayQueue<DelayedTimer> queue = new DelayQueue();
    private volatile boolean running;
    private final Lock runningLock = new ReentrantLock();
    private static final Object classLock = new Object();
    private static final long NANO_ORIGIN = System.nanoTime();

    public TimerQueue() {
        this.startIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimerQueue sharedInstance() {
        Object object = classLock;
        synchronized (object) {
            TimerQueue timerQueue = (TimerQueue)SwingUtilities.appContextGet(sharedInstanceKey);
            if (timerQueue == null) {
                timerQueue = new TimerQueue();
                SwingUtilities.appContextPut(sharedInstanceKey, timerQueue);
            }
            return timerQueue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startIfNeeded() {
        if (!this.running) {
            this.runningLock.lock();
            try {
                final ThreadGroup threadGroup = AppContext.getAppContext().getThreadGroup();
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        Thread thread = new Thread(threadGroup, TimerQueue.this, "TimerQueue");
                        thread.setDaemon(true);
                        thread.setPriority(5);
                        thread.start();
                        return null;
                    }
                });
                this.running = true;
                Object var3_2 = null;
                this.runningLock.unlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.runningLock.unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTimer(Timer timer, long l) {
        timer.getLock().lock();
        try {
            if (!this.containsTimer(timer)) {
                this.addTimer(new DelayedTimer(timer, TimeUnit.MILLISECONDS.toNanos(l) + TimerQueue.now()));
            }
            Object var5_3 = null;
            timer.getLock().unlock();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            timer.getLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTimer(DelayedTimer delayedTimer) {
        assert (delayedTimer != null && !this.containsTimer(delayedTimer.getTimer()));
        Timer timer = delayedTimer.getTimer();
        timer.getLock().lock();
        try {
            timer.delayedTimer = delayedTimer;
            this.queue.add(delayedTimer);
            Object var4_3 = null;
            timer.getLock().unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            timer.getLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTimer(Timer timer) {
        timer.getLock().lock();
        try {
            if (timer.delayedTimer != null) {
                this.queue.remove(timer.delayedTimer);
                timer.delayedTimer = null;
            }
            Object var3_2 = null;
            timer.getLock().unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            timer.getLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containsTimer(Timer timer) {
        timer.getLock().lock();
        try {
            boolean bl = timer.delayedTimer != null;
            Object var4_3 = null;
            timer.getLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            timer.getLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.runningLock.lock();
        try {
            try {
                while (this.running) {
                    try {
                        Object var4_7;
                        Timer timer = ((DelayedTimer)this.queue.take()).getTimer();
                        timer.getLock().lock();
                        try {
                            block12: {
                                try {
                                    DelayedTimer delayedTimer = timer.delayedTimer;
                                    if (delayedTimer == null) break block12;
                                    timer.post();
                                    timer.delayedTimer = null;
                                    if (!timer.isRepeats()) break block12;
                                    delayedTimer.setTime(TimerQueue.now() + TimeUnit.MILLISECONDS.toNanos(timer.getDelay()));
                                    this.addTimer(delayedTimer);
                                }
                                catch (SecurityException securityException) {
                                    var4_7 = null;
                                    timer.getLock().unlock();
                                    continue;
                                }
                            }
                            var4_7 = null;
                            timer.getLock().unlock();
                        }
                        catch (Throwable throwable) {
                            var4_7 = null;
                            timer.getLock().unlock();
                            throw throwable;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        if (!AppContext.getAppContext().isDisposed()) continue;
                    }
                }
                Object var6_10 = null;
                this.running = false;
                this.runningLock.unlock();
                return;
            }
            catch (ThreadDeath threadDeath) {
                Iterator<DelayedTimer> iterator = this.queue.iterator();
                while (iterator.hasNext()) {
                    DelayedTimer delayedTimer = iterator.next();
                    delayedTimer.getTimer().cancelEvent();
                }
                throw threadDeath;
            }
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            this.running = false;
            this.runningLock.unlock();
            throw throwable;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("TimerQueue (");
        boolean bl = true;
        for (DelayedTimer delayedTimer : this.queue) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(delayedTimer.getTimer().toString());
            bl = false;
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private static long now() {
        return System.nanoTime() - NANO_ORIGIN;
    }

    static class DelayedTimer
    implements Delayed {
        private static final AtomicLong sequencer = new AtomicLong(0L);
        private final long sequenceNumber;
        private volatile long time;
        private final Timer timer;

        DelayedTimer(Timer timer, long l) {
            this.timer = timer;
            this.time = l;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        public final long getDelay(TimeUnit timeUnit) {
            return timeUnit.convert(this.time - TimerQueue.now(), TimeUnit.NANOSECONDS);
        }

        final void setTime(long l) {
            this.time = l;
        }

        final Timer getTimer() {
            return this.timer;
        }

        public int compareTo(Delayed delayed) {
            if (delayed == this) {
                return 0;
            }
            if (delayed instanceof DelayedTimer) {
                DelayedTimer delayedTimer = (DelayedTimer)delayed;
                long l = this.time - delayedTimer.time;
                if (l < 0L) {
                    return -1;
                }
                if (l > 0L) {
                    return 1;
                }
                if (this.sequenceNumber < delayedTimer.sequenceNumber) {
                    return -1;
                }
                return 1;
            }
            long l = this.getDelay(TimeUnit.NANOSECONDS) - delayed.getDelay(TimeUnit.NANOSECONDS);
            return l == 0L ? 0 : (l < 0L ? -1 : 1);
        }
    }
}

