/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;

public class SysexMessage
extends MidiMessage {
    public static final int SYSTEM_EXCLUSIVE = 240;
    public static final int SPECIAL_SYSTEM_EXCLUSIVE = 247;

    public SysexMessage() {
        this(new byte[2]);
        this.data[0] = -16;
        this.data[1] = -9;
    }

    public SysexMessage(byte[] byArray, int n) throws InvalidMidiDataException {
        super(null);
        this.setMessage(byArray, n);
    }

    public SysexMessage(int n, byte[] byArray, int n2) throws InvalidMidiDataException {
        super(null);
        this.setMessage(n, byArray, n2);
    }

    protected SysexMessage(byte[] byArray) {
        super(byArray);
    }

    public void setMessage(byte[] byArray, int n) throws InvalidMidiDataException {
        int n2 = byArray[0] & 0xFF;
        if (n2 != 240 && n2 != 247) {
            throw new InvalidMidiDataException("Invalid status byte for sysex message: 0x" + Integer.toHexString(n2));
        }
        super.setMessage(byArray, n);
    }

    public void setMessage(int n, byte[] byArray, int n2) throws InvalidMidiDataException {
        if (n != 240 && n != 247) {
            throw new InvalidMidiDataException("Invalid status byte for sysex message: 0x" + Integer.toHexString(n));
        }
        if (n2 < 0 || n2 > byArray.length) {
            throw new IndexOutOfBoundsException("length out of bounds: " + n2);
        }
        this.length = n2 + 1;
        if (this.data == null || this.data.length < this.length) {
            this.data = new byte[this.length];
        }
        this.data[0] = (byte)(n & 0xFF);
        if (n2 > 0) {
            System.arraycopy(byArray, 0, this.data, 1, n2);
        }
    }

    public byte[] getData() {
        byte[] byArray = new byte[this.length - 1];
        System.arraycopy(this.data, 1, byArray, 0, this.length - 1);
        return byArray;
    }

    public Object clone() {
        byte[] byArray = new byte[this.length];
        System.arraycopy(this.data, 0, byArray, 0, byArray.length);
        SysexMessage sysexMessage = new SysexMessage(byArray);
        return sysexMessage;
    }
}

