/*
 * Decompiled with CFR 0.152.
 */
package java.nio.file.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileRef;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.Attributes;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPath
extends Path {
    private static final DirectoryStream.Filter<Path> acceptAllFilter = new DirectoryStream.Filter<Path>(){

        @Override
        public boolean accept(Path path) {
            return true;
        }
    };
    private static final WatchEvent.Modifier[] NO_MODIFIERS = new WatchEvent.Modifier[0];

    protected AbstractPath() {
    }

    @Override
    public void delete() throws IOException {
        this.delete(true);
    }

    @Override
    public Path createFile(FileAttribute<?> ... fileAttributeArray) throws IOException {
        EnumSet<StandardOpenOption> enumSet = EnumSet.of(StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        SeekableByteChannel seekableByteChannel = this.newByteChannel(enumSet, fileAttributeArray);
        try {
            seekableByteChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public SeekableByteChannel newByteChannel(OpenOption ... openOptionArray) throws IOException {
        HashSet hashSet = new HashSet(openOptionArray.length);
        Collections.addAll(hashSet, openOptionArray);
        return this.newByteChannel(hashSet, new FileAttribute[0]);
    }

    @Override
    public InputStream newInputStream() throws IOException {
        return Channels.newInputStream(this.newByteChannel(new OpenOption[0]));
    }

    private OutputStream implNewOutputStream(Set<OpenOption> set, FileAttribute<?> ... fileAttributeArray) throws IOException {
        if (set.isEmpty()) {
            set.add(StandardOpenOption.CREATE);
            set.add(StandardOpenOption.TRUNCATE_EXISTING);
        } else if (set.contains(StandardOpenOption.READ)) {
            throw new IllegalArgumentException("READ not allowed");
        }
        set.add(StandardOpenOption.WRITE);
        return Channels.newOutputStream(this.newByteChannel(set, fileAttributeArray));
    }

    @Override
    public OutputStream newOutputStream(OpenOption ... openOptionArray) throws IOException {
        int n = openOptionArray.length;
        HashSet<OpenOption> hashSet = new HashSet<OpenOption>(n + 3);
        if (n > 0) {
            for (OpenOption openOption : openOptionArray) {
                hashSet.add(openOption);
            }
        }
        return this.implNewOutputStream(hashSet, new FileAttribute[0]);
    }

    @Override
    public OutputStream newOutputStream(Set<? extends OpenOption> set, FileAttribute<?> ... fileAttributeArray) throws IOException {
        HashSet<OpenOption> hashSet = new HashSet<OpenOption>(set);
        return this.implNewOutputStream(hashSet, fileAttributeArray);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream() throws IOException {
        return this.newDirectoryStream(acceptAllFilter);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(String string) throws IOException {
        if (string.equals("*")) {
            return this.newDirectoryStream();
        }
        final PathMatcher pathMatcher = this.getFileSystem().getPathMatcher("glob:" + string);
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path path) {
                return pathMatcher.matches(path.getName());
            }
        };
        return this.newDirectoryStream((DirectoryStream.Filter<? super Path>)filter);
    }

    @Override
    public boolean exists() {
        try {
            this.checkAccess(new AccessMode[0]);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public boolean notExists() {
        try {
            this.checkAccess(new AccessMode[0]);
            return false;
        }
        catch (NoSuchFileException noSuchFileException) {
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public WatchKey register(WatchService watchService, WatchEvent.Kind<?> ... kindArray) throws IOException {
        return this.register(watchService, kindArray, NO_MODIFIERS);
    }

    protected abstract void implCopyTo(Path var1, CopyOption ... var2) throws IOException;

    protected abstract void implMoveTo(Path var1, CopyOption ... var2) throws IOException;

    @Override
    public final Path copyTo(Path path, CopyOption ... copyOptionArray) throws IOException {
        if (this.getFileSystem().provider() == path.getFileSystem().provider()) {
            this.implCopyTo(path, copyOptionArray);
        } else {
            this.xProviderCopyTo(path, copyOptionArray);
        }
        return path;
    }

    @Override
    public final Path moveTo(Path path, CopyOption ... copyOptionArray) throws IOException {
        if (this.getFileSystem().provider() == path.getFileSystem().provider()) {
            this.implMoveTo(path, copyOptionArray);
        } else {
            this.xProviderCopyTo(path, AbstractPath.convertMoveToCopyOptions(copyOptionArray));
            this.delete(false);
        }
        return path;
    }

    private static CopyOption[] convertMoveToCopyOptions(CopyOption ... copyOptionArray) throws AtomicMoveNotSupportedException {
        int n = copyOptionArray.length;
        CopyOption[] copyOptionArray2 = new CopyOption[n + 2];
        for (int i = 0; i < n; ++i) {
            CopyOption copyOption = copyOptionArray[i];
            if (copyOption == StandardCopyOption.ATOMIC_MOVE) {
                throw new AtomicMoveNotSupportedException(null, null, "Atomic move between providers is not supported");
            }
            copyOptionArray2[i] = copyOption;
        }
        copyOptionArray2[n] = LinkOption.NOFOLLOW_LINKS;
        copyOptionArray2[n + 1] = StandardCopyOption.COPY_ATTRIBUTES;
        return copyOptionArray2;
    }

    private void xProviderCopyTo(Path path, CopyOption ... copyOptionArray) throws IOException {
        LinkOption[] linkOptionArray;
        CopyOptions copyOptions = CopyOptions.parse(copyOptionArray);
        if (copyOptions.followLinks) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] linkOptionArray3 = linkOptionArray;
        BasicFileAttributes basicFileAttributes = Attributes.readBasicFileAttributes(this, linkOptionArray3);
        if (basicFileAttributes.isSymbolicLink()) {
            throw new IOException("Copying of symbolic links not supported");
        }
        if (copyOptions.replaceExisting) {
            path.delete(false);
        }
        if (basicFileAttributes.isDirectory()) {
            path.createDirectory(new FileAttribute[0]);
        } else {
            this.xProviderCopyRegularFileTo(path);
        }
        if (copyOptions.copyAttributes) {
            BasicFileAttributeView basicFileAttributeView = path.getFileAttributeView(BasicFileAttributeView.class, linkOptionArray3);
            try {
                basicFileAttributeView.setTimes(basicFileAttributes.lastModifiedTime(), basicFileAttributes.lastAccessTime(), basicFileAttributes.creationTime(), basicFileAttributes.resolution());
            }
            catch (IOException iOException) {
                try {
                    path.delete(false);
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                throw iOException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void xProviderCopyRegularFileTo(FileRef fileRef) throws IOException {
        SeekableByteChannel seekableByteChannel = this.newByteChannel(new OpenOption[0]);
        try {
            SeekableByteChannel seekableByteChannel2 = fileRef.newByteChannel(StandardOpenOption.CREATE, StandardOpenOption.WRITE);
            try {
                ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[8192]);
                int n = 0;
                while ((n = seekableByteChannel.read(byteBuffer)) >= 0) {
                    assert (n > 0);
                    byteBuffer.flip();
                    while (byteBuffer.hasRemaining()) {
                        seekableByteChannel2.write(byteBuffer);
                    }
                    byteBuffer.rewind();
                }
            }
            finally {
                seekableByteChannel2.close();
            }
        }
        finally {
            seekableByteChannel.close();
        }
    }

    private static class CopyOptions {
        boolean replaceExisting = false;
        boolean copyAttributes = false;
        boolean followLinks = true;

        private CopyOptions() {
        }

        static CopyOptions parse(CopyOption ... copyOptionArray) {
            CopyOptions copyOptions = new CopyOptions();
            for (CopyOption copyOption : copyOptionArray) {
                if (copyOption == StandardCopyOption.REPLACE_EXISTING) {
                    copyOptions.replaceExisting = true;
                    continue;
                }
                if (copyOption == LinkOption.NOFOLLOW_LINKS) {
                    copyOptions.followLinks = false;
                    continue;
                }
                if (copyOption == StandardCopyOption.COPY_ATTRIBUTES) {
                    copyOptions.copyAttributes = true;
                    continue;
                }
                if (copyOption == null) {
                    throw new NullPointerException();
                }
                throw new IllegalArgumentException("'" + copyOption + "' is not a valid copy option");
            }
            return copyOptions;
        }
    }
}

