/*
 * Decompiled with CFR 0.152.
 */
package java.nio.file;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAction;
import java.nio.file.FileRef;
import java.nio.file.FileTreeWalker;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.spi.FileTypeDetector;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.EnumSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import sun.nio.fs.DefaultFileTypeDetector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Files {
    private Files() {
    }

    public static String probeContentType(FileRef fileRef) throws IOException {
        for (FileTypeDetector fileTypeDetector : DefaultFileTypeDetectorHolder.installeDetectors) {
            String string = fileTypeDetector.probeContentType(fileRef);
            if (string == null) continue;
            return string;
        }
        return DefaultFileTypeDetectorHolder.defaultFileTypeDetector.probeContentType(fileRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withDirectory(Path path, DirectoryStream.Filter<? super Path> filter, FileAction<? super Path> fileAction) throws IOException {
        if (fileAction == null) {
            throw new NullPointerException();
        }
        DirectoryStream<Path> directoryStream = path.newDirectoryStream(filter);
        try {
            boolean bl = false;
            try {
                for (Path path2 : directoryStream) {
                    bl = true;
                    fileAction.invoke(path2);
                    bl = false;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                Throwable throwable;
                if (!bl && (throwable = concurrentModificationException.getCause()) instanceof IOException) {
                    throw (IOException)throwable;
                }
                throw concurrentModificationException;
            }
        }
        finally {
            try {
                directoryStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void withDirectory(Path path, String string, FileAction<? super Path> fileAction) throws IOException {
        if (string == null) {
            throw new NullPointerException("'glob' is null");
        }
        final PathMatcher pathMatcher = path.getFileSystem().getPathMatcher("glob:" + string);
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path path) {
                return pathMatcher.matches(path.getName());
            }
        };
        Files.withDirectory(path, (DirectoryStream.Filter<? super Path>)filter, fileAction);
    }

    public static void withDirectory(Path path, FileAction<? super Path> fileAction) throws IOException {
        Files.withDirectory(path, "*", fileAction);
    }

    public static void walkFileTree(Path path, Set<FileVisitOption> set, int n, FileVisitor<? super Path> fileVisitor) {
        if (n < 0) {
            throw new IllegalArgumentException("'maxDepth' is negative");
        }
        new FileTreeWalker(set, fileVisitor).walk(path, n);
    }

    public static void walkFileTree(Path path, FileVisitor<? super Path> fileVisitor) {
        Files.walkFileTree(path, EnumSet.noneOf(FileVisitOption.class), Integer.MAX_VALUE, fileVisitor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultFileTypeDetectorHolder {
        static final FileTypeDetector defaultFileTypeDetector = DefaultFileTypeDetector.create();
        static final List<FileTypeDetector> installeDetectors = DefaultFileTypeDetectorHolder.loadInstalledDetectors();

        private DefaultFileTypeDetectorHolder() {
        }

        private static List<FileTypeDetector> loadInstalledDetectors() {
            return AccessController.doPrivileged(new PrivilegedAction<List<FileTypeDetector>>(){

                @Override
                public List<FileTypeDetector> run() {
                    ArrayList<FileTypeDetector> arrayList = new ArrayList<FileTypeDetector>();
                    ServiceLoader<FileTypeDetector> serviceLoader = ServiceLoader.load(FileTypeDetector.class, ClassLoader.getSystemClassLoader());
                    for (FileTypeDetector fileTypeDetector : serviceLoader) {
                        arrayList.add(fileTypeDetector);
                    }
                    return arrayList;
                }
            });
        }
    }
}

