/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.wsdl.parser;

import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLBoundPortType;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLFault;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLFeaturedObject;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLModel;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLOperation;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLService;
import com.sun.xml.internal.ws.api.wsdl.parser.WSDLParserExtension;
import com.sun.xml.internal.ws.api.wsdl.parser.WSDLParserExtensionContext;
import com.sun.xml.internal.ws.model.wsdl.WSDLBoundOperationImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLBoundPortTypeImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLOperationImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLPortImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLPortTypeImpl;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.internal.ws.wsdl.parser.ParserUtil;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.AddressingFeature;

public class W3CAddressingWSDLParserExtension
extends WSDLParserExtension {
    protected static final String COLON_DELIMITER = ":";
    protected static final String SLASH_DELIMITER = "/";

    public boolean bindingElements(WSDLBoundPortType wSDLBoundPortType, XMLStreamReader xMLStreamReader) {
        return this.addressibleElement(xMLStreamReader, wSDLBoundPortType);
    }

    public boolean portElements(WSDLPort wSDLPort, XMLStreamReader xMLStreamReader) {
        return this.addressibleElement(xMLStreamReader, wSDLPort);
    }

    private boolean addressibleElement(XMLStreamReader xMLStreamReader, WSDLFeaturedObject wSDLFeaturedObject) {
        QName qName = xMLStreamReader.getName();
        if (qName.equals(AddressingVersion.W3C.wsdlExtensionTag)) {
            String string = xMLStreamReader.getAttributeValue("http://schemas.xmlsoap.org/wsdl/", "required");
            wSDLFeaturedObject.addFeature(new AddressingFeature(true, Boolean.parseBoolean(string)));
            XMLStreamReaderUtil.skipElement(xMLStreamReader);
            return true;
        }
        return false;
    }

    public boolean bindingOperationElements(WSDLBoundOperation wSDLBoundOperation, XMLStreamReader xMLStreamReader) {
        WSDLBoundOperationImpl wSDLBoundOperationImpl = (WSDLBoundOperationImpl)wSDLBoundOperation;
        QName qName = xMLStreamReader.getName();
        if (qName.equals(AddressingVersion.W3C.wsdlAnonymousTag)) {
            block7: {
                try {
                    String string = xMLStreamReader.getElementText();
                    if (string == null || string.trim().equals("")) {
                        throw new WebServiceException("Null values not permitted in wsaw:Anonymous.");
                    }
                    if (string.equals("optional")) {
                        wSDLBoundOperationImpl.setAnonymous(WSDLBoundOperation.ANONYMOUS.optional);
                        break block7;
                    }
                    if (string.equals("required")) {
                        wSDLBoundOperationImpl.setAnonymous(WSDLBoundOperation.ANONYMOUS.required);
                        break block7;
                    }
                    if (string.equals("prohibited")) {
                        wSDLBoundOperationImpl.setAnonymous(WSDLBoundOperation.ANONYMOUS.prohibited);
                        break block7;
                    }
                    throw new WebServiceException("wsaw:Anonymous value \"" + string + "\" not understood.");
                }
                catch (XMLStreamException xMLStreamException) {
                    throw new WebServiceException(xMLStreamException);
                }
            }
            return true;
        }
        return false;
    }

    public boolean portTypeOperationInput(WSDLOperation wSDLOperation, XMLStreamReader xMLStreamReader) {
        WSDLOperationImpl wSDLOperationImpl = (WSDLOperationImpl)wSDLOperation;
        String string = ParserUtil.getAttribute(xMLStreamReader, AddressingVersion.W3C.wsdlActionTag);
        if (string != null) {
            wSDLOperationImpl.getInput().setAction(string);
            wSDLOperationImpl.getInput().setDefaultAction(false);
        }
        return false;
    }

    public boolean portTypeOperationOutput(WSDLOperation wSDLOperation, XMLStreamReader xMLStreamReader) {
        WSDLOperationImpl wSDLOperationImpl = (WSDLOperationImpl)wSDLOperation;
        String string = ParserUtil.getAttribute(xMLStreamReader, AddressingVersion.W3C.wsdlActionTag);
        if (string != null) {
            wSDLOperationImpl.getOutput().setAction(string);
        }
        return false;
    }

    public boolean portTypeOperationFault(WSDLOperation wSDLOperation, XMLStreamReader xMLStreamReader) {
        WSDLOperationImpl wSDLOperationImpl = (WSDLOperationImpl)wSDLOperation;
        String string = ParserUtil.getAttribute(xMLStreamReader, AddressingVersion.W3C.wsdlActionTag);
        if (string != null) {
            String string2 = ParserUtil.getMandatoryNonEmptyAttribute(xMLStreamReader, "name");
            wSDLOperationImpl.getFaultActionMap().put(string2, string);
        }
        return false;
    }

    public void finished(WSDLParserExtensionContext wSDLParserExtensionContext) {
        WSDLModel wSDLModel = wSDLParserExtensionContext.getWSDLModel();
        for (WSDLService wSDLService : wSDLModel.getServices().values()) {
            for (WSDLPort wSDLPort : wSDLService.getPorts()) {
                WSDLPortImpl wSDLPortImpl = (WSDLPortImpl)wSDLPort;
                WSDLBoundPortTypeImpl wSDLBoundPortTypeImpl = wSDLPortImpl.getBinding();
                this.populateActions(wSDLBoundPortTypeImpl);
                this.patchAnonymousDefault(wSDLBoundPortTypeImpl);
            }
        }
    }

    protected String getNamespaceURI() {
        return AddressingVersion.W3C.wsdlNsUri;
    }

    private void populateActions(WSDLBoundPortTypeImpl wSDLBoundPortTypeImpl) {
        WSDLPortTypeImpl wSDLPortTypeImpl = wSDLBoundPortTypeImpl.getPortType();
        for (WSDLOperationImpl wSDLOperationImpl : wSDLPortTypeImpl.getOperations()) {
            WSDLBoundOperationImpl wSDLBoundOperationImpl = wSDLBoundPortTypeImpl.get(wSDLOperationImpl.getName());
            if (wSDLBoundOperationImpl == null) {
                wSDLOperationImpl.getInput().setAction(this.defaultInputAction(wSDLOperationImpl));
                continue;
            }
            String string = wSDLBoundOperationImpl.getSOAPAction();
            if (wSDLOperationImpl.getInput().getAction() == null || wSDLOperationImpl.getInput().getAction().equals("")) {
                if (string != null && !string.equals("")) {
                    wSDLOperationImpl.getInput().setAction(string);
                } else {
                    wSDLOperationImpl.getInput().setAction(this.defaultInputAction(wSDLOperationImpl));
                }
            }
            if (wSDLOperationImpl.getOutput() == null) continue;
            if (wSDLOperationImpl.getOutput().getAction() == null || wSDLOperationImpl.getOutput().getAction().equals("")) {
                wSDLOperationImpl.getOutput().setAction(this.defaultOutputAction(wSDLOperationImpl));
            }
            if (wSDLOperationImpl.getFaults() == null || !wSDLOperationImpl.getFaults().iterator().hasNext()) continue;
            Map<String, String> map = wSDLOperationImpl.getFaultActionMap();
            for (WSDLFault wSDLFault : wSDLOperationImpl.getFaults()) {
                if (map.get(wSDLFault.getName()) != null && !map.get(wSDLFault.getName()).equals("")) continue;
                map.put(wSDLFault.getName(), this.defaultFaultAction(wSDLFault.getName(), wSDLOperationImpl));
            }
        }
    }

    protected void patchAnonymousDefault(WSDLBoundPortTypeImpl wSDLBoundPortTypeImpl) {
        for (WSDLBoundOperationImpl wSDLBoundOperationImpl : wSDLBoundPortTypeImpl.getBindingOperations()) {
            if (wSDLBoundOperationImpl.getAnonymous() != null) continue;
            wSDLBoundOperationImpl.setAnonymous(WSDLBoundOperation.ANONYMOUS.optional);
        }
    }

    private String defaultInputAction(WSDLOperation wSDLOperation) {
        return W3CAddressingWSDLParserExtension.buildAction(wSDLOperation.getInput().getName(), wSDLOperation, false);
    }

    private String defaultOutputAction(WSDLOperation wSDLOperation) {
        return W3CAddressingWSDLParserExtension.buildAction(wSDLOperation.getOutput().getName(), wSDLOperation, false);
    }

    private String defaultFaultAction(String string, WSDLOperation wSDLOperation) {
        return W3CAddressingWSDLParserExtension.buildAction(string, wSDLOperation, true);
    }

    protected static final String buildAction(String string, WSDLOperation wSDLOperation, boolean bl) {
        String string2 = wSDLOperation.getName().getNamespaceURI();
        String string3 = SLASH_DELIMITER;
        if (!string2.startsWith("http")) {
            string3 = COLON_DELIMITER;
        }
        if (string2.endsWith(string3)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (wSDLOperation.getPortTypeName() == null) {
            throw new WebServiceException("\"" + wSDLOperation.getName() + "\" operation's owning portType name is null.");
        }
        return string2 + string3 + wSDLOperation.getPortTypeName().getLocalPart() + string3 + (bl ? wSDLOperation.getName().getLocalPart() + string3 + "Fault" + string3 : "") + string;
    }
}

