/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal.objects;

import com.sun.org.apache.xml.internal.dtm.DTM;
import com.sun.org.apache.xml.internal.dtm.DTMIterator;
import com.sun.org.apache.xml.internal.dtm.ref.DTMNodeIterator;
import com.sun.org.apache.xml.internal.dtm.ref.DTMNodeList;
import com.sun.org.apache.xml.internal.utils.FastStringBuffer;
import com.sun.org.apache.xml.internal.utils.WrappedRuntimeException;
import com.sun.org.apache.xml.internal.utils.XMLString;
import com.sun.org.apache.xpath.internal.Expression;
import com.sun.org.apache.xpath.internal.ExpressionNode;
import com.sun.org.apache.xpath.internal.NodeSetDTM;
import com.sun.org.apache.xpath.internal.XPathContext;
import com.sun.org.apache.xpath.internal.axes.RTFIterator;
import com.sun.org.apache.xpath.internal.objects.DTMXRTreeFrag;
import com.sun.org.apache.xpath.internal.objects.XObject;
import com.sun.org.apache.xpath.internal.objects.XString;
import javax.xml.transform.TransformerException;
import org.w3c.dom.NodeList;

public class XRTreeFrag
extends XObject
implements Cloneable {
    static final long serialVersionUID = -3201553822254911567L;
    private DTMXRTreeFrag m_DTMXRTreeFrag;
    private int m_dtmRoot = -1;
    protected boolean m_allowRelease = false;
    private XMLString m_xmlStr = null;

    public XRTreeFrag(int n, XPathContext xPathContext, ExpressionNode expressionNode) {
        super(null);
        this.exprSetParent(expressionNode);
        this.initDTM(n, xPathContext);
    }

    public XRTreeFrag(int n, XPathContext xPathContext) {
        super(null);
        this.initDTM(n, xPathContext);
    }

    private final void initDTM(int n, XPathContext xPathContext) {
        this.m_dtmRoot = n;
        DTM dTM = xPathContext.getDTM(n);
        if (dTM != null) {
            this.m_DTMXRTreeFrag = xPathContext.getDTMXRTreeFrag(xPathContext.getDTMIdentity(dTM));
        }
    }

    public Object object() {
        if (this.m_DTMXRTreeFrag.getXPathContext() != null) {
            return new DTMNodeIterator(new NodeSetDTM(this.m_dtmRoot, this.m_DTMXRTreeFrag.getXPathContext().getDTMManager()));
        }
        return super.object();
    }

    public XRTreeFrag(Expression expression) {
        super(expression);
    }

    public void allowDetachToRelease(boolean bl) {
        this.m_allowRelease = bl;
    }

    public void detach() {
        if (this.m_allowRelease) {
            this.m_DTMXRTreeFrag.destruct();
            this.m_obj = null;
        }
    }

    public int getType() {
        return 5;
    }

    public String getTypeString() {
        return "#RTREEFRAG";
    }

    public double num() throws TransformerException {
        XMLString xMLString = this.xstr();
        return xMLString.toDouble();
    }

    public boolean bool() {
        return true;
    }

    public XMLString xstr() {
        if (null == this.m_xmlStr) {
            this.m_xmlStr = this.m_DTMXRTreeFrag.getDTM().getStringValue(this.m_dtmRoot);
        }
        return this.m_xmlStr;
    }

    public void appendToFsb(FastStringBuffer fastStringBuffer) {
        XString xString = (XString)this.xstr();
        xString.appendToFsb(fastStringBuffer);
    }

    public String str() {
        String string = this.m_DTMXRTreeFrag.getDTM().getStringValue(this.m_dtmRoot).toString();
        return null == string ? "" : string;
    }

    public int rtf() {
        return this.m_dtmRoot;
    }

    public DTMIterator asNodeIterator() {
        return new RTFIterator(this.m_dtmRoot, this.m_DTMXRTreeFrag.getXPathContext().getDTMManager());
    }

    public NodeList convertToNodeset() {
        if (this.m_obj instanceof NodeList) {
            return (NodeList)this.m_obj;
        }
        return new DTMNodeList(this.asNodeIterator());
    }

    public boolean equals(XObject xObject) {
        try {
            if (4 == xObject.getType()) {
                return xObject.equals(this);
            }
            if (1 == xObject.getType()) {
                return this.bool() == xObject.bool();
            }
            if (2 == xObject.getType()) {
                return this.num() == xObject.num();
            }
            if (4 == xObject.getType()) {
                return this.xstr().equals(xObject.xstr());
            }
            if (3 == xObject.getType()) {
                return this.xstr().equals(xObject.xstr());
            }
            if (5 == xObject.getType()) {
                return this.xstr().equals(xObject.xstr());
            }
            return super.equals(xObject);
        }
        catch (TransformerException transformerException) {
            throw new WrappedRuntimeException(transformerException);
        }
    }
}

