/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DESKeyGenerator;
import com.sun.crypto.provider.DESedeKey;
import com.sun.crypto.provider.SunJCE;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

public final class DESedeKeyGenerator
extends KeyGeneratorSpi {
    private SecureRandom random = null;
    private int keysize = 168;

    public DESedeKeyGenerator() {
        if (!SunJCE.verifySelfIntegrity(this.getClass())) {
            throw new SecurityException("The SunJCE provider may have been tampered.");
        }
    }

    protected void engineInit(SecureRandom secureRandom) {
        this.random = secureRandom;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("Triple DES key generation does not take any parameters");
    }

    protected void engineInit(int n, SecureRandom secureRandom) {
        if (n != 112 && n != 168) {
            throw new InvalidParameterException("Wrong keysize: must be equal to 112 or 168");
        }
        this.keysize = n;
        this.engineInit(secureRandom);
    }

    protected SecretKey engineGenerateKey() {
        Object object;
        if (this.random == null) {
            this.random = SunJCE.RANDOM;
        }
        byte[] byArray = new byte[24];
        if (this.keysize == 168) {
            this.random.nextBytes(byArray);
            DESKeyGenerator.setParityBit(byArray, 0);
            DESKeyGenerator.setParityBit(byArray, 8);
            DESKeyGenerator.setParityBit(byArray, 16);
        } else {
            object = new byte[16];
            this.random.nextBytes((byte[])object);
            DESKeyGenerator.setParityBit(object, 0);
            DESKeyGenerator.setParityBit(object, 8);
            System.arraycopy(object, 0, byArray, 0, ((byte[])object).length);
            System.arraycopy(object, 0, byArray, 16, 8);
            Arrays.fill(object, (byte)0);
        }
        object = null;
        try {
            object = new DESedeKey(byArray);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException(invalidKeyException.getMessage());
        }
        Arrays.fill(byArray, (byte)0);
        return object;
    }
}

