/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities;

import sun.jvm.hotspot.debugger.Address;

public class AddressOps {
    public static boolean lessThan(Address a1, Address a2) {
        if (a2 == null) {
            return false;
        }
        if (a1 == null) {
            return true;
        }
        return a1.lessThan(a2);
    }

    public static boolean lessThanOrEqual(Address a1, Address a2) {
        if (a2 == null) {
            return a1 == null;
        }
        if (a1 == null) {
            return true;
        }
        return a1.lessThanOrEqual(a2);
    }

    public static boolean greaterThan(Address a1, Address a2) {
        if (a1 == null) {
            return false;
        }
        if (a2 == null) {
            return true;
        }
        return a1.greaterThan(a2);
    }

    public static boolean greaterThanOrEqual(Address a1, Address a2) {
        if (a1 == null) {
            return a2 == null;
        }
        if (a2 == null) {
            return true;
        }
        return a1.greaterThanOrEqual(a2);
    }

    public static boolean equal(Address a1, Address a2) {
        if (a1 == null && a2 == null) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        return ((Object)a1).equals(a2);
    }

    public static boolean lt(Address a1, Address a2) {
        return AddressOps.lessThan(a1, a2);
    }

    public static boolean lte(Address a1, Address a2) {
        return AddressOps.lessThanOrEqual(a1, a2);
    }

    public static boolean gt(Address a1, Address a2) {
        return AddressOps.greaterThan(a1, a2);
    }

    public static boolean gte(Address a1, Address a2) {
        return AddressOps.greaterThanOrEqual(a1, a2);
    }

    public static Address max(Address a1, Address a2) {
        return AddressOps.gt(a1, a2) ? a1 : a2;
    }

    public static Address min(Address a1, Address a2) {
        return AddressOps.lt(a1, a2) ? a1 : a2;
    }
}

