/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.Address;
import sun.jvm.hotspot.asm.BranchInstruction;
import sun.jvm.hotspot.asm.PCRelativeAddress;
import sun.jvm.hotspot.asm.SymbolFinder;
import sun.jvm.hotspot.asm.sparc.SPARCInstruction;

public class SPARCBranchInstruction
extends SPARCInstruction
implements BranchInstruction {
    protected final PCRelativeAddress addr;
    protected final int conditionCode;
    protected final boolean isAnnuled;

    public SPARCBranchInstruction(String name, PCRelativeAddress addr, boolean isAnnuled, int conditionCode) {
        super(name);
        this.addr = addr;
        this.conditionCode = conditionCode;
        this.isAnnuled = isAnnuled;
    }

    public String asString(long currentPc, SymbolFinder symFinder) {
        long address = this.addr.getDisplacement() + currentPc;
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName());
        buf.append(spaces);
        buf.append(symFinder.getSymbolFor(address));
        return buf.toString();
    }

    public Address getBranchDestination() {
        return this.addr;
    }

    public int getConditionCode() {
        return this.conditionCode;
    }

    public boolean isAnnuledBranch() {
        return this.isAnnuled;
    }

    public boolean isBranch() {
        return true;
    }

    public boolean isConditional() {
        return this.conditionCode != 0 && this.conditionCode != 8;
    }
}

