/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.text.BreakIterator;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabExpander;

public class Utilities {
    private static final int BUF_LENGTH = 64;

    public static final int drawTabbedText(Segment segment, int n, int n2, Graphics graphics, TabExpander tabExpander, int n3) {
        char[] cArray = segment.array;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n4 = fontMetrics.getAscent();
        int n5 = n;
        int n6 = n2 - n4;
        int n7 = 0;
        int n8 = segment.offset;
        int n9 = 0;
        int n10 = segment.offset + segment.count;
        block4: for (int i = segment.offset; i < n10; ++i) {
            char c = cArray[i];
            if (c == '\t' || c == '\n') {
                if (n9 > 0) {
                    graphics.drawChars(cArray, n8, n9, n5, n6 + n4);
                    n5 += n7;
                    n7 = 0;
                }
                n8 = i + 1;
                n9 = 0;
            }
            switch (c) {
                case '\t': {
                    if (tabExpander != null) {
                        n5 = (int)tabExpander.nextTabStop(n5, n3 + i - segment.offset);
                        continue block4;
                    }
                    n5 += fontMetrics.charWidth(' ');
                    continue block4;
                }
                case '\n': {
                    n6 += fontMetrics.getHeight();
                    n5 = n;
                    continue block4;
                }
                default: {
                    ++n9;
                    n7 += fontMetrics.charWidth(cArray[i]);
                }
            }
        }
        if (n9 > 0) {
            graphics.drawChars(cArray, n8, n9, n5, n6 + n4);
        }
        return n5 + n7;
    }

    public static final int getTabbedTextWidth(Segment segment, FontMetrics fontMetrics, int n, TabExpander tabExpander, int n2) {
        char[] cArray = segment.array;
        int n3 = n;
        int n4 = 0;
        block4: for (int i = segment.offset; i < segment.offset + segment.count; ++i) {
            switch (cArray[i]) {
                case '\t': {
                    if (tabExpander != null) {
                        n3 = (int)tabExpander.nextTabStop(n3, n2 + i - segment.offset);
                        continue block4;
                    }
                    n3 += fontMetrics.charWidth(' ');
                    continue block4;
                }
                case '\n': {
                    n4 = Math.max(n4, (n3 += fontMetrics.charWidth(cArray[i])) - n);
                    n3 = n;
                    continue block4;
                }
                default: {
                    n3 += fontMetrics.charWidth(cArray[i]);
                }
            }
        }
        n4 = Math.max(n4, n3 - n);
        return n4;
    }

    public static final int getTabbedTextOffset(Segment segment, FontMetrics fontMetrics, int n, int n2, TabExpander tabExpander, int n3, boolean bl) {
        char c;
        int n4;
        int n5 = n;
        int n6 = 0;
        for (n4 = 0; n4 < segment.count && (c = segment.array[segment.offset + n4]) != '\u0000'; ++n4) {
            n6 = c != '\t' ? fontMetrics.charWidth(c) : (tabExpander == null ? fontMetrics.charWidth(' ') : (int)tabExpander.nextTabStop(n5, n4) - n5);
            if (bl ? n5 + (n6 >> 1) > n2 : n5 + n6 > n2) break;
            n5 += n6;
        }
        return n4 + n3;
    }

    public static final int getTabbedTextOffset(Segment segment, FontMetrics fontMetrics, int n, int n2, TabExpander tabExpander, int n3) {
        return Utilities.getTabbedTextOffset(segment, fontMetrics, n, n2, tabExpander, n3, true);
    }

    public static final int getNextWord(JTextComponent jTextComponent, int n) throws BadLocationException {
        if (n < 0 || n > jTextComponent.getText().length() - 1) {
            throw new BadLocationException("invalid offset specified", n);
        }
        String string = jTextComponent.getText();
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        int n2 = breakIterator.following(n);
        int n3 = breakIterator.next();
        while (n3 != -1) {
            for (int i = n2; i < n3; ++i) {
                int n4 = string.codePointAt(i);
                if (!Character.isLetter(n4) && Character.isWhitespace(n4)) continue;
                return n2;
            }
            n2 = n3;
            n3 = breakIterator.next();
        }
        throw new BadLocationException("no more words", n);
    }

    public static final int getPreviousWord(JTextComponent jTextComponent, int n) throws BadLocationException {
        String string = jTextComponent.getText();
        if (n <= 0 || n > string.length()) {
            throw new BadLocationException("invalid offset specified", n);
        }
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        int n2 = breakIterator.preceding(n);
        int n3 = breakIterator.previous();
        while (n3 != -1) {
            for (int i = n2; i < n; ++i) {
                int n4 = string.codePointAt(i);
                if (!Character.isLetter(n4) && Character.isWhitespace(n4)) continue;
                return n2;
            }
            n2 = n3;
            n3 = breakIterator.previous();
        }
        return 0;
    }

    public static final int getWordStart(JTextComponent jTextComponent, int n) throws BadLocationException {
        String string = jTextComponent.getText();
        if (n < 0 || n > string.length()) {
            throw new BadLocationException("invalid offset specified", n);
        }
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        if (breakIterator.isBoundary(n)) {
            return n;
        }
        return breakIterator.preceding(n);
    }

    public static final int getWordEnd(JTextComponent jTextComponent, int n) throws BadLocationException {
        if (n < 0 || n >= jTextComponent.getText().length()) {
            throw new BadLocationException("invalid offset specified", n);
        }
        String string = jTextComponent.getText();
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        return breakIterator.following(n);
    }

    public static final int getRowEnd(JTextComponent jTextComponent, int n) throws BadLocationException {
        String string = jTextComponent.getText();
        if (string == null) {
            return -1;
        }
        int n2 = n + (string.length() - 1 - n) / 2;
        int n3 = n;
        int n4 = string.length() + 1;
        while (true) {
            if (jTextComponent.modelToView((int)n2).y != jTextComponent.modelToView((int)n).y) {
                n4 = n2;
                if (n4 != (n2 = n3 + (n2 + 1 - n3) / 2)) continue;
                return n2 - 1;
            }
            n3 = n2;
            if (n3 == (n2 += (n4 - n2) / 2)) break;
        }
        return n3;
    }

    public static final int getRowStart(JTextComponent jTextComponent, int n) throws BadLocationException {
        String string = jTextComponent.getText();
        if (string == null) {
            return -1;
        }
        int n2 = n;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            if (jTextComponent.modelToView((int)n3).y != jTextComponent.modelToView((int)n).y) {
                n4 = n3;
                if (n4 != (n3 = n2 - (n2 + 1 - n3) / 2)) continue;
                return n3 + 1;
            }
            if ((n3 -= (n3 - n4) / 2) == (n2 = n3)) break;
        }
        return n3;
    }

    public static final int getBreakLocation(Segment segment, FontMetrics fontMetrics, int n, int n2, TabExpander tabExpander, int n3) {
        int n4 = Utilities.getTabbedTextOffset(segment, fontMetrics, n, n2, tabExpander, n3, false);
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(segment);
        int n5 = n3 - segment.offset;
        if (n4 >= n5 + segment.count) {
            return n4;
        }
        int n6 = breakIterator.preceding(n4 + 1 - n5);
        if (n6 != 0) {
            return n6 + n5;
        }
        return n4;
    }

    public static final Element getParagraphElement(JTextComponent jTextComponent, int n) {
        Document document = jTextComponent.getDocument();
        Element element = null;
        if (document instanceof StyledDocument) {
            StyledDocument styledDocument = (StyledDocument)document;
            element = styledDocument.getParagraphElement(n);
        } else {
            Element element2 = jTextComponent.getDocument().getDefaultRootElement();
            int n2 = element2.getElementIndex(n);
            element = element2.getElement(n2);
        }
        return element;
    }

    public static final int getPositionAbove(JTextComponent jTextComponent, int n, int n2) throws BadLocationException {
        int n3 = Utilities.getRowStart(jTextComponent, n);
        if (n3 == -1) {
            return -1;
        }
        Point point = jTextComponent.modelToView(n3 - 1).getLocation();
        point.x = n2;
        n3 = jTextComponent.viewToModel(point);
        int n4 = jTextComponent.modelToView((int)n3).getLocation().x;
        int n5 = jTextComponent.modelToView((int)(n3 + 1)).getLocation().x;
        if (Math.abs(n4 - n2) <= Math.abs(n5 - n2)) {
            return n3;
        }
        return n3 + 1;
    }

    public static final int getPositionBelow(JTextComponent jTextComponent, int n, int n2) throws BadLocationException {
        int n3 = Utilities.getRowEnd(jTextComponent, n);
        if (n3 == -1) {
            return -1;
        }
        Point point = null;
        try {
            point = jTextComponent.modelToView(n3 + 1).getLocation();
        }
        catch (BadLocationException badLocationException) {
            return n;
        }
        point.x = n2;
        n3 = jTextComponent.viewToModel(point);
        if (n3 == jTextComponent.getDocument().getLength()) {
            return n3;
        }
        int n4 = jTextComponent.modelToView((int)n3).getLocation().x;
        int n5 = jTextComponent.modelToView((int)(n3 + 1)).getLocation().x;
        if (Math.abs(n4 - n2) <= Math.abs(n5 - n2)) {
            return n3;
        }
        return n3 + 1;
    }

    static int getNextVisualPositionFrom(JTextComponent jTextComponent, int n, int n2) {
        NavigationFilter navigationFilter = jTextComponent.getNavigationFilter();
        try {
            if (navigationFilter != null) {
                return navigationFilter.getNextVisualPositionFrom(jTextComponent, n, Position.Bias.Forward, n2, null);
            }
            return jTextComponent.getUI().getNextVisualPositionFrom(jTextComponent, n, Position.Bias.Forward, n2, null);
        }
        catch (BadLocationException badLocationException) {
            return n;
        }
    }
}

