/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.util.ArrayList;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.SimpleAttributeSet;

public class PlainDocument
extends AbstractDocument {
    private static final long serialVersionUID = 4758290289196893664L;
    public static final String lineLimitAttribute = "lineLimit";
    public static final String tabSizeAttribute = "tabSize";
    private Element rootElement = this.createDefaultRoot();

    public PlainDocument() {
        this(new GapContent());
    }

    public PlainDocument(AbstractDocument.Content content) {
        super(content);
        this.putProperty(tabSizeAttribute, new Integer(8));
    }

    private void reindex() {
        Element[] elementArray;
        try {
            String string = this.content.getString(0, this.content.length());
            ArrayList arrayList = new ArrayList();
            int n = 0;
            int n2 = string.indexOf(10, 0);
            while (n2 != -1) {
                arrayList.add(this.createLeafElement(this.rootElement, SimpleAttributeSet.EMPTY, n, n2 + 1));
                n = n2 + 1;
                n2 = string.indexOf(10, n2 + 1);
            }
            if (n < this.content.length()) {
                arrayList.add(this.createLeafElement(this.rootElement, SimpleAttributeSet.EMPTY, n, this.content.length()));
            }
            elementArray = new Element[arrayList.size()];
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                elementArray[n2] = (Element)arrayList.get(n2);
            }
        }
        catch (BadLocationException badLocationException) {
            elementArray = new Element[]{this.createLeafElement(this.rootElement, SimpleAttributeSet.EMPTY, 0, 1)};
        }
        ((AbstractDocument.BranchElement)this.rootElement).replace(0, this.rootElement.getElementCount(), elementArray);
    }

    protected AbstractDocument.AbstractElement createDefaultRoot() {
        AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)this.createBranchElement(null, null);
        Element[] elementArray = new Element[]{this.createLeafElement(branchElement, null, 0, 1)};
        branchElement.replace(0, 0, elementArray);
        return branchElement;
    }

    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet) {
        Object object;
        String string = null;
        int n = defaultDocumentEvent.getOffset();
        int n2 = defaultDocumentEvent.getLength();
        try {
            string = this.getText(n, n2);
        }
        catch (BadLocationException badLocationException) {
            AssertionError assertionError = new AssertionError();
            ((Throwable)((Object)assertionError)).initCause(badLocationException);
            throw assertionError;
        }
        boolean bl = string.indexOf(10) != -1;
        boolean bl2 = false;
        try {
            bl2 = n > 0 && this.getText(n - 1, 1).charAt(0) == '\n';
        }
        catch (BadLocationException badLocationException) {
            AssertionError assertionError = new AssertionError();
            ((Throwable)((Object)assertionError)).initCause(badLocationException);
            throw assertionError;
        }
        boolean bl3 = string.charAt(string.length() - 1) == '\n';
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        Element[] elementArray = null;
        AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)this.rootElement;
        boolean bl4 = true;
        if (bl2 && !bl3) {
            n3 = branchElement.getElementIndex(n - 1);
            object = branchElement.getElement(n3);
            Element element = branchElement.getElement(n3 + 1);
            n4 = object.getStartOffset();
            n5 = element.getEndOffset();
            elementArray = new Element[]{object, element};
        } else if (bl) {
            n3 = branchElement.getElementIndex(n);
            object = branchElement.getElement(n3);
            n4 = object.getStartOffset();
            n5 = object.getEndOffset();
            elementArray = new Element[]{object};
        } else {
            bl4 = false;
        }
        if (bl4) {
            object = new ArrayList();
            int n6 = n5 - n4;
            try {
                string = this.getText(n4, n6);
            }
            catch (BadLocationException badLocationException) {
                AssertionError assertionError = new AssertionError();
                ((Throwable)((Object)assertionError)).initCause(badLocationException);
                throw assertionError;
            }
            int n7 = 0;
            int n8 = string.indexOf(10);
            do {
                ((ArrayList)object).add(this.createLeafElement(branchElement, null, n4 + n7, n4 + ++n8));
                n7 = n8;
                n8 = string.indexOf(10, n7);
            } while (n7 < n6);
            Element[] elementArray2 = (Element[])((ArrayList)object).toArray(new Element[((ArrayList)object).size()]);
            defaultDocumentEvent.addEdit(new AbstractDocument.ElementEdit(branchElement, n3, elementArray, elementArray2));
            branchElement.replace(n3, elementArray.length, elementArray2);
        }
        super.insertUpdate(defaultDocumentEvent, attributeSet);
    }

    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
        super.removeUpdate(defaultDocumentEvent);
        Element[] elementArray = new Element[1];
        int n = defaultDocumentEvent.getOffset();
        int n2 = this.rootElement.getElementIndex(n);
        int n3 = this.rootElement.getElementIndex(n + defaultDocumentEvent.getLength());
        if (n2 != n3) {
            int n4;
            Element[] elementArray2 = new Element[n3 - n2 + 1];
            for (n4 = n2; n4 <= n3; ++n4) {
                elementArray2[n4 - n2] = this.rootElement.getElement(n4);
            }
            n4 = this.rootElement.getElement(n2).getStartOffset();
            int n5 = this.rootElement.getElement(n3).getEndOffset();
            elementArray[0] = this.createLeafElement(this.rootElement, SimpleAttributeSet.EMPTY, n4, n5);
            AbstractDocument.ElementEdit elementEdit = new AbstractDocument.ElementEdit(this.rootElement, n2, elementArray2, elementArray);
            defaultDocumentEvent.addEdit(elementEdit);
            ((AbstractDocument.BranchElement)this.rootElement).replace(n2, n3 - n2 + 1, elementArray);
        }
    }

    public Element getDefaultRootElement() {
        return this.rootElement;
    }

    public Element getParagraphElement(int n) {
        Element element = this.getDefaultRootElement();
        return element.getElement(element.getElementIndex(n));
    }

    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        String string2 = string;
        if (string != null && Boolean.TRUE.equals(this.getProperty("filterNewlines"))) {
            string2 = string.replaceAll("\n", " ");
        }
        super.insertString(n, string2, attributeSet);
    }
}

