/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.event;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.EventListener;

public class EventListenerList
implements Serializable {
    static final long serialVersionUID = -5677132037850737084L;
    private static final Object[] NO_LISTENERS = new Object[0];
    protected transient Object[] listenerList;

    private /* synthetic */ void finit$() {
        this.listenerList = NO_LISTENERS;
    }

    public EventListenerList() {
        this.finit$();
    }

    public void add(Class clazz, EventListener eventListener) {
        if (eventListener == null) {
            return;
        }
        if (!clazz.isInstance(eventListener)) {
            throw new IllegalArgumentException();
        }
        int n = this.listenerList.length;
        Object[] objectArray = new Object[n + 2];
        if (n > 0) {
            System.arraycopy(this.listenerList, 0, objectArray, 0, n);
        }
        objectArray[n] = clazz;
        objectArray[n + 1] = eventListener;
        this.listenerList = objectArray;
    }

    public int getListenerCount() {
        return this.listenerList.length / 2;
    }

    public int getListenerCount(Class clazz) {
        int n = 0;
        for (int i = 0; i < this.listenerList.length; i += 2) {
            if (clazz != this.listenerList[i]) continue;
            ++n;
        }
        return n;
    }

    public Object[] getListenerList() {
        return this.listenerList;
    }

    public EventListener[] getListeners(Class clazz) {
        int n = this.getListenerCount(clazz);
        EventListener[] eventListenerArray = (EventListener[])Array.newInstance(clazz, n);
        int n2 = 0;
        for (int i = this.listenerList.length - 2; i >= 0; i -= 2) {
            if (this.listenerList[i] != clazz) continue;
            eventListenerArray[n2++] = (EventListener)this.listenerList[i + 1];
        }
        return eventListenerArray;
    }

    public void remove(Class clazz, EventListener eventListener) {
        if (eventListener == null) {
            return;
        }
        if (!clazz.isInstance(eventListener)) {
            throw new IllegalArgumentException();
        }
        Object[] objectArray = this.listenerList;
        int n = objectArray.length;
        for (int i = 0; i < n; i += 2) {
            Object[] objectArray2;
            if (objectArray[i] != clazz || objectArray[i + 1] != eventListener) continue;
            if (n == 2) {
                objectArray2 = NO_LISTENERS;
            } else {
                objectArray2 = new Object[n - 2];
                if (i > 0) {
                    System.arraycopy(objectArray, 0, objectArray2, 0, i);
                }
                if (i < n - 2) {
                    System.arraycopy(objectArray, i + 2, objectArray2, i, n - 2 - i);
                }
            }
            this.listenerList = objectArray2;
            return;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("EventListenerList: ");
        stringBuffer.append(this.listenerList.length / 2);
        stringBuffer.append(" listeners: ");
        for (int i = 0; i < this.listenerList.length; i += 2) {
            stringBuffer.append(" type ");
            stringBuffer.append(((Class)this.listenerList[i]).getName());
            stringBuffer.append(" listener ");
            stringBuffer.append(this.listenerList[i + 1]);
        }
        return stringBuffer.toString();
    }
}

