/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Spring;

public class SpringLayout
implements LayoutManager2 {
    public static final String EAST = "East";
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String WEST = "West";
    private Map constraintsMap = new HashMap();

    public void addLayoutComponent(Component component, Object object) {
        this.constraintsMap.put(component, object);
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public Spring getConstraint(String string, Component component) {
        return new DeferredSpring(this, string, component);
    }

    public Constraints getConstraints(Component component) {
        Constraints constraints = (Constraints)this.constraintsMap.get(component);
        if (constraints == null) {
            constraints = new Constraints();
            constraints.setWidth(new DeferredWidth(component));
            constraints.setHeight(new DeferredHeight(component));
            constraints.setX(Spring.constant(0));
            constraints.setY(Spring.constant(0));
            this.constraintsMap.put(component, constraints);
        }
        return constraints;
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    public void invalidateLayout(Container container) {
    }

    private Constraints initContainer(Container container) {
        Constraints constraints = this.getConstraints(container);
        constraints.setX(Spring.constant(0));
        constraints.setY(Spring.constant(0));
        constraints.setWidth(null);
        constraints.setHeight(null);
        if (constraints.getEast() == null) {
            constraints.setEast(Spring.constant(0, 0, Integer.MAX_VALUE));
        }
        if (constraints.getSouth() == null) {
            constraints.setSouth(Spring.constant(0, 0, Integer.MAX_VALUE));
        }
        return constraints;
    }

    public void layoutContainer(Container container) {
        int n;
        Insets insets = container.getInsets();
        Component[] componentArray = container.getComponents();
        Constraints constraints = this.initContainer(container);
        constraints.dropCalcResult();
        for (n = 0; n < componentArray.length; ++n) {
            Component component = componentArray[n];
            this.getConstraints(component).dropCalcResult();
        }
        n = container.getInsets().left;
        int n2 = container.getInsets().right;
        constraints.getX().setValue(0);
        constraints.getY().setValue(0);
        constraints.getWidth().setValue(container.getWidth() - n - insets.right);
        constraints.getHeight().setValue(container.getHeight() - n2 - insets.bottom);
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            Constraints constraints2 = this.getConstraints(component);
            int n3 = constraints2.getX().getValue();
            int n4 = constraints2.getY().getValue();
            int n5 = constraints2.getWidth().getValue();
            int n6 = constraints2.getHeight().getValue();
            component.setBounds(n3 + n, n4 + n2, n5, n6);
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        Insets insets = container.getInsets();
        Constraints constraints = this.initContainer(container);
        int n = constraints.getWidth().getMaximumValue() + insets.left + insets.right;
        int n2 = constraints.getHeight().getMaximumValue() + insets.top + insets.bottom;
        return new Dimension(n, n2);
    }

    public Dimension minimumLayoutSize(Container container) {
        Insets insets = container.getInsets();
        Constraints constraints = this.initContainer(container);
        int n = constraints.getWidth().getMinimumValue() + insets.left + insets.right;
        int n2 = constraints.getHeight().getMinimumValue() + insets.top + insets.bottom;
        return new Dimension(n, n2);
    }

    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        Constraints constraints = this.initContainer(container);
        int n = constraints.getWidth().getPreferredValue() + insets.left + insets.right;
        int n2 = constraints.getHeight().getPreferredValue() + insets.top + insets.bottom;
        return new Dimension(n, n2);
    }

    public void putConstraint(String string, Component component, int n, String string2, Component component2) {
        this.putConstraint(string, component, Spring.constant(n), string2, component2);
    }

    public void putConstraint(String string, Component component, Spring spring, String string2, Component component2) {
        Constraints constraints = this.getConstraints(component);
        Spring spring2 = this.getConstraint(string2, component2);
        constraints.setConstraint(string, Spring.sum(spring, spring2));
    }

    public void removeLayoutComponent(Component component) {
    }

    private static class DeferredHeight
    extends DeferredDimension {
        private Component c;

        public String toString() {
            return "DeferredHeight of something";
        }

        public DeferredHeight(Component component) {
            this.c = component;
        }

        public int getMaximumValue() {
            int n = this.c.getMaximumSize().height;
            return Math.min(Short.MAX_VALUE, n);
        }

        public int getMinimumValue() {
            return this.c.getMinimumSize().height;
        }

        public int getPreferredValue() {
            return this.c.getPreferredSize().height;
        }
    }

    private static class DeferredWidth
    extends DeferredDimension {
        private Component c;

        public DeferredWidth(Component component) {
            this.c = component;
        }

        public String toString() {
            return "DeferredWidth of something";
        }

        public int getMaximumValue() {
            int n = this.c.getMaximumSize().width;
            return Math.min(Short.MAX_VALUE, n);
        }

        public int getMinimumValue() {
            return this.c.getMinimumSize().width;
        }

        public int getPreferredValue() {
            return this.c.getPreferredSize().width;
        }
    }

    private static abstract class DeferredDimension
    extends Spring {
        private int value = Integer.MIN_VALUE;

        public void setValue(int n) {
            this.value = n;
        }

        public int getValue() {
            if (this.value == Integer.MIN_VALUE) {
                return this.getPreferredValue();
            }
            return this.value;
        }
    }

    private static class DeferredSpring
    extends Spring {
        private SpringLayout sl;
        private String edgeName;
        private Component c;

        public String toString() {
            return "DeferredSpring of edge" + this.edgeName + " of " + "something";
        }

        public DeferredSpring(SpringLayout springLayout, String string, Component component) {
            this.sl = springLayout;
            this.edgeName = string;
            this.c = component;
        }

        private Spring resolveSpring() {
            return this.sl.getConstraints(this.c).getConstraint(this.edgeName);
        }

        public int getMaximumValue() {
            return this.resolveSpring().getMaximumValue();
        }

        public int getMinimumValue() {
            return this.resolveSpring().getMinimumValue();
        }

        public int getPreferredValue() {
            return this.resolveSpring().getPreferredValue();
        }

        public int getValue() {
            int n = this.resolveSpring().getValue();
            if (n == Integer.MIN_VALUE) {
                n = this.getPreferredValue();
            }
            return n;
        }

        public void setValue(int n) {
            this.resolveSpring().setValue(n);
        }
    }

    public static class Constraints {
        private Spring x;
        private Spring y;
        private Spring height;
        private Spring width;
        private Spring east;
        private Spring south;
        private Spring v;
        private Spring h;

        public Constraints() {
            this.h = null;
            this.v = null;
            this.south = null;
            this.east = null;
            this.width = null;
            this.height = null;
            this.y = null;
            this.x = null;
        }

        public Constraints(Spring spring, Spring spring2) {
            this.x = spring;
            this.y = spring2;
            this.h = null;
            this.v = null;
            this.south = null;
            this.east = null;
            this.height = null;
            this.width = null;
        }

        public Constraints(Spring spring, Spring spring2, Spring spring3, Spring spring4) {
            this.x = spring;
            this.y = spring2;
            this.width = spring3;
            this.height = spring4;
            this.h = null;
            this.v = null;
            this.south = null;
            this.east = null;
        }

        public Constraints(Component component) {
            this(Spring.constant(component.getX()), Spring.constant(component.getY()), Spring.width(component), Spring.height(component));
        }

        public Spring getConstraint(String string) {
            Spring spring = null;
            if (string.equals(SpringLayout.NORTH)) {
                spring = this.getY();
            } else if (string.equals(SpringLayout.WEST)) {
                spring = this.getX();
            } else if (string.equals(SpringLayout.SOUTH)) {
                spring = this.getSouth();
            } else if (string.equals(SpringLayout.EAST)) {
                spring = this.getEast();
            }
            return spring;
        }

        public Spring getHeight() {
            if (this.height != null) {
                return this.height;
            }
            if (this.v == null && this.y != null && this.south != null) {
                this.v = Spring.sum(this.south, Spring.minus(this.y));
            }
            return this.v;
        }

        public Spring getWidth() {
            if (this.width != null) {
                return this.width;
            }
            if (this.h == null && this.x != null && this.east != null) {
                this.h = Spring.sum(this.east, Spring.minus(this.x));
            }
            return this.h;
        }

        public Spring getX() {
            if (this.x != null) {
                return this.x;
            }
            if (this.h == null && this.width != null && this.east != null) {
                this.h = Spring.sum(this.east, Spring.minus(this.width));
            }
            return this.h;
        }

        public Spring getY() {
            if (this.y != null) {
                return this.y;
            }
            if (this.v == null && this.height != null && this.south != null) {
                this.v = Spring.sum(this.south, Spring.minus(this.height));
            }
            return this.v;
        }

        public Spring getSouth() {
            if (this.south != null) {
                return this.south;
            }
            if (this.v == null && this.height != null && this.y != null) {
                this.v = Spring.sum(this.y, this.height);
            }
            return this.v;
        }

        public Spring getEast() {
            if (this.east != null) {
                return this.east;
            }
            if (this.h == null && this.width != null && this.x != null) {
                this.h = Spring.sum(this.x, this.width);
            }
            return this.h;
        }

        public void setConstraint(String string, Spring spring) {
            if (string.equals(SpringLayout.WEST)) {
                this.setX(spring);
            } else if (string.equals(SpringLayout.NORTH)) {
                this.setY(spring);
            } else if (string.equals(SpringLayout.EAST)) {
                this.setEast(spring);
            } else if (string.equals(SpringLayout.SOUTH)) {
                this.setSouth(spring);
            }
        }

        public void setHeight(Spring spring) {
            this.height = spring;
            this.v = null;
            if (this.south != null && this.y != null && this.height != null) {
                this.south = null;
            }
        }

        public void setWidth(Spring spring) {
            this.width = spring;
            this.h = null;
            if (this.east != null && this.x != null && this.width != null) {
                this.east = null;
            }
        }

        public void setX(Spring spring) {
            this.x = spring;
            this.h = null;
            if (this.width != null && this.east != null && this.x != null) {
                this.width = null;
            }
        }

        public void setY(Spring spring) {
            this.y = spring;
            this.v = null;
            if (this.height != null && this.south != null && this.y != null) {
                this.height = null;
            }
        }

        public void setSouth(Spring spring) {
            this.south = spring;
            this.v = null;
            if (this.height != null && this.south != null && this.y != null) {
                this.y = null;
            }
        }

        public void setEast(Spring spring) {
            this.east = spring;
            this.h = null;
            if (this.width != null && this.east != null && this.x != null) {
                this.x = null;
            }
        }

        public void dropCalcResult() {
            if (this.x != null) {
                this.x.setValue(Integer.MIN_VALUE);
            }
            if (this.y != null) {
                this.y.setValue(Integer.MIN_VALUE);
            }
            if (this.width != null) {
                this.width.setValue(Integer.MIN_VALUE);
            }
            if (this.height != null) {
                this.height.setValue(Integer.MIN_VALUE);
            }
            if (this.east != null) {
                this.east.setValue(Integer.MIN_VALUE);
            }
            if (this.south != null) {
                this.south.setValue(Integer.MIN_VALUE);
            }
            if (this.h != null) {
                this.h.setValue(Integer.MIN_VALUE);
            }
            if (this.v != null) {
                this.v.setValue(Integer.MIN_VALUE);
            }
        }
    }
}

