/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.der;

import gnu.java.security.OID;
import gnu.java.security.der.BitString;
import gnu.java.security.der.DER;
import gnu.java.security.der.DEREncodingException;
import gnu.java.security.der.DERValue;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DERReader
implements DER {
    protected InputStream in;
    protected final ByteArrayOutputStream encBuf;

    public DERReader(byte[] byArray) {
        this(new ByteArrayInputStream(byArray));
    }

    public DERReader(byte[] byArray, int n, int n2) {
        this(new ByteArrayInputStream(byArray, n, n2));
    }

    public DERReader(InputStream inputStream) {
        this.in = !inputStream.markSupported() ? new BufferedInputStream(inputStream, 16384) : inputStream;
        this.encBuf = new ByteArrayOutputStream(2048);
    }

    public static DERValue read(byte[] byArray) throws IOException {
        return new DERReader(byArray).read();
    }

    public void skip(int n) throws IOException {
        this.in.skip(n);
    }

    public DERValue read() throws IOException {
        int n = this.in.read();
        if (n == -1) {
            throw new EOFException();
        }
        this.encBuf.write(n);
        int n2 = this.readLength();
        DERValue dERValue = null;
        if ((n & 0x20) == 32) {
            this.in.mark(2048);
            byte[] byArray = new byte[n2];
            this.in.read(byArray);
            this.encBuf.write(byArray);
            dERValue = new DERValue(n, n2, DER.CONSTRUCTED_VALUE, this.encBuf.toByteArray());
            this.in.reset();
            this.encBuf.reset();
            return dERValue;
        }
        switch (n & 0xC0) {
            case 0: {
                dERValue = new DERValue(n, n2, this.readUniversal(n, n2), this.encBuf.toByteArray());
                this.encBuf.reset();
                break;
            }
            case 128: {
                byte[] byArray = new byte[n2];
                this.in.read(byArray);
                this.encBuf.write(byArray);
                dERValue = new DERValue(n, n2, byArray, this.encBuf.toByteArray());
                this.encBuf.reset();
                break;
            }
            case 64: {
                throw new DEREncodingException("non-constructed APPLICATION data");
            }
            default: {
                throw new DEREncodingException("PRIVATE class not supported");
            }
        }
        return dERValue;
    }

    protected int readLength() throws IOException {
        int n = this.in.read();
        if (n == -1) {
            throw new EOFException();
        }
        this.encBuf.write(n);
        if ((n & 0xFFFFFF80) == 0) {
            return n;
        }
        if (n < 255) {
            byte[] byArray = new byte[n & 0x7F];
            this.in.read(byArray);
            this.encBuf.write(byArray);
            return new BigInteger(1, byArray).intValue();
        }
        throw new DEREncodingException();
    }

    private Object readUniversal(int n, int n2) throws IOException {
        byte[] byArray = new byte[n2];
        this.in.read(byArray);
        this.encBuf.write(byArray);
        switch (n & 0x1F) {
            case 1: {
                if (byArray.length != 1) {
                    throw new DEREncodingException();
                }
                return byArray[0] != 0;
            }
            case 5: {
                if (n2 != 0) {
                    throw new DEREncodingException();
                }
                return null;
            }
            case 2: 
            case 10: {
                return new BigInteger(byArray);
            }
            case 3: {
                byte[] byArray2 = new byte[n2 - 1];
                System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
                return new BitString(byArray2, byArray[0] & 0xFF);
            }
            case 4: {
                return byArray;
            }
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: {
                return DERReader.makeString(n, byArray);
            }
            case 23: 
            case 24: {
                return this.makeTime(n, byArray);
            }
            case 6: {
                return new OID(byArray);
            }
            case 13: {
                return new OID(byArray, true);
            }
        }
        throw new DEREncodingException("unknown tag " + n);
    }

    private static String makeString(int n, byte[] byArray) throws IOException {
        switch (n & 0x1F) {
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: {
                return DERReader.fromIso88591(byArray);
            }
            case 28: 
            case 30: {
                return DERReader.fromUtf16Be(byArray);
            }
            case 12: {
                return DERReader.fromUtf8(byArray);
            }
        }
        throw new DEREncodingException("unknown string tag");
    }

    private static String fromIso88591(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append((char)((char)byArray[i] & 0xFF));
        }
        return stringBuffer.toString();
    }

    private static String fromUtf16Be(byte[] byArray) throws IOException {
        if ((byArray.length & 1) != 0) {
            throw new IOException("UTF-16 bytes are odd in length");
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length / 2);
        for (int i = 0; i < byArray.length; i += 2) {
            char c = (char)(byArray[i] << 8) & 0xFF;
            c = (char)(c | (char)byArray[i + 1] & 0xFF);
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static String fromUtf8(byte[] byArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer((int)((double)byArray.length / 1.5));
        int n = 0;
        while (n < byArray.length) {
            char c = '\u0000';
            if ((byArray[n] & 0xE0) == 224) {
                if (n + 2 >= byArray.length) {
                    throw new IOException("short UTF-8 input");
                }
                c = (char)((byArray[n++] & 0xF) << 12);
                if ((byArray[n] & 0x80) != 128) {
                    throw new IOException("malformed UTF-8 input");
                }
                c = (char)(c | (char)((byArray[n++] & 0x3F) << 6));
                if ((byArray[n] & 0x80) != 128) {
                    throw new IOException("malformed UTF-8 input");
                }
                c = (char)(c | (char)byArray[n++] & 0x3F);
            } else if ((byArray[n] & 0xC0) == 192) {
                if (n + 1 >= byArray.length) {
                    throw new IOException("short input");
                }
                c = (char)((byArray[n++] & 0x1F) << 6);
                if ((byArray[n] & 0x80) != 128) {
                    throw new IOException("malformed UTF-8 input");
                }
                c = (char)(c | (char)byArray[n++] & 0x3F);
            } else if ((byArray[n] & 0xFF) < 128) {
                c = (char)((char)byArray[n++] & 0xFF);
            } else {
                throw new IOException("badly formed UTF-8 sequence");
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Date makeTime(int n, byte[] byArray) throws IOException {
        String string;
        Calendar calendar = Calendar.getInstance();
        String string2 = string = DERReader.makeString(19, byArray);
        String string3 = "";
        if (string.indexOf("+") > 0) {
            string2 = string.substring(0, string.indexOf("+"));
            string3 = string.substring(string.indexOf("+"));
        } else if (string.indexOf("-") > 0) {
            string2 = string.substring(0, string.indexOf("-"));
            string3 = string.substring(string.indexOf("-"));
        } else if (string.endsWith("Z")) {
            string2 = string.substring(0, string.length() - 2);
            string3 = "Z";
        }
        if (!string3.equals("Z") && string3.length() > 0) {
            calendar.setTimeZone(TimeZone.getTimeZone(string3));
        } else {
            calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        if ((n & 0x1F) == 23) {
            if (string2.length() < 10) {
                throw new DEREncodingException("cannot parse date");
            }
            try {
                int n2 = Integer.parseInt(string.substring(0, 2));
                n2 = n2 < 50 ? (n2 += 2000) : (n2 += 1900);
                calendar.set(n2, Integer.parseInt(string.substring(2, 4)) - 1, Integer.parseInt(string.substring(4, 6)), Integer.parseInt(string.substring(6, 8)), Integer.parseInt(string.substring(8, 10)));
                if (string2.length() != 12) return calendar.getTime();
                calendar.set(13, Integer.parseInt(string.substring(10, 12)));
                return calendar.getTime();
            }
            catch (NumberFormatException numberFormatException) {
                throw new DEREncodingException("cannot parse date");
            }
        }
        if (string2.length() < 10) {
            throw new DEREncodingException("cannot parse date");
        }
        try {
            calendar.set(Integer.parseInt(string2.substring(0, 4)), Integer.parseInt(string2.substring(4, 6)) - 1, Integer.parseInt(string2.substring(6, 8)), Integer.parseInt(string2.substring(8, 10)), 0);
            switch (string2.length()) {
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    calendar.set(14, Integer.parseInt(string2.substring(15)));
                }
                case 14: {
                    calendar.set(13, Integer.parseInt(string2.substring(12, 14)));
                }
                case 12: {
                    calendar.set(12, Integer.parseInt(string2.substring(10, 12)));
                }
            }
            return calendar.getTime();
        }
        catch (NumberFormatException numberFormatException) {
            throw new DEREncodingException("cannot parse date");
        }
    }
}

