/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.properties.tabbed.view;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyList;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyTitle;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class TabbedPropertyComposite
extends Composite {
    private TabbedPropertySheetWidgetFactory factory;
    private Composite mainComposite;
    private Composite leftComposite;
    private ScrolledComposite scrolledComposite;
    private Composite tabComposite;
    private TabbedPropertyTitle title;
    private TabbedPropertyList listComposite;
    private boolean gainedFocus;
    private boolean displayTitle;

    public TabbedPropertyComposite(Composite parent, TabbedPropertySheetWidgetFactory factory, boolean displayTitle) {
        super(parent, 524288);
        this.factory = factory;
        this.displayTitle = displayTitle;
        this.createMainComposite();
    }

    protected void createMainComposite() {
        this.mainComposite = this.factory.createComposite(this, 524288);
        this.mainComposite.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.mainComposite.setLayoutData((Object)formData);
        this.createMainContents();
        this.mainComposite.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                TabbedPropertyComposite.this.gainedFocus = true;
                TabbedPropertyComposite.this.mainComposite.redraw();
            }

            public void focusLost(FocusEvent e) {
                TabbedPropertyComposite.this.gainedFocus = false;
                TabbedPropertyComposite.this.mainComposite.redraw();
            }
        });
        this.mainComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (TabbedPropertyComposite.this.gainedFocus) {
                    Rectangle r = TabbedPropertyComposite.this.getClientArea();
                    e.gc.drawFocus(0, 0, r.width, r.height);
                }
            }
        });
    }

    protected void createMainContents() {
        FormData data;
        this.leftComposite = this.factory.createComposite(this.mainComposite, 524288);
        this.leftComposite.setLayout((Layout)new FormLayout());
        this.scrolledComposite = this.factory.createScrolledComposite(this.mainComposite, 525056);
        this.scrolledComposite.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.left = new FormAttachment((Control)this.leftComposite, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.scrolledComposite.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment((Control)this.scrolledComposite, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.leftComposite.setLayoutData((Object)formData);
        Composite rightComposite = this.factory.createComposite((Composite)this.scrolledComposite, 524288);
        rightComposite.setLayout((Layout)new FormLayout());
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 0;
        formLayout.marginWidth = 0;
        rightComposite.setLayout((Layout)formLayout);
        this.scrolledComposite.setContent((Control)rightComposite);
        this.scrolledComposite.setAlwaysShowScrollBars(false);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setExpandHorizontal(true);
        this.listComposite = new TabbedPropertyList(this.leftComposite, this.factory);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.listComposite.setLayoutData(formData);
        if (this.displayTitle) {
            this.title = new TabbedPropertyTitle(rightComposite, this.factory);
        }
        this.tabComposite = this.factory.createComposite(rightComposite, 524288);
        this.tabComposite.setLayout((Layout)new FormLayout());
        if (this.displayTitle) {
            data = new FormData();
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment(100, 0);
            data.top = new FormAttachment(0, 0);
            this.title.setLayoutData(data);
        }
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = this.displayTitle ? new FormAttachment((Control)this.title, 0) : new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        this.tabComposite.setLayoutData((Object)data);
        this.listComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Point leftSize = TabbedPropertyComposite.this.leftComposite.computeSize(-1, -1);
                FormData formData2 = new FormData();
                formData2.left = new FormAttachment(0, leftSize.x);
                formData2.right = new FormAttachment(100, 0);
                formData2.top = new FormAttachment(0, 0);
                formData2.bottom = new FormAttachment(100, 0);
                TabbedPropertyComposite.this.scrolledComposite.setLayoutData((Object)formData2);
                TabbedPropertyComposite.this.mainComposite.layout(true);
            }
        });
    }

    public TabbedPropertyList getList() {
        return this.listComposite;
    }

    public TabbedPropertyTitle getTitle() {
        return this.title;
    }

    public Composite getTabComposite() {
        return this.tabComposite;
    }

    public ScrolledComposite getScrolledComposite() {
        return this.scrolledComposite;
    }

    protected TabbedPropertySheetWidgetFactory getFactory() {
        return this.factory;
    }

    public void dispose() {
        this.listComposite.dispose();
        if (this.displayTitle) {
            this.title.dispose();
        }
        super.dispose();
    }
}

