/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.ui.provisional.editors;

import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.wst.common.ui.provisional.editors.PostMultiPageSelectionProvider;

public class PostMultiPageEditorSite
extends MultiPageEditorSite {
    private ISelectionChangedListener postSelectionChangedListener = null;

    public PostMultiPageEditorSite(MultiPageEditorPart multiPageEditor, IEditorPart editor) {
        super(multiPageEditor, editor);
    }

    private ISelectionChangedListener getPostSelectionChangedListener() {
        if (this.postSelectionChangedListener == null) {
            this.postSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    PostMultiPageEditorSite.this.handlePostSelectionChanged(event);
                }
            };
        }
        return this.postSelectionChangedListener;
    }

    protected void handlePostSelectionChanged(SelectionChangedEvent event) {
        ISelectionProvider parentProvider = this.getMultiPageEditor().getSite().getSelectionProvider();
        if (parentProvider instanceof PostMultiPageSelectionProvider) {
            SelectionChangedEvent newEvent = new SelectionChangedEvent(parentProvider, event.getSelection());
            ((PostMultiPageSelectionProvider)parentProvider).firePostSelectionChanged(newEvent);
        }
    }

    public void setSelectionProvider(ISelectionProvider provider) {
        ISelectionProvider oldSelectionProvider = this.getSelectionProvider();
        if (oldSelectionProvider != null && oldSelectionProvider instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)oldSelectionProvider).removePostSelectionChangedListener(this.getPostSelectionChangedListener());
        }
        super.setSelectionProvider(provider);
        if (provider != null && provider instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)provider).addPostSelectionChangedListener(this.getPostSelectionChangedListener());
        }
    }
}

