/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.GenericArchiveTypeDiscriminator;

public class ArchiveTypeDiscriminatorRegistry {
    private Collection discriminators = null;
    private Collection customTypes = null;
    private static final String[] defaultKnownTypes = new String[]{"ear", "war", "jar", "zip", "far"};
    public static final ArchiveTypeDiscriminatorRegistry INSTANCE = new ArchiveTypeDiscriminatorRegistry();

    public static void registorDiscriminator(GenericArchiveTypeDiscriminator discriminator) {
        INSTANCE.getDiscriminators().add(discriminator);
        INSTANCE.addKnownArchiveTypes(discriminator.getCustomFileExtensions());
    }

    public static ArchiveTypeDiscriminatorRegistry getInstance() {
        return INSTANCE;
    }

    public Collection getDiscriminators() {
        if (this.discriminators == null) {
            this.discriminators = new ArrayList();
        }
        return this.discriminators;
    }

    public void contributeTypes(Archive archive) {
        if (this.discriminators == null) {
            return;
        }
        GenericArchiveTypeDiscriminator discriminator = null;
        Iterator itr = this.discriminators.iterator();
        while (itr.hasNext()) {
            discriminator = (GenericArchiveTypeDiscriminator)itr.next();
            if (!discriminator.discriminate(archive)) continue;
            archive.getTypes().add((Object)discriminator.getTypeKey());
        }
    }

    public void addKnownArchiveTypes(String[] newTypes) {
        if (this.customTypes == null) {
            this.customTypes = new ArrayList();
        }
        int i = 0;
        while (i < newTypes.length) {
            this.customTypes.add(newTypes[i]);
            ++i;
        }
    }

    public boolean isKnownArchiveType(String fileURI) {
        if (fileURI == null || fileURI.length() == 0) {
            return false;
        }
        String lowerCaseUri = fileURI.toLowerCase();
        if (lowerCaseUri.length() > 4 && lowerCaseUri.charAt(lowerCaseUri.length() - 4) == '.') {
            String ending = lowerCaseUri.substring(lowerCaseUri.length() - 3);
            int i = 0;
            while (i < defaultKnownTypes.length) {
                if (defaultKnownTypes[i].equals(ending)) {
                    return true;
                }
                ++i;
            }
        }
        String customType = null;
        if (this.customTypes != null) {
            Iterator customTypesIterator = this.customTypes.iterator();
            while (customTypesIterator.hasNext()) {
                customType = (String)customTypesIterator.next();
                if (!fileURI.endsWith(customType)) continue;
                return true;
            }
        }
        return false;
    }
}

