/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.data.internal.ui;

import com.ibm.icu.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.rdb.data.internal.ui.editor.IExternalTableDataEditor;

class ExternalTableDataEditorExtension {
    protected IConfigurationElement element;
    protected String vendor;
    protected String version;
    protected String dataType;
    protected int length = -10;
    protected int score;
    protected boolean lengthProvided = false;

    public ExternalTableDataEditorExtension(IConfigurationElement element) {
        this.element = element;
        this.vendor = element.getAttribute("vendor");
        this.version = element.getAttribute("version");
        this.dataType = element.getAttribute("dataType");
        String sLength = element.getAttribute("length");
        try {
            this.length = Integer.parseInt(sLength);
            this.lengthProvided = true;
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {}
        this.score = (this.vendor != null ? 1 : 0) + (this.version != null ? 1 : 0) + (this.dataType != null ? 1 : 0) + (this.length > 0 ? 1 : 0);
    }

    public boolean matches(String vendor, String version, String dataType, boolean lengthSupported, int length) {
        if (this.lengthProvided && !lengthSupported) {
            return false;
        }
        if (this.lengthProvided && this.length > length) {
            return false;
        }
        if (this.vendor != null && !this.contains(this.vendor, vendor)) {
            return false;
        }
        if (this.version != null && !this.contains(this.version, version)) {
            return false;
        }
        return this.dataType == null || this.contains(this.dataType, dataType);
    }

    protected boolean contains(String values, String value) {
        StringTokenizer st = new StringTokenizer(values, ",", false);
        while (st.hasMoreElements()) {
            String s = st.nextToken();
            if (!value.equals(s.trim())) continue;
            return true;
        }
        return false;
    }

    public IExternalTableDataEditor createInstance() throws CoreException {
        return (IExternalTableDataEditor)this.element.createExecutableExtension("class");
    }

    public int getScore() {
        return this.score;
    }
}

