/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.connection.internal.ui.util.resource;

import java.io.InputStream;
import java.util.ResourceBundle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.rdb.connection.internal.ui.RDBConnectionUIPlugin;

public class ResourceLoader {
    private static final RDBConnectionUIPlugin plugin = RDBConnectionUIPlugin.getDefault();
    private static final String RESOURCE_PATH = "org/eclipse/wst/rdb/connection/internal/ui/l10n/";
    private static final String IMAGE_PATH = "org/eclipse/wst/rdb/connection/internal/ui/icons/";
    private static final String UI_RESOURCES = "datatoolsConnectionUI";
    private static final String NO_RESOURCE_FOUND = "NO_RESOURCE_FOUND";
    private ResourceBundle bundle = ResourceBundle.getBundle("org/eclipse/wst/rdb/connection/internal/ui/l10n/datatoolsConnectionUI");
    public static final ResourceLoader INSTANCE = new ResourceLoader();

    private ResourceLoader() {
    }

    public Image queryImageFromRegistry(String imagePath) {
        imagePath = IMAGE_PATH + imagePath;
        Image image = null;
        image = plugin.getImageRegistry().get(imagePath);
        if (image == null) {
            image = this.queryImage(imagePath);
            plugin.getImageRegistry().put(imagePath, image);
        }
        return image;
    }

    private Image queryImage(String imagePath) {
        Image image = null;
        try {
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(imagePath);
            ImageData data = new ImageData(stream);
            ImageData mask = data.getTransparencyMask();
            image = new Image((Device)Display.getCurrent(), data, mask);
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return image;
    }

    public ResourceBundle getResourceBundle() {
        return this.bundle;
    }

    public String queryString(String stringID) {
        try {
            String resource = null;
            resource = this.bundle.getString(stringID);
            return resource;
        }
        catch (Throwable throwable) {
            return NO_RESOURCE_FOUND;
        }
    }
}

