/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.webservice;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jst.j2ee.internal.webservice.WebServiceUIResourceHandler;
import org.eclipse.jst.j2ee.internal.webservice.WebServicesNavigatorContentProvider;
import org.eclipse.jst.j2ee.internal.webservice.WebServicesNavigatorSynchronizer;
import org.eclipse.jst.j2ee.internal.webservice.helper.WebServiceEvent;
import org.eclipse.jst.j2ee.internal.webservice.helper.WebServiceManagerListener;
import org.eclipse.jst.j2ee.internal.webservice.helper.WebServicesManager;
import org.eclipse.jst.j2ee.internal.webservice.plugin.WebServiceUIPlugin;
import org.eclipse.jst.j2ee.navigator.internal.NonConflictingRule;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.common.internal.emfworkbench.integration.DynamicAdapterFactory;
import org.eclipse.wst.common.project.facet.core.internal.FacetedProjectPropertyTester;

public class WebServiceViewerSynchronization
implements WebServiceManagerListener {
    private WebServicesManager webServicesManager = null;
    private static final String PROJECT_FACET = "projectFacet";
    static final String EAR_FACET = "jst.ear";
    static final String APPCLIENT_FACET = "jst.appclient";
    static final String WEB_FACET = "jst.web";
    static final String EJB_FACET = "jst.ejb";
    static final String UTILITY_FACET = "jst.utility";
    static final String CONNECTOR_FACET = "jst.connector";
    static final String STATIC_WEB_FACET = "wst.web";
    private static final FacetedProjectPropertyTester facetPropertyTester = new FacetedProjectPropertyTester();
    private WebServicesNavigatorContentProvider contentProvider;
    private Job indexJob = new WebServiceIndexJob();
    private Job updateJob = new UpdateWebServicesNodeUIJob();
    private Job removeJob = new RemoveWebServicesNodeUIJob();
    private boolean navigatorGroupAdded = false;
    private boolean indexJobScheduled = false;
    private boolean initialized = false;

    public WebServiceViewerSynchronization(WebServicesNavigatorContentProvider provider) {
        this.contentProvider = provider;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        try {
            this.getWebServicesManager().addListener((WebServiceManagerListener)this);
            WebServicesNavigatorSynchronizer.createInstance((AdapterFactory)new DynamicAdapterFactory("org.eclipse.ui.navigator.ProjectExplorer"), this.contentProvider);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.initialized = true;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.initialized = true;
            return;
        }
    }

    public void stop() {
        if (this.initialized) {
            this.getWebServicesManager().removeListener((WebServiceManagerListener)this);
            WebServicesNavigatorSynchronizer.disposeInstance();
        }
    }

    public void webServiceManagerChanged(WebServiceEvent anEvent) {
        switch (anEvent.getEventType()) {
            case 1: {
                if (!this.hasNavigatorGroupBeenAdded()) {
                    if (!this.hasIndexJobBeenScheduled()) {
                        this.indexJob.schedule();
                    }
                    if (this.hasNavigatorGroupBeenAdded()) break;
                    new AddWebServicesNodeUIJob().schedule();
                    break;
                }
                this.updateJob.schedule();
                break;
            }
            case 0: {
                this.removeJob.schedule();
            }
        }
    }

    public void startIndexJob() {
        this.indexJob.schedule();
    }

    synchronized boolean hasIndexJobBeenScheduled() {
        if (!this.indexJobScheduled) {
            this.indexJobScheduled = true;
            return false;
        }
        return true;
    }

    synchronized boolean hasNavigatorGroupBeenAdded() {
        return this.navigatorGroupAdded;
    }

    synchronized void setNavigatorGroupAdded(boolean hasBeenAdded) {
        this.navigatorGroupAdded = hasBeenAdded;
    }

    private WebServicesManager getWebServicesManager() {
        if (this.webServicesManager == null) {
            this.webServicesManager = WebServicesManager.getInstance();
        }
        return this.webServicesManager;
    }

    private boolean indexWebServices(IProgressMonitor monitor) {
        boolean hasChildren = false;
        if (!monitor.isCanceled()) {
            try {
                hasChildren |= this.getWebServicesManager().getWorkspace13ServiceRefs().size() > 0;
            }
            catch (RuntimeException e) {
                WebServiceUIPlugin.logError(0, e.getMessage(), e);
            }
        } else {
            return hasChildren;
        }
        monitor.worked(1);
        if (!monitor.isCanceled()) {
            try {
                hasChildren |= this.getWebServicesManager().getWorkspace14ServiceRefs().size() > 0;
            }
            catch (RuntimeException e) {
                WebServiceUIPlugin.logError(0, e.getMessage(), e);
            }
        } else {
            return hasChildren;
        }
        monitor.worked(1);
        if (!monitor.isCanceled()) {
            try {
                hasChildren |= this.getWebServicesManager().getInternalWSDLServices().size() > 0;
            }
            catch (RuntimeException e) {
                WebServiceUIPlugin.logError(0, e.getMessage(), e);
            }
        } else {
            return hasChildren;
        }
        monitor.worked(1);
        if (!monitor.isCanceled()) {
            try {
                hasChildren |= this.getWebServicesManager().getExternalWSDLServices().size() > 0;
            }
            catch (RuntimeException e) {
                WebServiceUIPlugin.logError(0, e.getMessage(), e);
            }
        } else {
            return hasChildren;
        }
        monitor.worked(1);
        return hasChildren;
    }

    static boolean hasFacet(Object element, String facet) {
        return facetPropertyTester.test(element, PROJECT_FACET, new Object[0], (Object)facet);
    }

    boolean webServiceProjectsExist(IProgressMonitor monitor) {
        boolean ret = false;
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        monitor.beginTask("Searching for web service capable projects...", projects.length);
        int i = 0;
        while (i < projects.length) {
            if (WebServiceViewerSynchronization.isInteresting(projects[i])) {
                ret = true;
                break;
            }
            ++i;
        }
        monitor.worked(1);
        return ret;
    }

    static boolean isInteresting(IProject project) {
        return WebServiceViewerSynchronization.hasFacet(project, WEB_FACET) || WebServiceViewerSynchronization.hasFacet(project, EJB_FACET) || WebServiceViewerSynchronization.hasFacet(project, APPCLIENT_FACET);
    }

    public class AddWebServicesNodeUIJob
    extends UIJob {
        public AddWebServicesNodeUIJob() {
            super(WebServiceUIResourceHandler.WS_NAV_JOB2);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            TreeViewer viewer = WebServiceViewerSynchronization.this.contentProvider.getViewer();
            if (!viewer.getControl().isDisposed()) {
                viewer.add(viewer.getInput(), (Object)WebServiceViewerSynchronization.this.contentProvider.getNavigatorGroup());
            }
            WebServiceViewerSynchronization.this.setNavigatorGroupAdded(true);
            return Status.OK_STATUS;
        }
    }

    public class RemoveWebServicesNodeUIJob
    extends UIJob {
        public RemoveWebServicesNodeUIJob() {
            super(WebServiceUIResourceHandler.WS_NAV_JOB4);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            monitor.beginTask(WebServiceUIResourceHandler.WS_NAV_JOB5, 4);
            TreeViewer viewer = WebServiceViewerSynchronization.this.contentProvider.getViewer();
            if (!viewer.getControl().isDisposed()) {
                if (WebServiceViewerSynchronization.this.indexWebServices(monitor)) {
                    viewer.refresh((Object)WebServiceViewerSynchronization.this.contentProvider.getNavigatorGroup());
                } else {
                    viewer.remove((Object)WebServiceViewerSynchronization.this.contentProvider.getNavigatorGroup());
                    WebServiceViewerSynchronization.this.setNavigatorGroupAdded(false);
                }
            }
            return Status.OK_STATUS;
        }
    }

    public class UpdateWebServicesNodeUIJob
    extends UIJob {
        public UpdateWebServicesNodeUIJob() {
            super(WebServiceUIResourceHandler.WS_NAV_JOB3);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            TreeViewer viewer = WebServiceViewerSynchronization.this.contentProvider.getViewer();
            if (!viewer.getControl().isDisposed()) {
                if (WebServiceViewerSynchronization.this.hasNavigatorGroupBeenAdded()) {
                    WebServiceViewerSynchronization.this.contentProvider.getViewer().refresh((Object)WebServiceViewerSynchronization.this.contentProvider.getNavigatorGroup());
                } else {
                    viewer.add(viewer.getInput(), (Object)WebServiceViewerSynchronization.this.contentProvider.getNavigatorGroup());
                    WebServiceViewerSynchronization.this.setNavigatorGroupAdded(true);
                }
            }
            return Status.OK_STATUS;
        }
    }

    public class WebServiceIndexJob
    extends Job {
        public WebServiceIndexJob() {
            super(WebServiceUIResourceHandler.WS_NAV_JOB0);
            this.setRule((ISchedulingRule)new NonConflictingRule());
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(WebServiceUIResourceHandler.WS_NAV_JOB1, 5);
            if (WebServiceViewerSynchronization.this.webServiceProjectsExist(monitor)) {
                WebServiceViewerSynchronization.this.indexWebServices(monitor);
            }
            monitor.done();
            return Status.OK_STATUS;
        }
    }
}

