/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.repo.ISVNListener;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RepositoryResourcesManager {
    private List repositoryListeners = new ArrayList();

    public void addRepositoryListener(ISVNListener listener) {
        this.repositoryListeners.add(listener);
    }

    public void removeRepositoryListener(ISVNListener listener) {
        this.repositoryListeners.remove(listener);
    }

    public void repositoryRemoved(ISVNRepositoryLocation repository) {
        Iterator it = this.repositoryListeners.iterator();
        while (it.hasNext()) {
            ISVNListener listener = (ISVNListener)it.next();
            listener.repositoryRemoved(repository);
        }
    }

    public void repositoryAdded(ISVNRepositoryLocation repository) {
        Iterator it = this.repositoryListeners.iterator();
        while (it.hasNext()) {
            ISVNListener listener = (ISVNListener)it.next();
            listener.repositoryAdded(repository);
        }
    }

    public void repositoryModified(ISVNRepositoryLocation repository) {
        Iterator it = this.repositoryListeners.iterator();
        while (it.hasNext()) {
            ISVNListener listener = (ISVNListener)it.next();
            listener.repositoryModified(repository);
        }
    }

    public void remoteResourceCreated(ISVNRemoteFolder parent, String resourceName) {
        Iterator it = this.repositoryListeners.iterator();
        while (it.hasNext()) {
            ISVNListener listener = (ISVNListener)it.next();
            listener.remoteResourceCreated(parent, resourceName);
        }
    }

    public void remoteResourceDeleted(ISVNRemoteResource resource) {
        Iterator it = this.repositoryListeners.iterator();
        while (it.hasNext()) {
            ISVNListener listener = (ISVNListener)it.next();
            listener.remoteResourceDeleted(resource);
        }
    }

    public void remoteResourceCopied(ISVNRemoteResource source, ISVNRemoteFolder destination) {
        Iterator it = this.repositoryListeners.iterator();
        while (it.hasNext()) {
            ISVNListener listener = (ISVNListener)it.next();
            listener.remoteResourceCopied(source, destination);
        }
    }

    public void remoteResourceMoved(ISVNRemoteResource resource, ISVNRemoteFolder destinationFolder, String destinationResourceName) {
        Iterator it = this.repositoryListeners.iterator();
        while (it.hasNext()) {
            ISVNListener listener = (ISVNListener)it.next();
            listener.remoteResourceMoved(resource, destinationFolder, destinationResourceName);
        }
    }

    public void createRemoteFolder(ISVNRemoteFolder parent, String folderName, String message, IProgressMonitor monitor) throws SVNException {
        parent.createRemoteFolder(folderName, message, monitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteRemoteResources(ISVNRemoteResource[] remoteResources, String message, IProgressMonitor monitor) throws SVNException {
        IProgressMonitor progress = Policy.monitorFor(monitor);
        progress.beginTask(Policy.bind("RepositoryResourcesManager.deleteRemoteResources"), 100 * remoteResources.length);
        HashMap<ISVNRepositoryLocation, ArrayList<ISVNRemoteResource>> mapRepositories = new HashMap<ISVNRepositoryLocation, ArrayList<ISVNRemoteResource>>();
        int i = 0;
        while (i < remoteResources.length) {
            ISVNRemoteResource remoteResource = remoteResources[i];
            ISVNRepositoryLocation repositoryLocation = remoteResource.getRepository();
            ArrayList<ISVNRemoteResource> resources = (ArrayList<ISVNRemoteResource>)mapRepositories.get(repositoryLocation);
            if (resources == null) {
                resources = new ArrayList<ISVNRemoteResource>();
                mapRepositories.put(repositoryLocation, resources);
            }
            resources.add(remoteResource);
            ++i;
        }
        try {
            try {
                Iterator it = mapRepositories.values().iterator();
                while (it.hasNext()) {
                    ISVNRemoteResource resource;
                    List resources = (List)it.next();
                    ISVNClientAdapter svnClient = ((ISVNRemoteResource)resources.get(0)).getRepository().getSVNClient();
                    SVNUrl[] urls = new SVNUrl[resources.size()];
                    int i2 = 0;
                    while (i2 < resources.size()) {
                        resource = (ISVNRemoteResource)resources.get(i2);
                        urls[i2] = resource.getUrl();
                        resource.getParent().refresh();
                        ++i2;
                    }
                    svnClient.remove(urls, message);
                    i2 = 0;
                    while (i2 < resources.size()) {
                        resource = (ISVNRemoteResource)resources.get(i2);
                        this.remoteResourceDeleted(resource);
                        ++i2;
                    }
                    progress.worked(100 * urls.length);
                }
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
            Object var12_16 = null;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            progress.done();
            throw throwable;
        }
        progress.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void copyRemoteResource(ISVNRemoteResource resource, ISVNRemoteFolder destinationFolder, String message, IProgressMonitor monitor) throws SVNException {
        IProgressMonitor progress = Policy.monitorFor(monitor);
        progress.beginTask(Policy.bind("RepositoryResourcesManager.copyRemoteResources"), 100);
        try {
            try {
                ISVNClientAdapter svnClient = resource.getRepository().getSVNClient();
                svnClient.copy(resource.getUrl(), destinationFolder.getUrl(), message, SVNRevision.HEAD);
                destinationFolder.refresh();
                this.remoteResourceCopied(resource, destinationFolder);
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            progress.done();
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        progress.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void moveRemoteResource(ISVNRemoteResource resource, ISVNRemoteFolder destinationFolder, String destinationResourceName, String message, IProgressMonitor monitor) throws SVNException {
        IProgressMonitor progress = Policy.monitorFor(monitor);
        progress.beginTask(Policy.bind("RepositoryResourcesManager.moveRemoteResources"), 100);
        try {
            try {
                ISVNClientAdapter svnClient = resource.getRepository().getSVNClient();
                SVNUrl destUrl = destinationFolder.getUrl().appendPath(destinationResourceName);
                svnClient.move(resource.getUrl(), destUrl, message, SVNRevision.HEAD);
                resource.getParent().refresh();
                destinationFolder.refresh();
                this.remoteResourceMoved(resource, destinationFolder, destinationResourceName);
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            progress.done();
            throw throwable;
        }
        {
            Object var9_12 = null;
        }
        progress.done();
    }
}

