/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.editors;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.epic.perleditor.PerlEditorPlugin;
import org.epic.perleditor.editors.PartitionTypes;

class PerlBracketInserter
implements VerifyKeyListener {
    private static final char NON_BRACKET = '\u0000';
    private final ILog log;
    private boolean closeAngularBrackets;
    private boolean closeBraces;
    private boolean closeBrackets;
    private boolean closeParens;
    private boolean closeDoubleQuotes;
    private boolean closeSingleQuotes;
    private ISourceViewer viewer;

    public PerlBracketInserter(ILog log) {
        this.log = log;
    }

    public boolean isEnabled() {
        return this.viewer != null && (this.closeAngularBrackets || this.closeBraces || this.closeBrackets || this.closeDoubleQuotes || this.closeSingleQuotes || this.closeParens);
    }

    public void setCloseAngularBracketsEnabled(boolean enabled) {
        this.closeAngularBrackets = enabled;
    }

    public void setCloseBracesEnabled(boolean enabled) {
        this.closeBraces = enabled;
    }

    public void setCloseBracketsEnabled(boolean enabled) {
        this.closeBrackets = enabled;
    }

    public void setCloseDoubleQuotesEnabled(boolean enabled) {
        this.closeDoubleQuotes = enabled;
    }

    public void setCloseSingleQuotesEnabled(boolean enabled) {
        this.closeSingleQuotes = enabled;
    }

    public void setCloseParensEnabled(boolean enabled) {
        this.closeParens = enabled;
    }

    public void setViewer(ISourceViewer viewer) {
        this.viewer = viewer;
    }

    public void verifyKey(VerifyEvent event) {
        if (!event.doit || !this.isEnabled()) {
            return;
        }
        char closingChar = this.getClosingChar(event.character);
        if (closingChar == '\u0000') {
            return;
        }
        event.doit = this.processBracketKeyStroke(this.viewer.getDocument(), this.viewer.getSelectedRange(), event.character, closingChar);
    }

    private char getClosingChar(char c) {
        switch (c) {
            case '(': 
            case ')': {
                return this.closeParens ? (char)')' : '\u0000';
            }
            case '<': 
            case '>': {
                return this.closeAngularBrackets ? (char)'>' : '\u0000';
            }
            case '{': 
            case '}': {
                return this.closeBraces ? (char)'}' : '\u0000';
            }
            case '[': 
            case ']': {
                return this.closeBrackets ? (char)']' : '\u0000';
            }
            case '\'': {
                return this.closeSingleQuotes ? (char)'\'' : '\u0000';
            }
            case '\"': {
                return this.closeDoubleQuotes ? (char)'\"' : '\u0000';
            }
        }
        return '\u0000';
    }

    private boolean isClosingChar(IDocument doc, int offset, char c) {
        if (c == '}' || c == ']' || c == '>' || c == ')') {
            return true;
        }
        if (offset == 0) {
            return false;
        }
        try {
            String partitionType = PartitionTypes.getPerlPartition(doc, offset - 1).getType();
            return "LITERAL1".equals(partitionType) || "LITERAL2".equals(partitionType);
        }
        catch (BadLocationException e) {
            this.logBadLocationException(e);
            return false;
        }
    }

    private void logBadLocationException(BadLocationException e) {
        this.log.log((IStatus)new Status(4, PerlEditorPlugin.getPluginId(), 0, "Unexpected exception; report it as a bug in plug-in " + PerlEditorPlugin.getPluginId(), (Throwable)e));
    }

    private boolean processBracketKeyStroke(IDocument doc, Point selection, char keystrokeChar, char closingChar) {
        int offset = selection.x;
        int length = selection.y;
        try {
            String partitionType;
            if (keystrokeChar == '\'' && offset > 0 && ("POD".equals(partitionType = PartitionTypes.getPerlPartition(doc, offset - 1).getType()) || "COMMENT".equals(partitionType))) {
                return true;
            }
            if (this.isClosingChar(doc, offset, keystrokeChar)) {
                if (offset + length < doc.getLength() && doc.getChar(offset + length) == closingChar) {
                    this.skipChar();
                    return false;
                }
            } else {
                if (offset + length < doc.getLength() && doc.getChar(offset + length) == keystrokeChar) {
                    this.skipChar();
                    return false;
                }
                char[] pair = new char[]{keystrokeChar, closingChar};
                doc.replace(offset, 0, String.valueOf(pair));
                this.skipChar();
                return false;
            }
            return true;
        }
        catch (BadLocationException e) {
            this.logBadLocationException(e);
            return true;
        }
    }

    private void skipChar() {
        StyledText text = this.viewer.getTextWidget();
        text.setCaretOffset(text.getCaretOffset() + 1);
    }
}

