/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.macosui;

import java.io.File;
import java.io.IOException;

public class MacOSUtil {
    private static Runtime theRuntime = Runtime.getRuntime();

    public static boolean isMacOS() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    }

    public static void setMacOS(String appName) {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("apple.awt.showGrowBox", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", appName);
    }

    public Process exec(String[] command) throws IOException {
        File appDirectory;
        File[] candidates;
        File theFile = new File(command[0]);
        if (!theFile.exists()) {
            throw new IOException("Program " + command[0] + " does not exist");
        }
        if (theFile.isDirectory() && theFile.getName().endsWith(".app") && (candidates = (appDirectory = new File(theFile, "Contents/MacOS")).listFiles()).length != 1) {
            throw new IOException("Can't figure out which file to run");
        }
        return theRuntime.exec(command);
    }
}

