##############################################################################
#
# COREBlog.py
# Classes for COREBlog Site
#
# Copyright (c) 2003-2004 Atsushi Shibata. All Rights Reserved.
#
# Permission to use, copy, modify, and distribute this software and its 
# documentation for any purpose and without fee is hereby granted, provided that
# the above copyright notice appear in all copies and that both that copyright 
# notice and this permission notice appear in supporting documentation, and that
# the name of Atsushi Shibata not be used in advertising or publicity pertaining 
# to distribution of the software without specific, written prior permission. 
# 
# ATSUSHI SHIBAT DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, 
# INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
# EVENT SHALL SHIBAT ATSUSHI BE LIABLE FOR ANY SPECIAL, INDIRECT OR 
# CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
# USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
# OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
# PERFORMANCE OF THIS SOFTWARE. 
#
#
# This software uses stripogram,Copyright (c) 2001 Chris Withers
#
##############################################################################

__doc__="""COREBlog"""

class COREBlog:
    """COREBlog - A contents-data handler class for Weblog Product for Zope.
       COREBlog has Entries, comments, trackbacks in BTree.
       You can get contents date with some methods, like entry_items,day_entry_items.
       If you want to store entry data, use manage_addEntry().
       Comments,Trackbacks are added via methods in Entry instance.
       COREBlog is also folderish class, has Zope object - DTML,Folder,Image - in it. 
       """

    def get_product_version(self):
        """Return version string for COREBlog."""


    def blog_title(self):
        """ return title of blog """
        return self.title


    def blogurl(self):
        """ Return URL string of the COREBlog.
        If "blog_url" on Property exists, this function return this.
        If not, this function returns absolute_url()"""

    def __getitem__(self,id):
        """Return Entry instance. """

    #Entry management

    def manage_addEntry(self,author,body,extend,excerpt, \
                        main_category,moderated,sub_category=[], \
                        title="",subtitle="", entry_date="", \
                        format=0,allow_comment=0,receive_trackback=0,
                        trackback_url="",sendnow=0,REQUEST=None,
                        sendping = 1,**kw):
        """Method to add a Entry object."""

    def manage_deleteEntries(self,ids,REQUEST=None):
        """Method to delete Entries in list(ids)"""

    def deleteEntry(self,id):
        """Delete single entry."""

    def getEntry(self,id):
        """Return single entry."""

    def get_entry(self,id):
        """Puglic interface for getting entry object from id, for convenience to be used in DTML"""

    def recatalogEntries(self,REQUEST=None):
        """ Recatalog all Entries. """
    def entry_items(self,start=0,count=-1,consider_moderation = 1):
        """Return list of Entry. You can control returned list with start,count paramater.
            If consider_moderation is 0,this function returns all entries, including "closed" entry."""

    def rev_entry_items(self,start=0,count=-1,consider_moderation = 1):
        """Return list of Entry(reversed indexing)."""

    def day_entry_items(self,year,month,day):
        """Return entries of a day."""

    def rev_day_entry_items(self,count=1,start_year=0,start_month=0,start_day=0):
        """Return list of Entry,based on date(reversed indexing)."""

    def month_entry_items(self,count=1,year=0,month=0):
        """Return list of Entry on the month."""

    def month_archive_items(self,count=1,start_year=0,start_month=0):
        """ Return list of a month. """

    def getMonthName(self,month):
        """ Return month name. """

    def rev_category_entry_items(self,category_id,start=0,count=-1,consider_moderation = 1):
        """Return list of Entries in a category."""

    def category_entry_items(self,category_id,start=0,count=-1,consider_moderation = 1):
        """Return list of Entry in a category, in reverse order."""

    #Comment management

    def rev_comment_items(self,start=0,count=-1):
        """Return list of Comments(reversed indexing)."""

    def count_blog_comment(self):
        """return count of Comment."""
        return len(self.comment_list)

    #Trackback management

    def deleteTrackback(self,id):
        """Delete one trackback in id."""

    def rev_trackback_items(self,start=0,count=-1):
        """Return list of Trackback(reversed indexing)."""

    def count_blog_trackback(self):
        """Return count of Trackback."""

    #Calendar

    def get_calendar(self,year=0,month=0,firstweekday='SUNDAY'):
        """Reutrn calendar list. Returned list has a 7 items of dictionary ({'day':num,'entry_count':e_cnt})."""

    def countEntryOfTheDay(self,year,month,day):
        """Return count of entry of the day."""

    #Category management

    def addCategory(self,name,description,icon_path="",sec = -1):
        """Add a Category."""

    def manage_addCategory(self,name,description,icon_path="",REQUEST=None):
        """Add a Category,method to be called from ZMI or something."""

    def manage_deleteCategories(self,ids,REQUEST=None):
        """Delete Category in list(ids)"""

    def getCategory(self,id):
        """ Reruth specific category instance. """

    def category_list(self):
        """ Return all category instance in list. """

    def manage_editCategory(self,id,name,description,icon_path,REQUEST=None):
        """Edit category."""

    #Moblog

    def receive(self):
        """Receive e-mail according to Setting and add entry if need."""

    #Utility

    def removeHTML(self,s):
        """Remove all HTML tags."""
        return remove_html(str(s))

    def validateHTML(self,s):
        """Validate HTML. Remove some HTML tags."""
        return validate_html(str(s),tags)

    def validateEntryBody(self,s):
        """Remove HTML tags for Entry."""

    def validateCommentBody(self,s):
        """Remove HTML tags for Comment."""

    def convertCharcode(self,s,tocode):
        """ Convert charcode. """

    def get_charcode(self):
        """ Return charcode setting in management_page_charset. """

    def get_blogclient_charcode(self):
        """ Return charcode setting for blogclient."""

    def get_trackback_charcode(self):
        """ Return trackback charcode setting."""


    #Factory method


def manage_addCOREBlog(parent,REQUEST=None,RESPONSE=None):
    """Add a COREBlog to a container."""

