previewreadmailitemmodule.prototype= new ItemModule;
previewreadmailitemmodule.prototype.constructor = previewreadmailitemmodule;
previewreadmailitemmodule.superclass = ItemModule.prototype;

function previewreadmailitemmodule(id, element)
{
	if(arguments.length > 0) {
		this.init(id, element);
	}
}

previewreadmailitemmodule.prototype.destructor = function()
{
	//this.itemEntryID will set previous message as read
	if(this.itemEntryID) {
		this.setReadFlag(this.itemEntryID, (this.sendReadReceipt()?"read,receipt":"read,noreceipt"));
		this.itemMessageFlags = MSGFLAG_READ|MSGFLAG_UNMODIFIED; // reset message flags to read/unmodified, because I don't want to do another request for just to get these flags.
	}

	this.messageentryid = false;

	dhtml.removeEvent(window, "resize", eventPreviewItemResize);
	dhtml.removeEvents(this.element);
	dhtml.deleteAllChildren(this.element);
	webclient.inputmanager.removeObject(this);
}

previewreadmailitemmodule.prototype.init = function(id, element)
{
	dhtml.addClassName(element,"previewpane");
	previewreadmailitemmodule.superclass.init.call(this, id, element);

	webclient.inputmanager.addObject(this, element);
	webclient.inputmanager.bindEvent(this, "focus", eventPreviewSetFocus);
}

previewreadmailitemmodule.prototype.initializeView = function()
{
	var meetingrequest = dhtml.addElement(this.element, "div", false, "meetingrequest");
	meetingrequest.style.display = "none";
	
	var header = dhtml.addElement(this.element, "div", false, "header");
	var previewpane_size_state_classname = "folderstate_close";
	if (webclient.settings.get("folders/entryid_"+ this.parententryid +"/previewpane_header", "full")=="full"){
		previewpane_size_state_classname = "folderstate_open";
	}
	dhtml.addElement(header, "span", previewpane_size_state_classname +" previewpane_size", "previewpane_size", NBSP);
	
	var subject = dhtml.addElement(header, "span", false, "subject", NBSP);
	
	dhtml.addElement(header, "div", false, "conflict");
	
	dhtml.addElement(header, "div", false, "extrainfo");
	dhtml.addElement(header, "div", false, "from");
	
	var recipients = dhtml.addElement(header, "div", false, "recipients");
	var table = "<table border='0' cellpadding='0' cellspacing='0'>";
	table += "<tr><td class='property' width='40' nowrap>" + _("To") + ":</td><td><div id='to' class='property_data'></div></td></tr>";
	table += "<tr><td class='property' width='40' nowrap>" + _("CC") + ":</td><td><div id='cc' class='property_data'></div></td></tr>";
	table += "<tr><td class='property' width='40' nowrap>" + _("BCC") + ":</td><td><div id='bcc' class='property_data'></div></td></tr>";
	table += "</table>";
	var meetingrequestData = "<div id='meetingrequest_data'>";
	meetingrequestData += "<table border='0' cellpadding='0' cellspacing='0'>";
	meetingrequestData += "	<tr id='meetingrequest_data_startdate_row'>";
	meetingrequestData += "		<td class='property' width='40' nowrap>" + _("Startdate") + ": </td>";
	meetingrequestData += "		<td><div id='meetingrequest_startdate' class='property_data'></div></td>";
	meetingrequestData += "	</tr>";
	meetingrequestData += "	<tr id='meetingrequest_data_duedate_row'>";
	meetingrequestData += "		<td class='property' width='40' nowrap>" + _("Enddate") + ": </td>";
	meetingrequestData += "		<td><div id='meetingrequest_duedate' class='property_data'></div></td>";
	meetingrequestData += "	</tr>";
	meetingrequestData += "	<tr id='meetingrequest_data_when_row'>";
	meetingrequestData += "		<td class='property' width='40' nowrap>" + _("When") + ": </td>";
	meetingrequestData += "		<td><div id='meetingrequest_when' class='property_data'></div></td>";
	meetingrequestData += "	</tr>";
	//Proposed Time
	meetingrequestData += "	<tr id='meetingrequest_proposed_row'>";
	meetingrequestData += "		<td class='property' width='40' nowrap>" + _("Proposed") + ": </td>";
	meetingrequestData += "		<td><span id='proposed_start_whole'></span> - <span id='proposed_end_whole'></span></td>";
	meetingrequestData += "	</tr>";
	
	meetingrequestData += "	<tr>";
	meetingrequestData += "		<td class='property' width='40' nowrap>" + _("Location") + ": </td>";
	meetingrequestData += "		<td><div id='meetingrequest_location' class='property_data'></div></td>";
	meetingrequestData += "	</tr>";
	meetingrequestData += "</table>";
	meetingrequestData += '</div>';
	recipients.innerHTML = table + meetingrequestData;
	
	var atachments = dhtml.addElement(header, "div", false, "attachment_data");
	var table = "<table border='0' cellpadding='0' cellspacing='0'>";
	table += "<tr><td class='property' width='100' nowrap>" + _("Attachments") + ":</td><td><div id='attachments' class='property_data' style='padding: 5px;'></div></td></tr>";
	table += "</table>";
	atachments.innerHTML = table;
	
	// Weird bug in IE. Can't set iframe property 'frameBorder' by javascript. 
	// So innerHTML used to create an iFrame.
	// The javascript in the src attribute is to suppress the security warning in IE
	
	// WARNING THIS MEANS THAT ALL ELEMENT REFERENCES BEFORE THIS POINT BECOME INVALID
	if (window.BROWSER_IE){
		// SSL fix for IE
		this.element.innerHTML += "<iframe id='html_body' frameborder='0' src=\"javascript:document.open();document.write('<html></html>');document.close();\"></iframe>";
	}else{
		this.element.innerHTML += "<iframe id='html_body' frameborder='0'></iframe>";
	}	

	accept = dhtml.addElement(dhtml.getElementById("meetingrequest"), "span", "menubutton icon icon_accept", "accept", _("Accept"));
	tentative = dhtml.addElement(dhtml.getElementById("meetingrequest"), "span", "menubutton icon icon_tentative" , "tentative", _("Tentative"));
	decline = dhtml.addElement(dhtml.getElementById("meetingrequest"), "span", "menubutton icon icon_decline" , "decline", _("Decline"));
	removefromcalendar = dhtml.addElement(dhtml.getElementById("meetingrequest"), "span", "menubutton icon icon_removefromcalendar" , "removefromcalendar", _("Remove from calendar"));
	proposenewtime = dhtml.addElement(dhtml.getElementById("meetingrequest"), "span", "menubutton icon icon_proposenewtime" , "proposenewtime", _("Propose New Time"));
	notcurrent = dhtml.addElement(dhtml.getElementById("meetingrequest"), "span", "menubutton icon icon_not_current", "notcurrent", _("Not Current"));
	
	dhtml.addEvent(this, accept, "click", eventPreviewItemAcceptClick);
	dhtml.addEvent(this, tentative, "click", eventPreviewItemTentativeClick);
	dhtml.addEvent(this, decline, "click", eventPreviewItemDeclineClick);
	dhtml.addEvent(this, removefromcalendar, "click", eventPreviewItemRemoveFromCalendarClick);
	dhtml.addEvent(this, proposenewtime, "click", eventPreviewItemProposeNewTimeClick);
	dhtml.addEvent(this, notcurrent, "click", eventPreviewItemNotCurrentClick);

	dhtml.addEvent(this, accept, "mouseover", eventPreviewItemButtonOver);
	dhtml.addEvent(this, tentative, "mouseover", eventPreviewItemButtonOver);
	dhtml.addEvent(this, decline, "mouseover", eventPreviewItemButtonOver);
	dhtml.addEvent(this, removefromcalendar, "mouseover", eventPreviewItemButtonOver);
	dhtml.addEvent(this, proposenewtime, "mouseover", eventPreviewItemButtonOver);
	dhtml.addEvent(this, notcurrent, "mouseover", eventPreviewItemButtonOver);

	dhtml.addEvent(this, accept, "mouseout", eventPreviewItemButtonOver);
	dhtml.addEvent(this, tentative, "mouseout", eventPreviewItemButtonOver);
	dhtml.addEvent(this, decline, "mouseout", eventPreviewItemButtonOver);
	dhtml.addEvent(this, removefromcalendar, "mouseout", eventPreviewItemButtonOver);
	dhtml.addEvent(this, proposenewtime, "mouseout", eventPreviewItemButtonOver);
	dhtml.addEvent(this, notcurrent, "mouseout", eventPreviewItemButtonOver);
	
	dhtml.addEvent(this, dhtml.getElementById("previewpane_size"), "mouseup", eventPreviewItemSize);
}

previewreadmailitemmodule.prototype.item = function(action)
{
	//this.itemEntryID will set previous message as read
	if(this.itemEntryID){
		this.setReadFlag(this.itemEntryID, (this.sendReadReceipt()?"read,receipt":"read,noreceipt"));
		this.itemMessageFlags = MSGFLAG_READ|MSGFLAG_UNMODIFIED; // reset message flags to read/unmodified, because I don't want to do another request for just to get these flags.
	}
	
	this.deleteLoadMessage();

	var message = action.getElementsByTagName("item")[0];
	// if there is no message then return, because there is no need to show data in preview pane.
	if(!message) return false;
	
	this.initializeView();

	if(message && message.childNodes) {
		var subject = message.getElementsByTagName("subject")[0];
		if(subject && subject.firstChild) {
			var subjectElement = dhtml.getElementById("subject");
			dhtml.addTextNode(subjectElement, subject.firstChild.nodeValue);
		}

		// Use functions from 'readmailitemmodule', to prevent double implementations.
		// First check if the 'readmailitemmodule' exists.
		if(readmailitemmodule && readmailitemmodule.prototype) {
			readmailitemmodule.prototype.storeid = this.storeid;
			readmailitemmodule.prototype.rootentryid = this.rootentryid;
			readmailitemmodule.prototype.messageentryid = this.messageentryid;
			readmailitemmodule.prototype.attachNum = this.attachNum;

			readmailitemmodule.prototype.setRecipients(message);
			readmailitemmodule.prototype.setProperties(message);
			readmailitemmodule.prototype.setAttachments(message);
			readmailitemmodule.prototype.setBody(message);
			readmailitemmodule.prototype.setFrom(message);
			readmailitemmodule.prototype.setRepliedForwardedInfo(message);
			readmailitemmodule.prototype.setImportanceSensitivityInfo(message);
		}

		var isCounterProposal = (dhtml.getXMLValue(message,"counter_proposal", 0) > 0)?true:false;
		var isRecurring = (dhtml.getXMLValue(message,"recurring", 0) > 0)?true:false;

		// Only set the meeting request fields when we are dealing with a Meeting Request.
		if(dhtml.getXMLValue(message,"message_class","").indexOf("IPM.Schedule.Meeting") === 0){
			dhtml.getElementById("meetingrequest").style.display = "block";
			dhtml.getElementById("meetingrequest_data").style.display = "";

			dhtml.getElementById("meetingrequest_startdate").innerHTML = strftime( _("%a %x %X"), dhtml.getXMLValue(message, "startdate", "") ); 
			dhtml.getElementById("meetingrequest_duedate").innerHTML   = strftime( _("%a %x %X"), dhtml.getXMLValue(message, "duedate", "") );

			// set unixtime attribute to pass it to proposenewtime dialog
			dhtml.getElementById("meetingrequest_startdate").setAttribute("unixtime", dhtml.getXMLValue(message, "startdate", ""));
			dhtml.getElementById("meetingrequest_duedate").setAttribute("unixtime", dhtml.getXMLValue(message, "duedate", ""));

			/**
			 * Set startdate/duedate or when in meeting request data pane
			 */
			var recurring_pattern = message.getElementsByTagName("recurring_pattern")[0];
			if (recurring_pattern && recurring_pattern.firstChild && recurring_pattern.firstChild.nodeValue.length > 0) {
				// Show when row when you are dealing with a recurring item...
				dhtml.getElementById("meetingrequest_data_when_row").style.display = "";
				dhtml.getElementById("meetingrequest_when").innerHTML = recurring_pattern.firstChild.nodeValue
				// ...and hide startdate/duedate
				dhtml.getElementById("meetingrequest_data_startdate_row").style.display = "none";
				dhtml.getElementById("meetingrequest_data_duedate_row").style.display = "none";
			}else{
				// Show startdate/duedate when you are NOT dealing with a recurring item...
				dhtml.getElementById("meetingrequest_data_startdate_row").style.display = "";
				dhtml.getElementById("meetingrequest_data_duedate_row").style.display = "";
				// ...and hide when row
				dhtml.getElementById("meetingrequest_data_when_row").style.display = "none";
			}
			
			if(isCounterProposal && dhtml.getXMLValue(message,"message_class","").indexOf("IPM.Schedule.Meeting.Resp") === 0){
				// Show proposed time when message is a counter proposal...
				dhtml.getElementById("meetingrequest_proposed_row").style.display = "";
			} else {
				// ...otherwise hide proposed time
				dhtml.getElementById("meetingrequest_proposed_row").style.display = "none";
			}
			dhtml.getElementById("meetingrequest_location").innerHTML  = dhtml.getXMLValue(message, "location", "");

			// Hide the "Remove From Calendar" button when this is not a Meeting Cancellation.
			if(dhtml.getXMLValue(message,"message_class","").indexOf("IPM.Schedule.Meeting.Canceled") !== 0){
				dhtml.getElementById("removefromcalendar").style.display = "none";
			}
			// Hide the "Accept/Decline/Tentative" buttons and "Propose New Time" button when this is not a Meeting Cancellation.
			if(dhtml.getXMLValue(message,"message_class","").indexOf("IPM.Schedule.Meeting.Request") !== 0){
				dhtml.getElementById("accept").style.display = "none";
				dhtml.getElementById("decline").style.display = "none";
				dhtml.getElementById("tentative").style.display = "none";
				dhtml.getElementById("proposenewtime").style.display = "none";
				dhtml.getElementById("notcurrent").style.display = "none";
			}else{
				if(isRecurring){
					// Hide proposenewtime buttons when you do have a RECURRING meeting REQUEST
					dhtml.getElementById("proposenewtime").style.display = "none";
				}
				
				//If meeting request is out of date.
				if (dhtml.getXMLValue(message, "out_of_date", false)){
					dhtml.getElementById("accept").style.display = "none";
					dhtml.getElementById("decline").style.display = "none";
					dhtml.getElementById("tentative").style.display = "none";
					dhtml.getElementById("proposenewtime").style.display = "none";
					
					var textMeetingResponseText = _("This meeting request was updated after this message was sent. You Should open a later update or open the item on the calendar.");
					this.showextrainfo(textMeetingResponseText);
				} else {
					dhtml.getElementById("notcurrent").style.display = "none";
				}
			}

			// Determine whether the message is a response and the buttons should be hidden
			if(dhtml.getXMLValue(message,"message_class","").indexOf("IPM.Schedule.Meeting.Resp") === 0){
				dhtml.getElementById("meetingrequest").style.display = "none";
				// Set the meeting response text
				var textMeetingResponseText = "";
				switch(dhtml.getXMLValue(message, "message_class", false)){
					case "IPM.Schedule.Meeting.Resp.Pos":
						textMeetingResponseText += " " + _("has accepted");
						break;
					case "IPM.Schedule.Meeting.Resp.Tent":
						textMeetingResponseText += " " + _("has tentatively accepted");
						break;
					case "IPM.Schedule.Meeting.Resp.Neg":
						textMeetingResponseText += " " + _("has declined");
						break;
				}
				if(isCounterProposal){
					if(textMeetingResponseText != ""){
						textMeetingResponseText += " " + _("and");
					}
					textMeetingResponseText += " " + _("proposed a new time for this meeting");
				}
				if(textMeetingResponseText != ""){
					textMeetingResponseText = dhtml.getXMLValue(message, "sent_representing_name", "") + textMeetingResponseText + ".";
					this.showextrainfo(textMeetingResponseText);
				}
			}

		}else{
			dhtml.getElementById("meetingrequest").style.display = "none";
			dhtml.getElementById("meetingrequest_data").style.display = "none";
		}

		if (webclient.settings.get("folders/entryid_"+this.parententryid+"/previewpane_header", "full")=="small"){
			dhtml.getElementById("recipients").style.display = "none";
			dhtml.getElementById("attachment_data").style.display = "none";
			dhtml.getElementById("from").style.display = "none";
			dhtml.removeClassName(this.header_size, "folderstate_open");
			dhtml.addClassName(this.header_size, "folderstate_close");
		}
		
	}

	dhtml.addEvent(this.id, window, "resize", eventPreviewItemResize);

	//this.itemEntryID will save the entryid and will mark it at destructing or next mail as read
	var entryid = message.getElementsByTagName("entryid")[0];
	this.itemEntryID = dhtml.getTextNode(entryid,"");
	this.itemMessageFlags = parseInt(dhtml.getXMLValue(message,"message_flags",0),10);
	/**
	 * We have to keep track of whether we sent a readreceipt already because we
	 * do not get an update from the server with the new message flags.
	 */
	this.readReceiptSent = false;

	// use timeout to give the browser some time to render the message when it is html
	var isHTML = message.getElementsByTagName("isHTML")[0];
	if(isHTML && isHTML.firstChild) {
		window.setTimeout("eventPreviewLoaded("+this.id+")",50);
	}else{
		eventPreviewLoaded(this.id);
	}
}

previewreadmailitemmodule.prototype.setReadFlag = function(messageEntryid, flag)
{
	if ((this.itemMessageFlags & MSGFLAG_READ)!=MSGFLAG_READ){ // prevent request if message was already marked as read
		var data = new Object();
		data["store"] = this.storeid;
		data["parententryid"] = this.parententryid;
		data["entryid"] = messageEntryid;

		if(flag) {
			data["flag"] = flag;
		}
	
		webclient.xmlrequest.addData(this, "read_flag", data);
		webclient.xmlrequest.sendRequest();
	}
}

previewreadmailitemmodule.prototype.resize = function()
{
	var docHeight = dhtml.getBrowserInnerSize().y;

	this.element.style.height = docHeight - dhtml.getElementTop(this.element) - 10 + "px";

	var html_body = dhtml.getElementById("html_body");
	if (html_body){
		html_body.style.width = (this.element.offsetWidth - 30) + "px";

		var height = (this.element.offsetHeight - html_body.offsetTop) - 40;
		if(height < 3) {
			height = 3;
		}

		html_body.style.height = height + "px";
	}
}

previewreadmailitemmodule.prototype.sendReadReceipt = function()
{
	var result = false;
	if (!this.readReceiptSent && (this.itemMessageFlags & MSGFLAG_RN_PENDING) == MSGFLAG_RN_PENDING){
		switch(webclient.settings.get("global/readreceipt_handling", "ask")){
			case "ask":
				result = confirm(_("The sender of this message has asked to be notified when you read this message.")+"\n"+_("Do you wish to notify the sender?"));
				break;
			case "never":
				result = false;
				break;
			case "always":
				result = true;
				break;
		}
		// We have to set the readReceiptSent to true because we do not get an update from the server with the new message flags.
		this.readReceiptSent = true;
	}
	return result;
}

function eventPreviewLoaded(moduleID)
{
	// Remove contextmenu and other elements onmousedown and onscroll in iFrame.
	var html_body = dhtml.getElementById("html_body");
	if(html_body) {
		if(!html_body.contentWindow.document.body){
			html_body.contentWindow.document.appendChild(html_body.contentWindow.document.createElement("body"));
			html_body.contentWindow.document.body.innerHTML = "&nbsp;";
		}
		
		if (html_body.contentWindow.document.body.innerHTML == "") {
			html_body.contentWindow.document.body.innerHTML = "&nbsp;";
		}
		
		html_body.contentWindow.document.body.style.height = "100%";
		html_body.contentWindow.document.body.style.margin = "0";
		
		html_body.contentWindow.document.body.onmousedown = eventPreviewItemMouseDown;
		html_body.contentWindow.onscroll = eventPreviewItemMouseDown;	
	}

	webclient.getModule(moduleID).resize();
}

function eventPreviewItemResize(moduleObject, element, event)
{
	moduleObject.resize();
}

function eventPreviewItemMouseDown()
{
	dhtml.executeEvent(document.body, "mouseup");
}

function eventPreviewItemAcceptClick(moduleObject, element, event)
{
	moduleObject.acceptMeetingRequest();
}

function eventPreviewItemTentativeClick(moduleObject, element, event)
{
	moduleObject.tentativeMeetingRequest();
}

function eventPreviewItemDeclineClick(moduleObject, element, event)
{
	moduleObject.declineMeetingRequest();
}

function eventPreviewItemProposeNewTimeClick(moduleObject, element, event)
{
	// get current date & time of meeting request
	var meetingrequest_startdate = dhtml.getElementById("meetingrequest_startdate");
	var meetingrequest_duedate = dhtml.getElementById("meetingrequest_duedate");
	var meetingrequest_startdate_value, meetingrequest_duedate_value;

	if(typeof meetingrequest_startdate != "undefined" && typeof meetingrequest_duedate != "undefined") {
		meetingrequest_startdate_value = meetingrequest_startdate.getAttribute("unixtime");
		meetingrequest_duedate_value = meetingrequest_duedate.getAttribute("unixtime");
	} else {
		meetingrequest_startdate_value = false;
		meetingrequest_duedate_value = false;
	}

	webclient.openModalDialog(-1, 'previewreadmailitem_proposenewtimedialog', DIALOG_URL+'task=advprompt_modal', 325,250, previewreadmailitemProposenewtime_dialog_callback, {
			moduleObject: moduleObject
		}, {
			windowname: _("Propose new time"),
			fields: [{
				name: "combineddatetimepicker",
				label_start: _("Start time"),
				label_end: _("End time"),
				id_start: "proposed_start",
				id_end: "proposed_end",
				type: "combineddatetime",
				required: true,
				value_start: meetingrequest_startdate_value,
				value_end: meetingrequest_duedate_value
			},
			{
				name: "body",
				label: _("Comment"),
				type: "textarea",
				required: false,
				value: false
			}]
		}
	);
}
// This method is called after the user has select a time to propose for the meeting
function previewreadmailitemProposenewtime_dialog_callback(result, callbackData){
	if(callbackData.moduleObject){
		callbackData.moduleObject.proposalMeetingRequest(parseInt(result.combineddatetimepicker.start,10), parseInt(result.combineddatetimepicker.end,10), result.body);
	}

}

function eventPreviewItemButtonOver(moduleObject, element, event)
{
	dhtml.toggleClassName(element, "menubuttonover");
}

function eventPreviewItemSize(moduleObject, element, event)
{
	if (webclient.settings.get("folders/entryid_"+moduleObject.parententryid+"/previewpane_header", "full")=="full"){
		dhtml.getElementById("recipients").style.display = "none";
		dhtml.getElementById("attachment_data").style.display = "none";
		dhtml.getElementById("from").style.display = "none";
		dhtml.removeClassName(element, "folderstate_open");
		dhtml.addClassName(element, "folderstate_close");
		webclient.settings.set("folders/entryid_"+moduleObject.parententryid+"/previewpane_header", "small");
	}else{
		dhtml.getElementById("recipients").style.display = "block";
		dhtml.getElementById("attachment_data").style.display = "block";
		dhtml.getElementById("from").style.display = "block";
		dhtml.removeClassName(element, "folderstate_close");
		dhtml.addClassName(element, "folderstate_open");
		webclient.settings.set("folders/entryid_"+moduleObject.parententryid+"/previewpane_header", "full");
	}

	moduleObject.resize();
}

function eventPreviewSetFocus(moduleObject, element, event)
{
	var html_body = dhtml.getElementById("html_body");
	if (html_body)
		html_body.contentWindow.focus();
}

function eventPreviewItemRemoveFromCalendarClick(moduleObject, element, event)
{
    moduleObject.removeFromCalendar();
}

/**
 * Function which shows extrainfo about the item.
 * @param string value information that is to be shown.
 */
previewreadmailitemmodule.prototype.showextrainfo = function (value)
{
	var elemExtraInfo = dhtml.getElementById("extrainfo");
	dhtml.addElement(elemExtraInfo, "p", false, false, value);
	elemExtraInfo.style.display = "block";
}