hierarchymodule.prototype = new Module;
hierarchymodule.prototype.constructor = hierarchymodule;
hierarchymodule.superclass = Module.prototype;

function hierarchymodule(id, element)
{
	if(arguments.length > 0) {
		this.init(id, element);
	}
}

hierarchymodule.prototype.init = function(id, element)
{
	hierarchymodule.superclass.init.call(this, id, element);
	
	this.stores = new Array();
	this.defaultstore = false;
	this.openedFolders = new Object();
	this.getOpenedFolders();
	this.selectedFolder = false;

	this.folderIndex = 0;
	this.folderEvents = new Object();
	this.folderEvents["mousedown"] = eventHierarchySelectFolder;
	this.folderEvents["mouseup"] = eventHierarchyChangeFolder;
	this.folderEvents["contextmenu"] = eventHierarchyContextMenu;

	this.treeEvents = new Object();
	this.treeEvents["ShowBranch"] = eventHierarchyShowBranch;
	this.treeEvents["SwapFolder"] = eventTreeSwapFolder;

	this.setTitle(_("Folder list"), _("All folders"));
	this.contentElement = dhtml.addElement(this.element, "div", false, "hierarchy");
	
	this.sharedFoldersElement = dhtml.addElement(this.element, "div", false, "shared_folder");
	this.hideSharedFolderActions();
	var sfLink = dhtml.addElement(this.sharedFoldersElement,"a", false, false, _("Open shared folders") + "...");
	dhtml.addEvent(this.id, sfLink, "click", eventSharedFoldersClick);
	
	dhtml.addElement(this.sharedFoldersElement,"br");

	if(MUC_AVAILABLE){
		var mucLink = dhtml.addElement(this.sharedFoldersElement,"a", false, false, _("Open Multi User Calendar"));
		dhtml.addEvent(this.id, mucLink, "click", eventAdvancedCalendarClick);
	}
	
	dhtml.addEvent(this.id, document.body, "mouseup", eventHierarchyCheckSelectedContextFolder);
}

hierarchymodule.prototype.execute = function(type, action)
{
	switch(type)
	{
		case "list":
			var stores = action.getElementsByTagName("store");

			for(var j = 0; j < stores.length; j++)
			{
				var store = new Object();

				var attributes = stores[j].attributes;
				for(var i = 0; i < attributes.length; i++)
				{
					var item = attributes.item(i);
					
					switch(item.nodeName)
					{
						case "id":
							store["id"] = item.nodeValue;
							break;
						case "subtree":
							store["subtree_entryid"] = item.nodeValue;
							break;
						case "name":
							store["name"] = item.nodeValue;
							break;
						case "type":
							store["type"] = item.nodeValue;
							if (store["type"] == "default"){
								this.defaultstore = store;
								webclient.menu.defaultstoreid = this.defaultstore["id"];
							}
							break;
						case "username":
							store["username"] = item.nodeValue;
							break;
						case "foldertype":
							store["foldertype"] = item.nodeValue;
							break;
					}
				}

				var defaultfolders = stores[j].getElementsByTagName("defaultfolders")[0];
				store["defaultfolders"] = new Object();
				
				if(defaultfolders) {
					for(var i = 0; i < defaultfolders.childNodes.length; i++)
					{
						var folder = defaultfolders.childNodes[i];
						
						if(folder.firstChild) {
							store["defaultfolders"][folder.nodeName] = folder.firstChild.nodeValue;
						}
					}
				}
				
				var folders = stores[j].getElementsByTagName("folder");
				store["folders"] = new Array();
				
				for(var i = 0; i < folders.length; i++)
				{
					var folder = this.setFolder(folders[i]);
					
					if(folder) {
						if(folder["entryid"] == store["subtree_entryid"]) {
							folder["display_name"] = store["name"];
							store["root"] = folder;
						} else {
							store["folders"].push(folder);
						}
					}
				}
				
				var newStore = true;
				for(var i=0;i<this.stores.length;i++){
					if(this.stores[i].id == store.id && this.stores[i].foldertype == store.foldertype){
						this.stores[i] = store;
						newStore = false;
					}
					
					if(store.type=="other" && this.stores[i].type=="other" && this.stores[i].username==store.username && store.foldertype=="all"){
						this.stores[i] = store;
						newStore = false;
					}
				}
				if (newStore){
					this.stores.push(store);
				}
			}

			// sorting storelist
			this.stores.sort(this.sortStores);
			
			this.createHierarchyList(true);
			this.showSharedFolderActions();
			break;
		case "folder":
			var folder = action.getElementsByTagName("folder")[0];
			
			var store_entryid = folder.getElementsByTagName("store_entryid")[0];
			var entryid = folder.getElementsByTagName("entryid")[0];
			var deleteFolder = folder.getElementsByTagName("folderdelete")[0];

			// check if this folder must be deleted
			if(deleteFolder && deleteFolder.firstChild && entryid.firstChild) {
				for(var i = 0; i < this.stores.length; i++)
				{
					for(var j = 0; j < this.stores[i]["folders"].length; j++)
					{
						if(this.stores[i]["folders"][j]["entryid"] == entryid.firstChild.nodeValue) {
							this.stores[i]["tree"].deleteNode(this.stores[i]["folders"][j]["entryid"], true);
							this.stores[i]["folders"].splice(j, 1);
						}
					}
				}
				
				this.createHierarchyList();

			} else if(entryid.firstChild) { // folder is added or changed

				var folderobject = this.getFolder(entryid.firstChild.nodeValue);

				for(var i = 0; i < this.stores.length; i++)
				{
					if(this.stores[i]["id"] == store_entryid.firstChild.nodeValue) {
						if(!folderobject) {
							// folder is added
							this.stores[i]["folders"].push(this.setFolder(folder));
							this.changeFolder(this.stores[i]["tree"], "add", this.setFolder(folder));
							webclient.xmlrequest.addData(this, "list");
						} else {
							// folder is changed
							var changedFolder = this.setFolder(folder);
							
							if(!this.isRootFolder) {
								this.stores[i]["folders"][this.folderIndex] = changedFolder;
							} else {
								this.stores[i]["root"] = changedFolder;
								webclient.xmlrequest.addData(this, "list");
							}
							
							var changeType = "change";
							if(folderobject["parent_entryid"] != changedFolder["parent_entryid"]) {
								// selected parentFolder
								var parentFolder = dhtml.getElementById(this.stores[i].tree.getNode(dhtml.getTextNode(entryid,"")).parentid);
								if(parentFolder){
									parentFolder = parentFolder.childNodes[1];
									eventHierarchySelectFolder(this, parentFolder, false);
									eventHierarchyChangeFolder(this, parentFolder, false);
								}
								changeType = "move";
							}
							
							this.changeFolder(this.stores[i]["tree"], changeType, changedFolder);
						}
					}
				}
			}
			break;

		case "closesharedfolder":
			// FIXME: need to check the foldertype and remove the right folder/store
			// for now, a dirty reload is done...

			this.stores = new Array();
			this.list();

			/*
			var username = action.getElementsByTagName("username");
			var foldertype = action.getElementsByTagName("foldertype");
			if (username && username[0] && username[0].firstChild){
				username = username[0].firstChild.nodeValue;
				var deleteStore = null;
				for(var i=0; i<this.stores.length; i++){
					// delete from view
					if (this.stores[i].username && this.stores[i].username == username) {
						this.stores[i].tree.deleteNode(this.stores[i].subtree_entryid, true);
						deleteStore = i;
					}
				}
				if (deleteStore!=null){
					this.stores.splice(deleteStore,1);
				}
			}
			*/
			break;
		case "error":
			var errors = action.getElementsByTagName("error")[0];
			var hresult = dhtml.getTextNode(errors.getElementsByTagName("hresult")[0],"");
			var username = dhtml.getTextNode(errors.getElementsByTagName("username")[0],"");
			var errorString = dhtml.getTextNode(errors.getElementsByTagName("message")[0],"");
			if(username.length > 0){
				webclient.settings.deleteSetting("otherstores/"+username);
			}
			if(errorString.length > 0){
				alert(errorString);
			}
			break;
	}
}

/**
 * This function is used to sort the store list
 * returns -1 when storeA must be before storeB
 * returns 1 when storeA must be after storeB
 */
hierarchymodule.prototype.sortStores = function(storeA, storeB)
{
	// sort default store always as first
	if(storeA["type"]=="default") return -1;
	if(storeB["type"]=="default") return 1;

	// sort public store always as last
	if(storeA["type"]=="public") return 1;
	if(storeB["type"]=="public") return -1;

	// sort other folders after other stores
	if(storeA["foldertype"]!="all" && storeB["foldertype"]=="all") return 1;
	if(storeA["foldertype"]=="all" && storeB["foldertype"]!="all") return -1;

	// else sort on name
	if(storeA["name"] > storeB["name"]) return 1;
	if(storeA["name"] < storeB["name"]) return -1;
	return 0;
}

hierarchymodule.prototype.isDefaultStore = function(storeid)
{
	for(var i = 0; i < this.stores.length; i++)
	{
		if (this.stores[i]["id"] == storeid){
			if (this.stores[i]["type"] && this.stores[i]["type"] == "default"){
				return true;
			}	
		}
	}
	return false;
}

hierarchymodule.prototype.isPublicStore = function(storeid)
{
	for(var i = 0; i < this.stores.length; i++)
	{
		if (this.stores[i]["id"] == storeid){
			if (this.stores[i]["type"] && this.stores[i]["type"] == "public"){
				return true;
			}	
		}
	}
	return false;
}

hierarchymodule.prototype.isSharedFolder = function(storeid)
{
	for(var i = 0; i < this.stores.length; i++)
	{
		if (this.stores[i]["id"] == storeid){
			if (this.stores[i]["type"] && this.stores[i]["type"] == "other" && this.stores[i]["foldertype"] != "all"){
				return true;
			}	
		}
	}
	return false;
}

hierarchymodule.prototype.isSharedStore = function(storeid)
{
	for(var i = 0; i < this.stores.length; i++)
	{
		if (this.stores[i]["id"] == storeid){
			if (this.stores[i]["type"] && this.stores[i]["type"] == "other"){
				return true;
			}	
		}
	}
	return false;
}

hierarchymodule.prototype.setFolder = function(folderobject)
{
	var folder = false;
	
	if(folderobject) {
		var entryid = folderobject.getElementsByTagName("entryid")[0];
		var parent_entryid = folderobject.getElementsByTagName("parent_entryid")[0];
		var display_name = folderobject.getElementsByTagName("display_name")[0];
		var subfolders = folderobject.getElementsByTagName("subfolders")[0];
		var content_count = folderobject.getElementsByTagName("content_count")[0];
		var content_unread = folderobject.getElementsByTagName("content_unread")[0];
		var container_class = folderobject.getElementsByTagName("container_class")[0];
		var access = {
			"modify": folderobject.getElementsByTagName("modify")[0],
			"read": folderobject.getElementsByTagName("read")[0],
			"delete": folderobject.getElementsByTagName("delete")[0],
			"create_hierarchy": folderobject.getElementsByTagName("create_hierarchy")[0],
			"create_contents": folderobject.getElementsByTagName("create_contents")[0]
		};
		var rights = {
			"deleteowned": folderobject.getElementsByTagName("deleteowned")[0],
			"deletedany": folderobject.getElementsByTagName("deletedany")[0]
		};
		
		
		if(entryid.firstChild && parent_entryid.firstChild) {
			folder = new Object();
			folder["entryid"] = dhtml.getTextNode(entryid, "");
			folder["parent_entryid"] = dhtml.getTextNode(parent_entryid,"");
			folder["display_name"] = dhtml.getTextNode(display_name,"");
			folder["subfolders"] = dhtml.getTextNode(subfolders,"");
			folder["content_count"] = dhtml.getTextNode(content_count, "0");
			folder["content_unread"] = dhtml.getTextNode(content_unread, "0");
			folder["container_class"] = dhtml.getTextNode(container_class,"IPF.Note");

			folder["access"] = new Object();
			folder["access"]["modify"] = dhtml.getTextNode(access["modify"], "0");
			folder["access"]["read"] = dhtml.getTextNode(access["read"], "0");
			folder["access"]["delete"] = dhtml.getTextNode(access["delete"], "0");
			folder["access"]["create_hierarchy"] = dhtml.getTextNode(access["create_hierarchy"], "0");
			folder["access"]["create_contents"] = dhtml.getTextNode(access["create_contents"], "0");

			folder["rights"] = new Object();
			folder["rights"]["deleteowned"] = dhtml.getTextNode(rights["deleteowned"], "0");
			folder["rights"]["deleteany"] = dhtml.getTextNode(rights["deleteany"], "0");

			if (folder["entryid"]==""){
				folder = false;
			}
		}
	}
	
	return folder;
}

hierarchymodule.prototype.createHierarchyList = function(load)
{
	this.deleteLoadMessage();
	
	for(var i = 0; i < this.stores.length; i++)
	{
		var store = this.stores[i];
		if(store["root"]){
			// whem this is the default store (IPM_SUBTREE) and this is the first time, make sure the folder is expanded
			if (store["root"]["entryid"] == this.defaultstore["root"]["entryid"] && typeof this.openedFolders[store["root"]["entryid"]] == "undefined"){
				this.openedFolders[store["root"]["entryid"]] = "open";
			}
	
			var tree = new Tree(this.id, this.contentElement, this.treeEvents);
			store["tree"] = tree;
			tree.createNode(store["root"]["parent_entryid"], 
							store["root"]["entryid"], 
							true, 
							store["root"]["display_name"], 
							"store folder_icon_"+store["foldertype"], 
							store["root"]["subfolders"], 
							(this.openedFolders[store["root"]["entryid"]] == "open"?true:false), 
							this.folderEvents
							);
			
			for(var j = 0; j < store["folders"].length; j++)
			{
				var folder = store["folders"][j];
				var iconClass = false;
				var dropNotAllowed = false;
				
				for(var folderType in store["defaultfolders"])
				{
					if(store["defaultfolders"][folderType] == folder["entryid"]) {
						iconClass = folderType;
						if(folderType == "syncissues" || folderType == "conflicts" || folderType == "localfailures" || folderType == "serverfailures"){
							dropNotAllowed = true;
						}
					}
				}
				
				if(!iconClass) {
					switch(folder["container_class"])
					{
						case "IPF.Appointment":
							iconClass = "calendar";
							break;
						case "IPF.Contact":
							iconClass = "contact";
							break;
						case "IPF.Task":
							iconClass = "task";
							break;
						case "IPF.StickyNote":
							iconClass = "note";
							break;
						default:
							iconClass = "mail";
							break;
					}
				}
			
				// Check to see if a counter needs to be added by the tree for either
				// unread messages or for the drafts folder the content_count.
				var folder_extra = false;
				if (store["defaultfolders"]["drafts"] == folder["entryid"]){
					if(Number(folder["content_count"]) > 0){
						folder_extra = new Object();
						folder_extra["class"] = "total_count";
						folder_extra["text"] = "["+folder["content_count"]+"]";
					}
				}else if (Number(folder["content_unread"]) > 0){
					folder_extra = new Object();
					folder_extra["class"] = "unread_count";
					folder_extra["text"] = "("+folder["content_unread"]+")";
				}
	
				tree.createNode(folder["parent_entryid"], 
								folder["entryid"], 
								false, 
								folder["display_name"], 
								iconClass, 
								folder["subfolders"], 
								(this.openedFolders[folder["entryid"]] == "open"?true:false), 
								this.folderEvents, 
								folder_extra,
								null,
								dropNotAllowed
								);
			}
			
			tree.buildTree();
		}else{
			//delete user if you have no access
			webclient.settings.deleteSetting("otherstores/"+store["username"]);
		}
	}
	
	this.selectLastFolder(load);
}

/*
 * Makes sure that the correct folder is selected. If 'load' is true,
 * also sends a signal to the maillistmodule to load that folder.
 */
hierarchymodule.prototype.selectLastFolder = function(load)
{
	var element = dhtml.getElementById(this.selectedFolder);
	if(!element) {
		var store = this.defaultstore;
		if(store) {
			element = dhtml.getElementById(store["defaultfolders"]["inbox"]);
			if (webclient.settings && webclient.settings.get("global/startup/folder","inbox")=="last"){
				element = dhtml.getElementById(webclient.settings.get("global/startup/folder_lastopened",store["defaultfolders"]["inbox"]));
				if (!element){
					element = dhtml.getElementById(store["defaultfolders"]["inbox"]);
				}
			}
		}
	}
	var folderName = element.getElementsByTagName("div")[1];
	if(folderName && load) {
		eventHierarchySelectFolder(this, folderName, false);
		eventHierarchyChangeFolder(this, folderName, false);
	} else {
		eventHierarchySelectFolder(this, folderName, false);
	}
}

hierarchymodule.prototype.changeFolder = function(treeObject, type, folder)
{
	switch(type)
	{
		case "add":
			var node = treeObject.createNode(folder["parent_entryid"], folder["entryid"], false, folder["display_name"], "mail", false, false, this.folderEvents, folder["extra"]);
			if (!treeObject.addNode(node)){
				// adding of this folder failed, reload compleet hierarchylist
				this.list(true);
				return;
			}			
			this.openedFolders[folder["parent_entryid"]] = "open";

			break;
		case "change":
			var node = treeObject.getNode(folder["entryid"]);
			
			if(node) {
				node["value"] = folder["display_name"];
				if (parseInt(node["hasChildNodes"],10)==1 && parseInt(folder["subfolders"],10)==-1){
					// no subfolders anymore, delete all subnodes first
					var nodes = treeObject.getChildren(node, true);
					for(var n=0; n<nodes.length; n++){
						treeObject.deleteNode(nodes[n].id, true);
					}					
				}
				node["hasChildNodes"] = folder["subfolders"];
				node["open"] = (this.openedFolders[folder["entryid"]] == "open")?true:false;


				// Get store object
				var folderObj = this.getFolder(folder["entryid"]);
				var store = this.getStore(folderObj["storeid"]);
				// Check to see if a counter needs to be added by the tree for either
				// unread messages or for the drafts folder the content_count.
				node["extra"] = false;
				if (store && store["defaultfolders"]["drafts"] == folder["entryid"]){
					if(Number(folder["content_count"]) > 0){
						node["extra"] = new Object();
						node["extra"]["class"] = "total_count";
						node["extra"]["text"] = "["+folder["content_count"]+"]";
					}
				}else if (Number(folder["content_unread"]) > 0){
					node["extra"] = new Object();
					node["extra"]["class"] = "unread_count";
					node["extra"]["text"] = "("+folder["content_unread"]+")";
				}
				
				treeObject.changeNode(node);
			}
			
			if(folder["entryid"] == this.selectedFolder) {
				this.setNumberItems(folder["content_count"], folder["content_unread"]);
			}
			break;
		case "move":
			var node = treeObject.getNode(folder["entryid"]);
			if(node) {
				node["parentid"] = folder["parent_entryid"];
				node["value"] = folder["display_name"];
				node["hasChildNodes"] = folder["subfolders"];
				node["open"] = false;
				
				node["extra"] = false;
				if (folder["content_unread"]>0){
					node["extra"] = new Object();
					node["extra"]["class"] = "unread_count";
					node["extra"]["text"] = "("+folder["content_unread"]+")";
				}
				treeObject.moveNode(node);
			}
			break;
	}

	// update hiearchylist to see all changes
	if(typeof dragdrop != "undefined") {
		dragdrop.updateTargets("folder");
	}
	this.setOpenedFolders();
}

hierarchymodule.prototype.list = function(reset)
{
	var data = false;
	if(reset) {
		data = "reset";
	}

	webclient.xmlrequest.addData(this, "list", data);
	this.hideSharedFolderActions();
	this.loadMessage();
}
/**
 * Function which sets the footer info "125 item(s) - (4) new".
 * @param integer totalNumberItems total number of items in the folder
 * @param integer numberNewItems total number of new items in the folder 
 */  
hierarchymodule.prototype.setNumberItems = function(totalNumberItems, numberNewItems)
{
	var numberitems = dhtml.getElementById("numberitems");
	while(numberitems.hasChildNodes())
	{
		numberitems.removeChild(numberitems.childNodes[0]);
	}

	var number = document.createElement("span");
	number.innerHTML = totalNumberItems + " " + _("items") + " <b>&#183;</b> ";
	numberitems.appendChild(number);
	
	var newItems = document.createElement("span");
	newItems.innerHTML = "(" + numberNewItems + ") " + _("new");
	numberitems.appendChild(newItems);
}

hierarchymodule.prototype.createFolder = function(name, type, parent_entryid)
{
	var folder;
	if (!parent_entryid){
		folder = this.getFolder(this.selectedContextFolder);
	} else {
		folder = this.getFolder(parent_entryid);
	}

	if(folder) {
		var data = new Object();
		data["store"] = this.folderstoreid;
		data["parententryid"] = folder["entryid"];
		data["name"] = name;
		data["type"] = type;
		
		webclient.xmlrequest.addData(this, "add", data);
	}
	
	eventHierarchyCheckSelectedContextFolder(this);
}

hierarchymodule.prototype.modifyFolder = function(name, entryid)
{
	var folder;
	if (!entryid){
		folder = this.getFolder(this.selectedContextFolder);
	} else {
		folder = this.getFolder(entryid);
	}

	if(folder) {
		var data = new Object();
		data["store"] = this.folderstoreid;
		data["entryid"] = folder["entryid"];
		data["name"] = name;
		
		webclient.xmlrequest.addData(this, "modify", data);
	}
	eventHierarchyCheckSelectedContextFolder(this);
}

hierarchymodule.prototype.deleteFolder = function(folder)
{
	if (!folder){
		folder = this.getFolder(this.selectedFolder);
	}

	if(folder) {
		if(confirm(_("Are you sure you want to delete") + " " + folder["display_name"] + '?')) {
			var data = new Object();
			data["store"] = this.folderstoreid;
			data["parententryid"] = folder["parent_entryid"];
			data["entryid"] = folder["entryid"];
			
			// delete folder settings
			var path = "folders/entryid_"+folder["entryid"];
			webclient.settings.deleteSetting(path);
			
			// send request to server(php)
			webclient.xmlrequest.addData(this, "delete", data);
		}
	}
}

hierarchymodule.prototype.emptyFolder = function(folder)
{
	if (folder) {
		if(confirm(_("Are you sure you want to empty %s?").sprintf(folder["display_name"]))) {
			var data = new Object();
			data["store"] = folder["storeid"];
			data["entryid"] = folder["entryid"];
			webclient.xmlrequest.addData(this, "emptyfolder", data);
			this.reloadListModule(folder["entryid"]);
		}
	}
}

hierarchymodule.prototype.addToFavorite = function(entryid, favoritename, flags)
{
	var data = new Object();
	data["store"] = this.folderstoreid;
	data["entryid"] = entryid;
	data["favoritename"] = favoritename;
	data["flags"] = flags;
	
	webclient.xmlrequest.addData(this, "addtofavorite", data);
}

hierarchymodule.prototype.copyFolder = function(destination_entryid, destination_storeid, type, entryid)
{	
	var folder;
	if (!entryid){
		folder = this.getFolder(this.selectedContextFolder);
	} else {
		folder = this.getFolder(entryid);
	}

	if(folder) {
		var data = new Object();
		data["store"] = this.folderstoreid;
		data["parententryid"] = folder["parent_entryid"];
		data["entryid"] = folder["entryid"];
		data["destinationentryid"] = destination_entryid;
		data["destinationstoreid"] = destination_storeid;
		
		if (type && type == "move"){
			data["movefolder"] = "1";
		}
		
		webclient.xmlrequest.addData(this, "copy", data);
	}
	
	eventHierarchyCheckSelectedContextFolder(this);
}

hierarchymodule.prototype.setReadFlags = function()
{
	var folder = this.getFolder(this.selectedContextFolder);

	if(folder) {
		var data = new Object();
		data["store"] = this.folderstoreid;
		data["entryid"] = folder["entryid"];
		
		webclient.xmlrequest.addData(this, "readflags", data);
		this.reloadListModule(folder["entryid"]);

	}
	
	eventHierarchyCheckSelectedContextFolder(this);
}

hierarchymodule.prototype.reloadListModule = function(entryid)
{
	// reload listmodule if needed
	var moduleIDs = webclient.layoutmanager.getModuleIDs();
	for(var i=0;i<moduleIDs.length;i++){
		// we only need to check ListModules
		if (webclient.getModule(moduleIDs[i]) instanceof ListModule){
			var listmodule = webclient.getModule(moduleIDs[i]);
			if (listmodule.entryid == entryid){
				listmodule.list();
			}
		}
	}
}



hierarchymodule.prototype.getStore = function(entryid)
{
	var result = false;
	for(var i = 0; i < this.stores.length; i++) {
		if (this.stores[i].id == entryid) {
			result = this.stores[i];
		}
	}
	return result;
}

hierarchymodule.prototype.getFolder = function(entryid)
{
	this.isRootFolder = false;
	this.folderIndex = false;
	this.folderstoreid = false;
	
	for(var i = 0; i < this.stores.length; i++) {
		if(this.stores[i]["root"] && this.stores[i]["root"]["entryid"] == entryid) {
			var folder = this.stores[i]["root"];
			folder["storeid"] = this.stores[i]["id"];
			this.folderstoreid = folder["storeid"];
			this.isRootFolder = true;
			return folder;
		} else {
			for(var j = 0; j < this.stores[i]["folders"].length; j++)
			{
				var folder = this.stores[i]["folders"][j];

				if(folder["entryid"] == entryid) {
					this.folderIndex = j;
					this.folderstoreid = this.stores[i]["id"];
					folder["storeid"] = this.folderstoreid;
					return folder;
				}
			}
		}
	}
	
	return false;
}

hierarchymodule.prototype.isDefaultFolder = function(entryid)
{
	var isDefaultFolder = false;
	
	for(var i = 0; i < this.stores.length; i++) {
		if(this.stores[i]["root"]["entryid"] == entryid) {
			isDefaultFolder = true;
		} else {
			for(var folder in this.stores[i]["defaultfolders"])
			{
				if(this.stores[i]["defaultfolders"][folder] == entryid) {
					isDefaultFolder = true;
				}
			}
		}
	}
	
	return isDefaultFolder;
}

hierarchymodule.prototype.isSpecialFolder = function(type, entryid) 
{
	var result = false;
	
	for(var i = 0; i < this.stores.length; i++) {
		if (this.stores[i]["defaultfolders"][type] && this.stores[i]["defaultfolders"][type] == entryid) {
			result = true;
		}
	}
	return result;
}

hierarchymodule.prototype.setOpenedFolders = function()
{
	var data = "";
	if (webclient.settings){
		for(var entryid in this.openedFolders){
			if (this.openedFolders[entryid]=="open"){
				webclient.settings.set("folders/entryid_"+entryid+"/is_open", 1);
			}else{
				webclient.settings.set("folders/entryid_"+entryid+"/is_open", 0);
			}
		}
	}
}

/**
* This function checks if the give folder is a parent in some way of the selected folder
*/
hierarchymodule.prototype.isParentOfSelected = function(parentFolder)
{
	var result = false;

	// first check if parentFolder has childs
	if (parentFolder["subfolders"] != -1){
		var childFolder = this.getFolder(this.selectedFolder);

		// check if parentFolder is on the same store
		if (parentFolder["storeid"] == childFolder["storeid"]){

			// check if selectedFolder is a direct child
			if (childFolder["parent_entryid"] == parentFolder["entryid"]){
				result = true;
			}else{
				// loop trough parents
				var folder = this.getFolder(childFolder["parent_entryid"]);
				while(folder && folder["entryid"]!=parentFolder["entryid"] && !this.isPublicStore(folder["storeid"])){
					folder = this.getFolder(folder["parent_entryid"]);
				}
				
				// final check
				if (folder && folder["entryid"]==parentFolder["entryid"]){
					result = true;
				}
			}		
		}
	}
	return result;
}

hierarchymodule.prototype.getOpenedFolders = function()
{
	var data = webclient.settings.get("folders");
	for (var id in data){
		var entryid = id.substring(8);
		if (webclient.settings.get("folders/"+id+"/is_open", 0) == 1){
			this.openedFolders[entryid] = "open";
		}else{
			this.openedFolders[entryid] = "closed";
		}
	}
}

hierarchymodule.prototype.resize = function()
{
	var height = this.element.offsetHeight - this.sharedFoldersElement.clientHeight - this.contentElement.offsetTop - 4;
	if(height < 3) {
		height = 3;
	}
	
	this.contentElement.style.height = height + "px";
}

hierarchymodule.prototype.hideSharedFolderActions = function()
{
	this.sharedFoldersElement.style.display = "none";
}

hierarchymodule.prototype.showSharedFolderActions = function()
{
	this.sharedFoldersElement.style.display = "block";
	this.resize(); // TODO: via LayoutManager
}

hierarchymodule.prototype.openSharedFolder = function(username, foldertype)
{
	if (typeof foldertype == "undefined"){
		foldertype = "all";
	}

	if (username == webclient.username){
		alert(_("This shared folder is your own folder."));
		return false;
	}
	
	var otherstores = webclient.settings.get("otherstores");
	if (otherstores) {
		for(var other_user in otherstores)
		{
			if (other_user == username && otherstores[other_user][foldertype]){
				alert(_("This shared folder is already open."));
				return false;
			}
		}
	}

	webclient.settings.set("otherstores/"+username+"/"+foldertype, foldertype);

	var data = new Object();
	data["username"] = username;
	data["foldertype"] = foldertype;
	webclient.xmlrequest.addData(this, "opensharedfolder", data);
	
	return true;
}

hierarchymodule.prototype.closeSharedFolder = function(username, foldertype)
{
	if (typeof foldertype == "undefined"){
		foldertype = "all";
	}

	var folderfound = webclient.settings.get("otherstores/"+username+"/"+foldertype, null);

	if (folderfound != null){
		webclient.settings.deleteSetting("otherstores/"+username+"/"+foldertype);
	
		// send delete to server
		var data = new Object();
		data["username"] = username;
		data["foldertype"] = foldertype;
		webclient.xmlrequest.addData(this, "closesharedfolder", data);
	}
}

function eventHierarchyCheckSelectedContextFolder(moduleObject, element, event)
{
	if(moduleObject.selectedContextFolder) {
		var folder = dhtml.getElementById(moduleObject.selectedContextFolder);

		if(folder) {
			var folderIcon = folder.getElementsByTagName("div")[1];
			var folderName = folderIcon.getElementsByTagName("span")[0];
			if(folderName.className.indexOf("folder_title_context") > 0) {
				folderName.className = folderName.className.substring(0, folderName.className.indexOf("folder_title_context"));
			}
		}
	}
}

function eventHierarchySelectFolder(moduleObject, element, event)
{
	if(!event) {
		event = new Object();
	}

	if(event.button == 0 || event.button == 1 || !event.button) {
		if(moduleObject.selectedFolder) {
			var folder = dhtml.getElementById(moduleObject.selectedFolder);
			if(folder) {
				var folderIcon = folder.getElementsByTagName("div")[1];
				var folderName = folderIcon.getElementsByTagName("span")[0];
				dhtml.removeClassName(folderName, "folder_title_selected");
				dhtml.addClassName(folderName, "folder_title");
			}
		}
		moduleObject.selectedFolder = element.parentNode.id;
		var folderName = element.getElementsByTagName("span")[0];
		dhtml.removeClassName(folderName, "folder_title");
		dhtml.addClassName(folderName, "folder_title_selected");
	}
}

function eventHierarchyShowBranch(moduleObject, element, event)
{
	var objBranch = dhtml.getElementById("branch" + element.parentNode.id).style;
	var display = "block";
	var state = "open";

	if(objBranch.display == "block") {
		display = "none";
		state = "closed";
	}
	
	objBranch.display = display;

	if(moduleObject.openedFolders) {
		moduleObject.openedFolders[element.parentNode.id] = state;
	}
	
	if(typeof dragdrop != "undefined") {
		dragdrop.updateTargets("folder");
	}
	
	moduleObject.setOpenedFolders();

	var folder = moduleObject.getFolder(element.parentNode.id);
	if (moduleObject.isParentOfSelected(folder)){
		var folderElement = element.parentNode.getElementsByTagName("div")[1];
		dhtml.executeEvent(folderElement, "mousedown");
		dhtml.executeEvent(folderElement, "mouseup");
	}
}

function eventHierarchyChangeFolder(moduleObject, element, event)
{
	if(!event) {
		event = new Object();
	}
	
	if(event.button == 0 || event.button == 1 || !event.button) {
		var storeid = false;
		if(moduleObject.defaultstore) {
			storeid = moduleObject.defaultstore["id"];
		}
	
		var folder = moduleObject.getFolder(element.parentNode.id);
	
		if(folder) {
			var data = new Object();
			var storeid = moduleObject.folderstoreid;
			
			moduleObject.setNumberItems(folder["content_count"], folder["content_unread"]);
			moduleObject.sendEvent("changefolder", storeid, folder);
		}
	}
}

function eventHierarchyContextMenu(moduleObject, element, event)
{
	if(moduleObject.selectedContextFolder) {
		var folder = dhtml.getElementById(moduleObject.selectedContextFolder);

		if(folder) {
			var folderIcon = folder.getElementsByTagName("div")[1];
			var folderName = folderIcon.getElementsByTagName("span")[0];
			folderName.className = folderName.className.substring(0, folderName.className.indexOf("folder_title_context"));
		}
	}
	
	var folder = moduleObject.getFolder(element.parentNode.id);
	
	if(folder) {
		var items = new Array();
		if (!moduleObject.isRootFolder) {
			items.push(webclient.menu.createMenuItem("open", _("Open"), false, eventHierarchyOpenFolder));
			items.push(webclient.menu.createMenuItem("seperator", ""));
			if(!moduleObject.isDefaultFolder(folder["entryid"])) {
				items.push(webclient.menu.createMenuItem("copy", _("Copy/Move Folder"), false, eventHierarchyCopyFolder));
				items.push(webclient.menu.createMenuItem("renamefolder", _("Rename Folder"), false, eventHierarchyModifyFolder));
			}
		}	
		if (!moduleObject.isSharedFolder(folder["storeid"]))
    		items.push(webclient.menu.createMenuItem("newfolder", _("New Folder"), false, eventHierarchyNewFolder));
		items.push(webclient.menu.createMenuItem("seperator", ""));
		if (!moduleObject.isRootFolder) {
			items.push(webclient.menu.createMenuItem("markread", _("Mark All Messages Read"), false, eventHierarchyMarkMessagesRead));
	
			if(!moduleObject.isDefaultFolder(folder["entryid"])) {
				items.push(webclient.menu.createMenuItem("seperator", ""));
				items.push(webclient.menu.createMenuItem("deletefolder", _("Delete Folder"), false, eventHierarchyDeleteFolder));
			}
			if(moduleObject.isSpecialFolder("wastebasket", folder["entryid"]) || moduleObject.isSpecialFolder("junk", folder["entryid"])) {
				items.push(webclient.menu.createMenuItem("emptyfolder", _("Empty folder"), false, eventHierarchyEmptyFolder));
			}
			/**
			 * The check on the entryid (if it starts with 00000001) is used 
			 * because a folder that has been added as favorites folder will 
			 * have a flag at the start of the entryid. 
			 */
			if(moduleObject.isPublicStore(folder["storeid"]) && folder["entryid"].substr(0, 8) != "00000001" && !moduleObject.isFavoritesFolder(folder["entryid"])) {
				items.push(webclient.menu.createMenuItem("seperator", ""));
				items.push(webclient.menu.createMenuItem("addtofavorite", _("Add to favorites folder"), false, eventHierarchyAddToFavoriteFolder));
			}
	
			items.push(webclient.menu.createMenuItem("seperator", ""));
		} else {

			if (moduleObject.isSharedStore(folder["storeid"])){
				items.push(webclient.menu.createMenuItem("closestore", _("Close store"), false, eventHierarchyCloseStore));
				items.push(webclient.menu.createMenuItem("seperator", ""));
			}
		}
		if (moduleObject.isDefaultStore(folder.storeid) && moduleObject.isRootFolder){
			items.push(webclient.menu.createMenuItem("reload", _("Reload"), false, eventHierarchyReload));
		}
		items.push(webclient.menu.createMenuItem("properties", _("Properties"), false, eventHierarchyPropertiesFolder));

		webclient.menu.buildContextMenu(moduleObject.id, folder["entryid"], items, event.clientX, event.clientY);
	}
	
	moduleObject.selectedContextFolder = folder["entryid"];
	var span = element.getElementsByTagName("span")[0];	
	span.className += " folder_title_context";
	
	return false;
}

function eventHierarchyOpenFolder(moduleObject, element, event)
{
	var entryid = element.parentNode.elementid;
	if(entryid) {
		var folder = dhtml.getElementById(entryid);
		var folderName = folder.getElementsByTagName("div")[1];
		if(folderName) {
			dhtml.executeEvent(folderName, "mousedown");
			dhtml.executeEvent(folderName, "mouseup");
		}
		
		element.parentNode.style.display = "none";
	}
}

function eventHierarchyCopyFolder(moduleObject, element, event)
{
	element.parentNode.style.display = "none";
	var folder = moduleObject.getFolder(moduleObject.selectedContextFolder);
	webclient.openModalDialog(moduleObject, "copyfolder", DIALOG_URL+"task=copyfolder_modal&source_entryid="+folder.entryid, 300, 400);
}

function eventHierarchyNewFolder(moduleObject, element, event)
{
	element.parentNode.style.display = "none";
	var folder = moduleObject.getFolder(moduleObject.selectedContextFolder);
	webclient.openModalDialog(moduleObject, "newfolder", DIALOG_URL+"task=createfolder_modal&parent_entryid="+folder.entryid, 300, 420);
}

function eventHierarchyModifyFolder(moduleObject, element, event)
{
	element.parentNode.style.display = "none";
	var folder = moduleObject.getFolder(moduleObject.selectedContextFolder);
	webclient.openModalDialog(moduleObject, "modifyfolder", DIALOG_URL+"task=modifyfolder_modal&entryid="+folder.entryid, 300, 150);
}

function eventHierarchyMarkMessagesRead(moduleObject, element, event)
{
	element.parentNode.style.display = "none";
	storeOldSelectedEmailEntryId();
	moduleObject.setReadFlags();
}

function eventHierarchyDeleteFolder(moduleObject, element, event)
{
	element.parentNode.style.display = "none";
	var folder = moduleObject.getFolder(moduleObject.selectedContextFolder);
	moduleObject.deleteFolder(folder);
}
function eventHierarchyPropertiesFolder(moduleObject, element, event)
{
	element.parentNode.style.display = "none";
	var folder = moduleObject.getFolder(moduleObject.selectedContextFolder);
	var disable_permissions = 0;
	if(moduleObject.isPublicStore(folder["storeid"])) {
		// disable permissions tab for public root folder & favorites folder
		if(moduleObject.isFavoritesFolder(folder["entryid"]) || moduleObject.isRootFolder) {
			disable_permissions = 1;
		}
	}
	webclient.openWindow(moduleObject, "properties", DIALOG_URL+"task=properties_standard&entryid="+folder.entryid+"&storeid="+folder.storeid+"&disable_permissions=" + disable_permissions, 425, 450);
}

function eventSharedFoldersClick(moduleObject, element, event)
{
	webclient.openModalDialog(moduleObject, "sharedfolder", DIALOG_URL+"task=sharedfolder_modal&storeid="+moduleObject.defaultstore["id"], 285, 200, callBackSharedFolder, this);
}

function eventAdvancedCalendarClick(moduleObject, element, event)
{
	// Delete the datepicker module when it has been loaded
	if (webclient.datepicker){
		webclient.deleteModule(webclient.datepicker);
		webclient.datepicker = null;
		dragdrop.updateTargets("folder");
	}
	webclient.loadModule("multiusercalendarmodule", "MultiUserCalendar", "main", null, BORDER_LAYOUT);
}

function callBackSharedFolder(result, module)
{
    return module.openSharedFolder(result.username, result.folder);
}

function eventHierarchyCloseStore(moduleObject, element, event)
{
	element.parentNode.style.display = "none";
	var folder = moduleObject.getFolder(moduleObject.selectedContextFolder);
	var username = moduleObject.getStore(folder.storeid).username;
	var foldertype = moduleObject.getStore(folder.storeid).foldertype;
	moduleObject.closeSharedFolder(username, foldertype);
}

function eventHierarchyEmptyFolder(moduleObject, element, event)
{
	element.parentNode.style.display = "none";
	var folder = moduleObject.getFolder(moduleObject.selectedContextFolder);
	moduleObject.emptyFolder(folder);
}

function eventHierarchyReload(moduleObject, element, event)
{
	element.parentNode.style.display = "none";
	moduleObject.list();
}

function eventHierarchyAddToFavoriteFolder(moduleObject, element, event)
{
	element.parentNode.style.display = "none";
	var folder = moduleObject.getFolder(moduleObject.selectedContextFolder);
	webclient.openModalDialog(moduleObject, "addtofavorite", DIALOG_URL+"task=addtofavorite_modal&foldername="+folder.display_name+"&entryid="+folder.entryid, 300, 320);
}
/**
 * Function which check whether entryID is of Favorites folder.
 * @param string entryID -entry id of folder to check for.
 * @return boolean -returns true it is Favorites Folder, false if not Favorites Folder.
 */
hierarchymodule.prototype.isFavoritesFolder = function(entryID)
{
	var result = false;
	for (var i in this.stores){
		// Check if store is public
		if (this.stores[i]["type"] == "public"){
			if (entryID == this.stores[i]["defaultfolders"]["favorites"]) result = true;
		}
	}
	
	return result;
}
