<?php
	/**
	* Function to retrieve a $_GET variable to prevent XSS
	*
	* $var = varibale requested
	* $default = default result when $var doesn't exist
	* $usequote = if $var must be surrounded by quotes, note that $default isn't surrounded by quotes even if this is set here!
	*/	
	function get($var, $default="", $usequote=false){
		$result = $default;
		if (isset($_GET[$var])){
			$result = addslashes($_GET[$var]);
			if ($usequote===true) 
				$usequote = "'";
			if ($usequote!==false)
				$result = $usequote.$result.$usequote;
		}
		return $result;
	}


	function createConfirmButtons($onclick)
	{
		$buttons = "<div class=\"confirmbuttons\">\n";
		$buttons .= "<input class=\"buttonsize\" type=\"button\" value=\"" . _("Ok") . "\" onclick=\"" . $onclick . "\">\n";
		$buttons .= "<input class=\"buttonsize\" type=\"button\" value=\"". _("Cancel") . "\" onclick=\"window.close();\">\n";
		$buttons .= "</div>\n";
		
		return $buttons;
	}
	
	function createCloseButton($onclick)
	{
		$buttons = "<div class=\"closebutton\">\n";
		$buttons .= "<input class=\"buttonsize\" type=\"button\" value=\"" . _("Close") . "\" onclick=\"" . $onclick . "\">\n";
		$buttons .= "</div>\n";
		
		return $buttons;
	}
	
	/**
	* Function to get some buttons
	*
	* one button is specified as an array argument, use multiple arguments for more buttons
	*
	* array("title"=>"Ok", "handler"=>"submit();", "shortcut"=>"S")
	*/	
	function createButtons()
	{
		$argc = func_num_args();
		$argv = func_get_args();
		
		$buttons = "<div class=\"buttons\">\n";
		for($i=0; $i<$argc; $i++){
			$title   = isset($argv[$i]["title"])   ? $argv[$i]["title"]   : _("Button");
			$handler = isset($argv[$i]["handler"]) ? $argv[$i]["handler"] : "alert('Not implemented');";
			$shortcut= isset($argv[$i]["shortcut"])? " accesskey=\"".$argv[$i]["shortcut"]."\"": "";

			
			$buttons .= "<input class=\"buttonsize\" type=\"button\" value=\"" . $title . "\" onclick=\"" . $handler . "\"".$shortcut.">\n";
		}
		$buttons .= "</div>\n";
		
		return $buttons;
	}
?>
