<?php

function getDialogTitle(){
	return _("Copy/Move messages");
}


function getIncludes(){
	return array(
			"client/widgets/tree.js",
			"client/layout/css/tree.css",
			"client/modules/hierarchymodule.js",
			"client/modules/".getModuleName().".js"
		);
}

function getModuleName(){
	return "hierarchyselectmodule";
}

function getJavaScript_onload(){ ?>
					var elem = dhtml.getElementById("targetfolder");
					module.init(moduleID, elem);
					module.list();
					var dialogname = window.name;

					if(!dialogname) {
						dialogname = window.dialogArguments.dialogName;
					}

					parentModule = parentWebclient.dialogs[dialogname]["module"];
					
					var text;
					if (parentModule.selectedMessages.length>1){
						text = "<?=_("There are %s messages selected")?>";
					} else {
						text = "<?=_("There is one message selected")?>";
					}	
					text += ".";
					text = text.sprintf(parentModule.selectedMessages.length);
					var subtitle = dhtml.getElementById("subtitle");
					dhtml.deleteAllChildren(subtitle);
					subtitle.appendChild(document.createTextNode(text));
					
<?php } // getJavaSctipt_onload	

function getJavaScript_other(){ ?>
			var source_entryid = "<?=get("source_entryid","none", false)?>";
			var parent_entryid;
			var parentModule;
			
			function submit(type)
			{
				if (!type) type = "copy";
				
				var target_entryid = module.selectedFolder;
                var target_store = module.selectedFolderStoreId;
                
				parentModule.copyMessages(target_store, target_entryid, type, false);
				
				window.close();
			}
<?php }

function getBody(){
?>
		<dl id="copymovemessages" class="folderdialog">
			<dt><?=_("Copy/move selected messages to")?>:</dt>
			<dd id="targetfolder" class="dialog_hierarchy" onmousedown="return false;"></dd>

			<dd><span id="sourcemessages"></span></dd>
		</dl>

	<?=createButtons(array("title"=>_("Copy"),"handler"=>"submit('copy');"), array("title"=>_("Move"),"handler"=>"submit('move');"), array("title"=>_("Cancel"),"handler"=>"window.close();"))?>

<?
}
?>
