'\"
'\" Generated from file '/usr/ports/obj/tcllib-1.11.1/tcllib-1.11.1/modules/nns/nns_auto.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2007-2008 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "nameserv::auto" n 0.3 nns "Name service facility"
.BS
.SH NAME
nameserv::auto \- Name service facility, Client Extension
.SH SYNOPSIS
package require \fBTcl  8.4\fR
.sp
package require \fBnameserv::auto  ?0.3?\fR
.sp
package require \fBnameserv \fR
.sp
.BE
.SH DESCRIPTION
Please read the document \fIName service facility, introduction\fR
first.
.PP
This package provides the \fIexact\fR same API as is provided by
package \fBnameserv\fR, i.e the regular name service client. It
differs from the former by taking measures to ensure that longer-lived
data, i.e. bound names, continuous and unfulfilled async searches,
survive the loss of the connection to the name server as much as is
possible.
.PP
This means that the bound names and continuous and unfulfilled async
searches are remembered client-side and automatically re-entered into
the server when the connection comes back after its loss. For bound
names there is one important limitation to such restoration: It is
possible that a name of this client was bound by a different client
while the connection was gone. Such names are fully lost, and the best
the package can and will do is to inform the user of this.
.SH API
The user-visible API is mainly identical the API of \fBnameserv\fR
and is therefore not described here. Please read the documentation of
\fBnameserv\fR.
.PP
The differences are explained in the sections \fBOPTIONS\fR and
\fBEVENTS\fR.
.SH OPTIONS
This package supports all the option of package \fBnameserv\fR,
and one more. The additional option allows the user to specifies the
time interval between attempts to restore a lost connection.
.TP
\fB-delay\fR \fImilliseconds\fR
The value of this option is an integer value > 0 which specifies the
interval to wait between attempts to restore a lost connection, in
milliseconds. The default value is \fB1000\fR, i.e. one second.
.PP
.SH EVENTS
This package generates all of the events of package \fBnameserv\fR,
and two more. Both events are generated for the tag \fInameserv\fR.
.TP
\fIlost-name\fR
This event is generated when a bound name is truly lost, i.e. could
not be restored after the temporary loss of the connection to the name
server. It indicates that a different client took ownership of the
name while this client was out of contact.
.sp
The detail information of the event will be a Tcl dictionary
containing two keys, \fBname\fR, and \fBdata\fR. Their values hold
all the information about the lost name.
.TP
\fIre-connection\fR
This event is generated when the connection to the server is
restored. The remembered data has been restored when the event is
posted.
.sp
The event has no detail information.
.PP
.SH DESIGN
The package is implemented on top of the regular nameservice client,
i.e.  package \fBnameserv\fR. It detects the loss of the
connection by listening for \fIlost-connection\fR events, on the tag
\fInameserv\fR.
.PP
It reacts to such events by starting a periodic timer and trying to
reconnect to the server whenver this timer triggers. On success the
timer is canceled, a \fIre-connection\fR event generated, and the
package proceeds to re-enter the remembered bound names and continous
searches.
.PP
Another loss of the connection, be it during or after re-entering the
remembered information simply restarts the timer and subsequent
reconnection attempts.
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fInameserv\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH "SEE ALSO"
nameserv(n)
.SH KEYWORDS
automatic, client, name service, reconnect, restore
.SH COPYRIGHT
.nf
Copyright (c) 2007-2008 Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi