'\"
'\" Generated from file '/usr/ports/obj/tcllib-1.11.1/tcllib-1.11.1/modules/cache/async.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2008 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "cache::async" n 0.3 cache "In-memory caches"
.BS
.SH NAME
cache::async \- Asynchronous in-memory cache
.SH SYNOPSIS
package require \fBTcl  8.4\fR
.sp
package require \fBcache::async  ?0.3?\fR
.sp
\fB::cache::async\fR \fIobjectName\fR \fIcommandprefix\fR ?\fIoptions\fR...?
.sp
\fIobjectName\fR \fBget\fR \fIkey\fR \fIdonecmdprefix\fR
.sp
\fIobjectName\fR \fBset\fR \fIkey\fR \fIvalue\fR
.sp
\fIobjectName\fR \fBunset\fR \fIkey\fR
.sp
\fIobjectName\fR \fBexists\fR \fIkey\fR
.sp
\fIobjectName\fR \fBclear\fR ?\fIkey\fR?
.sp
.BE
.SH DESCRIPTION
This package provides objects which cache data in memory, and operate
asynchronously with regard to request and responses. The objects are
agnostic with regard to cache keys and values, and unknown methods are
delegated to the provider of cached data. These two properties make it
easy to use caches as a facade for any data provider.
.SH API
The package exports a class, \fBcache::async\fR, as specified
below.
.TP
\fB::cache::async\fR \fIobjectName\fR \fIcommandprefix\fR ?\fIoptions\fR...?
The command creates a new \fIcache\fR object with an associated
global Tcl command whose name is \fIobjectName\fR.  This command may
be used to invoke various operations on the object.
.sp
The \fIcommandprefix\fR is the action to perform when an user asks for
data in the cache and the cache doesn't yet know about the key. When
run the commandprefix is given three additional arguments, the string
\fBget\fR, the key requested, and the cache object itself, in the
form of its object command, in this order. The execution of the action
is done in an idle-handler, decoupling it from the original request.
.sp
The only supported option is
.RS
.TP
\fB-full-async-results\fR
This option defines the behaviour of the cache for when requested keys
are known to the cache at the time of \fBget\fR request. By default
such requeste are responded to asynchronously as well. Setting this
option to \fBfalse\fR forces the cache to respond to them
synchronuously, although still through the specified callback.
.RE
.PP
The object commands created by the class commands above have
the form:
.TP
\fIobjectName\fR \fBget\fR \fIkey\fR \fIdonecmdprefix\fR
This method requests the data for the \fIkey\fR from the cache. If the
data is not yet known the command prefix specified during construction
of the cache object is used to ask for this information.
.sp
Whenever the information is/becomes available the \fIdonecmdprefix\fR
will be run to transfer the result to the caller. This command prefix
is invoked with either 2 or 3 arguments, i.e.
.RS
.IP [1]
The string \fBset\fR, the \fIkey\fR, and the value.
.IP [2]
The string \fBunset\fR, and the \fIkey\fR.
.RE
These two possibilities are used to either signal the value for the
\fIkey\fR, or that the \fIkey\fR has no value defined for it. The
latter is distinct from the cache not knowing about the \fIkey\fR.
.sp
For a cache object configured to be fully asynchronous (default) the
\fIdonecmdprefix\fR is always run in an idle-handler, decoupling it
from the request. Otherwise the callback will be invoked synchronously
when the \fIkey\fR is known to the cache at the time of the
invokation.
.sp
Another important part of the cache's behaviour, as it is asynchronous
it is possible that multiple \fBget\fR requests are issued for the
same \fIkey\fR before it can respond. In that case the cache will
issue only one data request to the provider, for the first of these,
and suspend the others, and then notify all of them when the data
becomes available.
.TP
\fIobjectName\fR \fBset\fR \fIkey\fR \fIvalue\fR
.TP
\fIobjectName\fR \fBunset\fR \fIkey\fR
These two methods are provided to allow users of the cache to make
keys known to the cache, as either having a \fIvalue\fR, or as
undefined.
.sp
It is expected that the data provider (see \fIcommandprefix\fR of the
constructor) uses them in response to data requests for unknown keys.
.sp
Note how this matches the cache's own API towards its caller, calling
the \fIdonecmd\fR of \fBget\fR-requests issued to itself with
either "set key value" or "unset key", versus issuing
\fBget\fR-requests to its own provider with itself in the place of
the \fIdonecmd\fR, expecting to be called with either "set key value"
or "unset key".
.sp
This also means that these methods invoke the \fIdonecmd\fR of all
\fBget\fR-requests waiting for information about the modified
\fIkey\fR.
.TP
\fIobjectName\fR \fBexists\fR \fIkey\fR
This method queries the cache for knowledge about the \fIkey\fR and
returns a boolean value. The result is \fBtrue\fR if the key is
known, and \fBfalse\fR otherwise.
.TP
\fIobjectName\fR \fBclear\fR ?\fIkey\fR?
This method resets the state of either the specified \fIkey\fR or of
all keys known to the cache, making it unkown. This forces future
\fBget\fR-requests to reload the information from the provider.
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIcache\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
asynchronous, cache, callback, synchronous
.SH COPYRIGHT
.nf
Copyright (c) 2008 Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi