/*
 * Copyright (C) 2005 - 2008  Zarafa B.V.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of the Program
 * under the AGPL does not imply a trademark license. Therefore any rights,
 * title and interest in our trademarks remain entirely with us.
 * However, if you propagate an unmodified version of the Program you are 
 * required to use the term "Zarafa" to indicate that you distribute the 
 * Program. Furthermore you may use our trademarks where it is necessary to 
 * indicate the intended purpose of a product or service provided you use it in 
 * accordance with honest practices in industrial or commercial matters.
 * If you want to propagate modified versions of the Program under the name
 * "Zarafa" or "Zarafa Server", you may only do so if you have a written
 * permission by Zarafa B.V. (to acquire a permission please contact Zarafa at
 * trademark@zarafa.com).
 * The user interface of the software displays a attribution notice containing
 * the term "Zarafa" and/or the Logo of Zarafa. You have to preserve these
 * attribution notices when you propagate unmodified or modified versions of
 * the Program.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef _STRINGUTIL_H
#define _STRINGUTIL_H

#include "platform.h"
#include <string>
#include <vector>
#include <algorithm>

static inline std::string strToUpper(std::string f) {
	transform(f.begin(), f.end(), f.begin(), ::toupper);
	return f;
}

static inline std::string strToLower(std::string f) {
	transform(f.begin(), f.end(), f.begin(), ::tolower);
	return f;
}

// Use casting if passing hard coded values.
std::string stringify(unsigned int x, bool usehex = false);
std::string stringify_int64(long long x, bool usehex = false);
std::string stringify_float(float x);
std::string stringify_double(double x, int prec = 18);
std::string stringify_datetime(time_t x);

inline unsigned int	atoui(char *szString) { return strtoul(szString, NULL, 10); }

char* stristr(char *haystack, char *needle);

int memsubstr(const void* haystack, size_t haystackSize, const void* needle, size_t needleSize);

std::string striconv(std::string strinput, const char *lpszFromCharset, const char *lpszToCharset);

std::string str_storage(unsigned long long ulBytes, bool bUnlimited = true);

std::string PrettyIP(long unsigned int ip);

static inline bool parseBool(std::string s) {
	return !(s == "0" || s == "false" || s == "no");
}

void strMakeUnicode(const char *lpszA, WCHAR **lpszW);

std::vector<std::string> tokenize(const char *input, const char sep);
std::vector<std::string> tokenize(std::string strInput, std::string strSep);

#endif
