/*
 * Copyright (C) 2005 - 2008  Zarafa B.V.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of the Program
 * under the AGPL does not imply a trademark license. Therefore any rights,
 * title and interest in our trademarks remain entirely with us.
 * However, if you propagate an unmodified version of the Program you are 
 * required to use the term "Zarafa" to indicate that you distribute the 
 * Program. Furthermore you may use our trademarks where it is necessary to 
 * indicate the intended purpose of a product or service provided you use it in 
 * accordance with honest practices in industrial or commercial matters.
 * If you want to propagate modified versions of the Program under the name
 * "Zarafa" or "Zarafa Server", you may only do so if you have a written
 * permission by Zarafa B.V. (to acquire a permission please contact Zarafa at
 * trademark@zarafa.com).
 * The user interface of the software displays a attribution notice containing
 * the term "Zarafa" and/or the Logo of Zarafa. You have to preserve these
 * attribution notices when you propagate unmodified or modified versions of
 * the Program.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef UTIL_H
#define UTIL_H

#include "edkmdb.h"
#include <string>

class Util {
public:
	static std::string GetServerNameFromPath(const char *szPath);
	static std::string GetServerPortFromPath(const char *szPath);
	static std::string GetServerTypeFromPath(const char *szPath);
	static std::string ServerNamePortToURL(const char *lpszType, const char *lpszServerName, const char *lpszServerPort);

	static HRESULT	HrAddToPropertyArray(LPSPropValue lpSrc, ULONG cValues, LPSPropValue lpAdd, LPSPropValue *lppDest, ULONG *cDestValues);
	static HRESULT	HrMergePropertyArrays(LPSPropValue lpSrc, ULONG cValues, LPSPropValue lpAdds, ULONG cAddValues, LPSPropValue *lppDest, ULONG *cDestValues);

	static HRESULT	HrCopyPropertyArray(LPSPropValue lpSrc, ULONG cValues, LPSPropValue *lppDest, ULONG *cDestValues, bool bExcludeErrors = false);
	static HRESULT	HrCopyPropertyArrayByRef(LPSPropValue lpSrc, ULONG cValues, LPSPropValue *lppDest, ULONG *cDestValues, bool bExcludeErrors = false);
	static HRESULT	HrCopyPropertyArray(LPSPropValue lpSrc, ULONG cValues, LPSPropValue lpDest, void *lpBase);
	static HRESULT	HrCopyProperty(LPSPropValue lpDest, LPSPropValue lpSrc, void *lpBase, ALLOCATEMORE * lpfAllocMore = NULL);
	static HRESULT	HrCopyPropertyByRef(LPSPropValue lpDest, LPSPropValue lpSrc);
	static HRESULT	HrCopySRestriction(LPSRestriction lpDest, LPSRestriction lpSrc, void *lpBase);
	static HRESULT  HrCopySRestriction(LPSRestriction *lppDest, LPSRestriction lpSrc);
	static HRESULT	HrCopyActions(ACTIONS *lpDest, ACTIONS *lpSrc, void *lpBase);
	static HRESULT	HrCopyAction(ACTION *lpDest, ACTION *lpSrc, void *lpBase);
	static HRESULT	HrCopySRowSet(LPSRowSet lpDest, LPSRowSet lpSrc, void *lpBase);
	static HRESULT	HrCopySRow(LPSRow lpDest, LPSRow lpSrc);

	static HRESULT	HrCopyEntryId(ULONG ulSize, LPENTRYID lpSrc, ULONG *lpulDestSize, LPENTRYID* lppDest);

	static HRESULT	CompareProp(LPSPropValue lpProp1, LPSPropValue lpProp2, int* lpCompareResult);
	static unsigned int PropSize(LPSPropValue lpProp);

	static HRESULT	HrTextToRtf(IStream *text, IStream *rtf);
	static HRESULT	HrHTMLToText(char *lpBuffer);
	static LONG		HrFindPropInArray(LPSPropTagArray lpPropTags, ULONG ulPropTag);

	static char CharFromHtmlEntity(const std::string &strEntity);
	static std::string HtmlEntityFromChar(unsigned char c);

	static HRESULT	HrTextToHtml(IStream *text, IStream *html);
	static HRESULT	HrHtmlToText(IStream *html, IStream *text);
	static HRESULT	HrHtmlToRtf(IStream *html, IStream *rtf, unsigned int ulCodepage);
	static HRESULT	HrHtmlToRtf(std::string& strHTML, std::string& strRTF, unsigned int ulCodepage);

	static char*	HrMAPIErrorToText(HRESULT hr);

	static bool ValidatePropTagArray(LPSPropTagArray lpPropTagArray);

	static HRESULT HrConvertUnicodeToString8(ULONG cValues, LPSPropValue lpPropArrayIn, LPSPropValue* lppPropArrayOut);

	static std::string bin2hex(ULONG inLength, LPBYTE input);
	static HRESULT bin2hex(ULONG inLength, LPBYTE input, char **output, void *parent = NULL);
	static HRESULT hex2bin(char *input, size_t len, ULONG *outLength, LPBYTE *output, void *parent = NULL);
	static HRESULT hex2bin(std::string input, std::string *output);

	static void BufferLFtoCRLF(size_t size, const char *input, char *output, size_t *outsize);

	static bool	StrCaseCompare(std::string& strInput, std::string strFind, size_t pos = 0); 

private:
	static unsigned char x2b(char c);	// hex2bin helper
	
};

#define RTF_TAG_TYPE_TEXT	0x0000
#define RTF_TAG_TYPE_HTML	0x0010
#define RTF_TAG_TYPE_HEAD	0x0020
#define RTF_TAG_TYPE_BODY	0x0030
#define RTF_TAG_TYPE_P		0x0040
#define RTF_TAG_TYPE_STARTP	0x0050
#define RTF_TAG_TYPE_ENDP	0x0060
#define RTF_TAG_TYPE_BR		0x0070
#define RTF_TAG_TYPE_PRE	0x0080
#define RTF_TAG_TYPE_FONT	0x0090
#define RTF_TAG_TYPE_HEADER	0x00A0
#define RTF_TAG_TYPE_TITLE	0x00B0
#define RTF_TAG_TYPE_PLAIN	0x00C0
#define RTF_TAG_TYPE_UNK	0x00F0

#define RTF_INBODY			0x0000
#define RTF_INHEAD			0x0001
#define RTF_INHTML			0x0002
#define RTF_OUTHTML			0x0003

#define RTF_FLAG_INPAR		0x0004
#define RTF_FLAG_CLOSE		0x0008
#define RTF_FLAG_MHTML		0x0100

#endif // UTIL_H
